/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillHolder;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import java.util.List;
import java.util.Optional;

public abstract class SkillTargeter {
    private final MythicBukkit plugin;
    private final SkillExecutor manager;
    protected MythicLineConfig config;
    protected Optional<SkillHolder> parent = Optional.empty();
    protected String targetConditionString;
    protected List<SkillCondition> targetConditions = null;
    protected boolean sudoParent;
    protected boolean sudoOwner;
    protected boolean sudoTrigger;

    public SkillTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        this.plugin = (MythicBukkit)manager.getPlugin();
        this.manager = manager;
        this.config = mlc;
        this.targetConditionString = mlc.getString(new String[]{"targetconditions", "conditions", "cond", "c"}, "null", new String[0]);
        this.sudoParent = mlc.getBoolean(new String[]{"parent", "asparent", "ofparent", "fromparent", "sudoparent"}, false);
        this.sudoOwner = mlc.getBoolean(new String[]{"owner", "asowner", "ofowner", "fromowner", "sudoowner"}, false);
        this.sudoTrigger = mlc.getBoolean(new String[]{"trigger", "astrigger", "oftrigger", "fromtrigger", "sudotrigger"}, false);
        if (MythicBukkit.isVolatile() && this.targetConditionString != null) {
            this.targetConditions = this.getPlugin().getSkillManager().getConditions(this.targetConditionString);
        }
    }

    public void setParent(SkillHolder parent) {
        this.parent = Optional.ofNullable(parent);
    }

    public String toString() {
        return this.getClass().getName();
    }

    public MythicBukkit getPlugin() {
        return this.plugin;
    }

    public SkillExecutor getManager() {
        return this.manager;
    }

    public Optional<SkillHolder> getParent() {
        return this.parent;
    }

    public boolean isSudoParent() {
        return this.sudoParent;
    }

    public boolean isSudoOwner() {
        return this.sudoOwner;
    }

    public boolean isSudoTrigger() {
        return this.sudoTrigger;
    }
}

