/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.audience;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.core.skills.SkillAudience;
import io.lumine.mythic.core.utils.annotations.MythicAudience;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@MythicAudience(name="nearby", aliases={}, version="5.4", description="All players nearby")
public class NearbyAudience
extends SkillAudience {
    public NearbyAudience(MythicLineConfig mlc) {
        super(mlc);
    }

    @Override
    public Collection<AbstractPlayer> get(SkillMetadata data, AbstractEntity target) {
        ArrayList targets = Lists.newArrayList();
        AbstractWorld world = data.getCaster().getEntity().getWorld();
        if (world == null) {
            return targets;
        }
        List<AbstractPlayer> players = NearbyAudience.getPlugin().getEntityManager().getPlayers(world);
        if (players == null) {
            return targets;
        }
        for (AbstractPlayer player : players) {
            if (!player.getWorld().equals(data.getOrigin().getWorld()) || !(player.getLocation().distanceSquared(data.getOrigin()) < 65536.0)) continue;
            targets.add(player);
        }
        return targets;
    }
}

