/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.spawning.random.RandomSpawnPoint;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;
import io.lumine.mythic.core.utils.MythicUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class CompositeCondition
extends SkillCondition {
    private TreeNode root;
    private SkillExecutor manager;

    public CompositeCondition(SkillExecutor manager, String line) {
        super(line);
        this.manager = manager;
        line = line.trim();
        List<String> splitList = MythicUtil.splitIgnoringParentheses(line);
        this.root = this.buildTree(splitList.get(0));
    }

    private TreeNode buildTree(String input) {
        if (input == null || input.isEmpty()) {
            return null;
        }
        input = this.removeOuterParentheses(input);
        int depth = 0;
        ArrayList<String> parts = new ArrayList<String>();
        ArrayList<Character> operators = new ArrayList<Character>();
        int lastSplit = -1;
        for (int i = 0; i < input.length() - 1; ++i) {
            char c = input.charAt(i);
            char nextC = input.charAt(i + 1);
            if (c == '(') {
                ++depth;
                continue;
            }
            if (c == ')') {
                --depth;
                continue;
            }
            if ((c != '&' || nextC != '&') && (c != '|' || nextC != '|') || depth != 0) continue;
            parts.add(input.substring(lastSplit + 1, i).trim());
            operators.add(Character.valueOf(c));
            lastSplit = i + 1;
            ++i;
        }
        parts.add(input.substring(lastSplit + 1).trim());
        if (parts.size() == 1) {
            return new ConditionNode(this.manager.getCondition((String)parts.get(0)));
        }
        OperatorNode rootNode = null;
        TreeNode currentNode = null;
        for (int i = 0; i < parts.size() - 1; ++i) {
            String leftPart = (String)parts.get(i);
            String rightPart = (String)parts.get(i + 1);
            char operator = ((Character)operators.get(i)).charValue();
            TreeNode left = this.buildTree(leftPart);
            TreeNode right = this.buildTree(rightPart);
            OperatorNode operatorNode = new OperatorNode(operator == '&' ? Operator.AND : Operator.OR);
            operatorNode.setLeft(left);
            operatorNode.setRight(right);
            if (rootNode == null) {
                rootNode = operatorNode;
            } else {
                currentNode.setRight(operatorNode);
            }
            currentNode = operatorNode;
        }
        return rootNode;
    }

    private String removeOuterParentheses(String input) {
        int openParentheses = 0;
        int closeParentheses = 0;
        int startIndex = -1;
        int endIndex = -1;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '(') {
                ++openParentheses;
                if (startIndex != -1) continue;
                startIndex = i;
                continue;
            }
            if (c != ')' || ++closeParentheses != openParentheses) continue;
            endIndex = i;
            break;
        }
        if (startIndex == 0 && endIndex == input.length() - 1) {
            return input.substring(1, input.length() - 1);
        }
        return input;
    }

    @Override
    public boolean evaluateEntity(AbstractEntity target) {
        return this.handleOutcome(this.root.evaluateEntity(target));
    }

    @Override
    public boolean evaluateToEntity(SkillMetadata data, AbstractEntity t2) {
        return this.handleOutcome(this.root.evaluateToEntity(data, t2));
    }

    @Override
    public boolean evaluateToEntity(AbstractEntity base, AbstractEntity t2) {
        return this.handleOutcome(this.root.evaluateToEntity(base, t2));
    }

    @Override
    public boolean evaluateToLocation(AbstractEntity base, AbstractLocation location) {
        return this.handleOutcome(this.root.evaluateToLocation(base, location));
    }

    @Override
    public boolean evaluateCaster(SkillMetadata meta) {
        return this.handleOutcome(meta, this.root.evaluateCaster(meta));
    }

    @Override
    public boolean evaluateTrigger(SkillMetadata meta) {
        return this.handleOutcome(meta, this.root.evaluateTrigger(meta));
    }

    @Override
    public boolean evaluateTargets(SkillMetadata meta) {
        if (meta.getEntityTargets() != null && meta.getEntityTargets().size() > 0) {
            HashSet targets = Sets.newHashSet(meta.getEntityTargets());
            targets.removeIf(target -> {
                if (target == null || target.isDead() || !target.isValid()) {
                    return true;
                }
                return !this.handleOutcome(meta, this.root.evaluateToEntity(meta, (AbstractEntity)target));
            });
            meta.setEntityTargets(targets);
            if (targets.size() == 0) {
                return false;
            }
        } else if (meta.getLocationTargets() != null && meta.getLocationTargets().size() > 0) {
            HashSet targets = Sets.newHashSet(meta.getLocationTargets());
            targets.removeIf(target -> !this.handleOutcome(meta, this.root.evaluateToLocation(meta.getCaster().getEntity(), (AbstractLocation)target)));
            meta.setLocationTargets(targets);
            if (targets.size() == 0) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public boolean evaluateRandomSpawnPoint(RandomSpawnPoint rsp) {
        return this.handleOutcome(rsp, this.root.evaluateRandomSpawnPoint(rsp));
    }

    @Override
    public boolean evaluateSpawner(MythicSpawner spawner, AbstractLocation spawnLocation) {
        return this.handleOutcome(spawner, this.root.evaluateSpawner(spawner, spawnLocation));
    }

    @Override
    public boolean evaluateDropper(DropMetadata meta) {
        return this.handleOutcome(meta, this.root.evaluateDropper(meta));
    }

    @Override
    public boolean evaluateDropCause(DropMetadata meta) {
        return this.handleOutcome(meta, this.root.evaluateDropCause(meta));
    }

    public void printTree() {
        this.printTreeHelper(this.root, 0);
    }

    private void printTreeHelper(TreeNode node, int depth) {
        if (node == null) {
            return;
        }
        String indentation = String.join((CharSequence)"", Collections.nCopies(depth * 2, " "));
        if (node instanceof ConditionNode) {
            ConditionNode conditionNode = (ConditionNode)node;
            System.out.println(indentation + "Condition: " + conditionNode.getCondition());
        } else if (node instanceof OperatorNode) {
            OperatorNode operatorNode = (OperatorNode)node;
            System.out.println(indentation + "Operator: " + operatorNode.getOperator());
        }
        this.printTreeHelper(node.getLeft(), depth + 1);
        this.printTreeHelper(node.getRight(), depth + 1);
    }

    private static abstract class TreeNode {
        protected TreeNode left;
        protected TreeNode right;

        public abstract boolean evaluateEntity(AbstractEntity var1);

        public abstract boolean evaluateToEntity(SkillMetadata var1, AbstractEntity var2);

        public abstract boolean evaluateToEntity(AbstractEntity var1, AbstractEntity var2);

        public abstract boolean evaluateToLocation(AbstractEntity var1, AbstractLocation var2);

        public abstract boolean evaluateCaster(SkillMetadata var1);

        public abstract boolean evaluateTrigger(SkillMetadata var1);

        public abstract boolean evaluateTargets(SkillMetadata var1);

        public abstract boolean evaluateRandomSpawnPoint(RandomSpawnPoint var1);

        public abstract boolean evaluateSpawner(MythicSpawner var1, AbstractLocation var2);

        public abstract boolean evaluateDropper(DropMetadata var1);

        public abstract boolean evaluateDropCause(DropMetadata var1);

        public TreeNode getLeft() {
            return this.left;
        }

        public TreeNode getRight() {
            return this.right;
        }

        public void setLeft(TreeNode left) {
            this.left = left;
        }

        public void setRight(TreeNode right) {
            this.right = right;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TreeNode)) {
                return false;
            }
            TreeNode other = (TreeNode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TreeNode this$left = this.getLeft();
            TreeNode other$left = other.getLeft();
            if (this$left == null ? other$left != null : !((Object)this$left).equals(other$left)) {
                return false;
            }
            TreeNode this$right = this.getRight();
            TreeNode other$right = other.getRight();
            return !(this$right == null ? other$right != null : !((Object)this$right).equals(other$right));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TreeNode;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TreeNode $left = this.getLeft();
            result = result * 59 + ($left == null ? 43 : ((Object)$left).hashCode());
            TreeNode $right = this.getRight();
            result = result * 59 + ($right == null ? 43 : ((Object)$right).hashCode());
            return result;
        }

        public String toString() {
            return "CompositeCondition.TreeNode(left=" + this.getLeft() + ", right=" + this.getRight() + ")";
        }
    }

    private static class ConditionNode
    extends TreeNode {
        private final SkillCondition condition;

        public ConditionNode(SkillCondition condition) {
            this.condition = condition;
        }

        @Override
        public boolean evaluateEntity(AbstractEntity t2) {
            return this.condition.evaluateEntity(t2);
        }

        @Override
        public boolean evaluateToEntity(SkillMetadata data, AbstractEntity t2) {
            return this.condition.evaluateToEntity(data, t2);
        }

        @Override
        public boolean evaluateToEntity(AbstractEntity base, AbstractEntity t2) {
            return this.condition.evaluateToEntity(base, t2);
        }

        @Override
        public boolean evaluateToLocation(AbstractEntity base, AbstractLocation location) {
            return this.condition.evaluateToLocation(base, location);
        }

        @Override
        public boolean evaluateCaster(SkillMetadata meta) {
            return this.condition.evaluateCaster(meta);
        }

        @Override
        public boolean evaluateTrigger(SkillMetadata meta) {
            return this.condition.evaluateTrigger(meta);
        }

        @Override
        public boolean evaluateTargets(SkillMetadata meta) {
            return this.condition.evaluateTargets(meta);
        }

        @Override
        public boolean evaluateRandomSpawnPoint(RandomSpawnPoint rsp) {
            return this.condition.evaluateRandomSpawnPoint(rsp);
        }

        @Override
        public boolean evaluateSpawner(MythicSpawner spawner, AbstractLocation spawnLocation) {
            return this.condition.evaluateSpawner(spawner, spawnLocation);
        }

        @Override
        public boolean evaluateDropper(DropMetadata meta) {
            return this.condition.evaluateDropper(meta);
        }

        @Override
        public boolean evaluateDropCause(DropMetadata meta) {
            return this.condition.evaluateDropCause(meta);
        }

        public SkillCondition getCondition() {
            return this.condition;
        }
    }

    private static class OperatorNode
    extends TreeNode {
        private final Operator operator;

        public OperatorNode(Operator operator) {
            this.operator = operator;
        }

        @Override
        public boolean evaluateEntity(AbstractEntity t2) {
            if (this.operator == Operator.AND) {
                return this.left.evaluateEntity(t2) && this.right.evaluateEntity(t2);
            }
            return this.left.evaluateEntity(t2) || this.right.evaluateEntity(t2);
        }

        @Override
        public boolean evaluateToEntity(SkillMetadata data, AbstractEntity t2) {
            if (this.operator == Operator.AND) {
                return this.left.evaluateToEntity(data, t2) && this.right.evaluateToEntity(data, t2);
            }
            return this.left.evaluateToEntity(data, t2) || this.right.evaluateToEntity(data, t2);
        }

        @Override
        public boolean evaluateToEntity(AbstractEntity base, AbstractEntity t2) {
            if (this.operator == Operator.AND) {
                return this.left.evaluateToEntity(base, t2) && this.right.evaluateToEntity(base, t2);
            }
            return this.left.evaluateToEntity(base, t2) || this.right.evaluateToEntity(base, t2);
        }

        @Override
        public boolean evaluateToLocation(AbstractEntity base, AbstractLocation location) {
            if (this.operator == Operator.AND) {
                return this.left.evaluateToLocation(base, location) && this.right.evaluateToLocation(base, location);
            }
            return this.left.evaluateToLocation(base, location) || this.right.evaluateToLocation(base, location);
        }

        @Override
        public boolean evaluateCaster(SkillMetadata meta) {
            if (this.operator == Operator.AND) {
                return this.left.evaluateCaster(meta) && this.right.evaluateCaster(meta);
            }
            return this.left.evaluateCaster(meta) || this.right.evaluateCaster(meta);
        }

        @Override
        public boolean evaluateTrigger(SkillMetadata meta) {
            if (this.operator == Operator.AND) {
                return this.left.evaluateTrigger(meta) && this.right.evaluateTrigger(meta);
            }
            return this.left.evaluateTrigger(meta) || this.right.evaluateTrigger(meta);
        }

        @Override
        public boolean evaluateTargets(SkillMetadata meta) {
            if (this.operator == Operator.AND) {
                return this.left.evaluateTargets(meta) && this.right.evaluateTargets(meta);
            }
            return this.left.evaluateTargets(meta) || this.right.evaluateTargets(meta);
        }

        @Override
        public boolean evaluateRandomSpawnPoint(RandomSpawnPoint rsp) {
            if (this.operator == Operator.AND) {
                return this.left.evaluateRandomSpawnPoint(rsp) && this.right.evaluateRandomSpawnPoint(rsp);
            }
            return this.left.evaluateRandomSpawnPoint(rsp) || this.right.evaluateRandomSpawnPoint(rsp);
        }

        @Override
        public boolean evaluateSpawner(MythicSpawner spawner, AbstractLocation spawnLocation) {
            if (this.operator == Operator.AND) {
                return this.left.evaluateSpawner(spawner, spawnLocation) && this.right.evaluateSpawner(spawner, spawnLocation);
            }
            return this.left.evaluateSpawner(spawner, spawnLocation) || this.right.evaluateSpawner(spawner, spawnLocation);
        }

        @Override
        public boolean evaluateDropper(DropMetadata meta) {
            if (this.operator == Operator.AND) {
                return this.left.evaluateDropper(meta) && this.right.evaluateDropper(meta);
            }
            return this.left.evaluateDropper(meta) || this.right.evaluateDropper(meta);
        }

        @Override
        public boolean evaluateDropCause(DropMetadata meta) {
            if (this.operator == Operator.AND) {
                return this.left.evaluateDropCause(meta) && this.right.evaluateDropCause(meta);
            }
            return this.left.evaluateDropCause(meta) || this.right.evaluateDropCause(meta);
        }

        public Operator getOperator() {
            return this.operator;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OperatorNode)) {
                return false;
            }
            OperatorNode other = (OperatorNode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Operator this$operator = this.getOperator();
            Operator other$operator = other.getOperator();
            return !(this$operator == null ? other$operator != null : !((Object)((Object)this$operator)).equals((Object)other$operator));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof OperatorNode;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Operator $operator = this.getOperator();
            result = result * 59 + ($operator == null ? 43 : ((Object)((Object)$operator)).hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "CompositeCondition.OperatorNode(operator=" + this.getOperator() + ")";
        }
    }

    protected static enum Operator {
        AND,
        OR;

    }
}

