/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractBlock;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.ILocationCondition;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.Collection;
import java.util.List;

@MythicCondition(author="Ashijin", name="blockType", aliases={}, description="Tests the material type present at the target location")
public class BlockTypeCondition
extends SkillCondition
implements ILocationCondition {
    @MythicField(name="types", aliases={"types", "type", "t", "material", "mat", "m"}, description="A list of materials to check")
    private Collection<AbstractBlock> types = Sets.newHashSet();

    public BlockTypeCondition(String line, MythicLineConfig mlc) {
        super(line);
        BlockTypeCondition.getPlugin().getClock().queuePostReload(() -> {
            List<String> b = mlc.getStringList(new String[]{"types", "type", "t", "material", "mat", "m"}, "DIRT", this.conditionVar);
            for (String s2 : b) {
                AbstractBlock block = BlockTypeCondition.getPlugin().getBootstrap().getBlock(s2);
                if (block instanceof AbstractBlock.InvalidBlock) {
                    MythicLogger.errorConditionConfig(this, mlc, "'" + s2 + "' is not a valid block type.");
                    return;
                }
                this.types.add(block);
            }
        });
    }

    @Override
    public boolean check(AbstractLocation location) {
        for (AbstractBlock type : this.types) {
            if (!type.matches(location)) continue;
            return true;
        }
        return false;
    }
}

