/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.ILocationCondition;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;

@MythicCondition(author="Ashijin", name="onBlock", aliases={}, description="Matches the block the target entity is standing on")
public class OnBlockCondition
extends SkillCondition
implements ILocationCondition {
    @MythicField(name="material", aliases={"m"}, description="A list of materials")
    private Set<Material> blocks = new HashSet<Material>();

    public OnBlockCondition(String line, MythicLineConfig config) {
        super(line);
        String[] split;
        String materials = config.getString(new String[]{"type", "material", "m", "block", "b"}, "STONE", new String[0]);
        for (String block : split = materials.split(",")) {
            try {
                Material m4 = Material.valueOf((String)block.toUpperCase());
                this.blocks.add(m4);
            }
            catch (Exception ex) {
                MythicLogger.errorConditionConfig(this, config, "'" + block + "' is not a valid Material");
            }
        }
    }

    @Override
    public boolean check(AbstractLocation l) {
        Material mat = BukkitAdapter.adapt(l).getBlock().getRelative(BlockFace.DOWN).getType();
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Checking OnBlock: {0} vs {1}", mat.toString(), this.blocks.toString());
        return this.blocks.contains(mat);
    }
}

