/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;

@MythicMechanic(name="attribute", aliases={"setAttribute"}, description="Sets the mob's attribute")
public class AttributeMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
INoTargetSkill {
    @MythicField(name="attribute", aliases={"attr"}, defValue="GENERIC_LUCK", description="The attribute to modify.")
    private final Attribute attribute;
    @MythicField(name="amount", aliases={"amt", "a"}, defValue="0", description="The amount by which to modify the attribute.")
    private final PlaceholderDouble amount;
    @MythicField(name="duration", aliases={"dur"}, defValue="0", description="The duration of the attribute modification in ticks.")
    private final PlaceholderInt duration;

    public AttributeMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.attribute = mlc.getEnum(new String[]{"attribute", "attr"}, Attribute.class, Attribute.GENERIC_LUCK, "Not a valid attribute given");
        this.amount = mlc.getPlaceholderDouble(new String[]{"amount", "amt", "a"}, 0.0, new String[0]);
        this.duration = mlc.getPlaceholderInteger(new String[]{"duration", "dur"}, 0, new String[0]);
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        Entity entity = data.getCaster().getEntity().getBukkitEntity();
        if (!(entity instanceof Attributable)) {
            return SkillResult.INVALID_TARGET;
        }
        Attributable entity2 = (Attributable)entity;
        AttributeInstance attr = entity2.getAttribute(this.attribute);
        double original = attr.getBaseValue();
        attr.setBaseValue(this.amount.get(data));
        int duration = this.duration.get(data);
        if (duration > 0) {
            Schedulers.sync().runLater(() -> attr.setBaseValue(original), duration);
        }
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Entity entity = target.getBukkitEntity();
        if (!(entity instanceof Attributable)) {
            return SkillResult.INVALID_TARGET;
        }
        Attributable entity2 = (Attributable)entity;
        AttributeInstance attr = entity2.getAttribute(this.attribute);
        double original = attr.getBaseValue();
        attr.setBaseValue(this.amount.get(data));
        int duration = this.duration.get(data);
        if (duration > 0) {
            Schedulers.sync().runLater(() -> attr.setBaseValue(original), duration);
        }
        return SkillResult.SUCCESS;
    }
}

