/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.mechanics.ParticleEffect;
import io.lumine.mythic.core.utils.MythicUtil;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.Collection;

@MythicMechanic(author="Ashijin", name="effect:particlelinering", aliases={"particlelinering", "particleringline"})
public class ParticleLineRingEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected float distanceBetween;
    protected float startYOffset;
    protected float targetYOffset;
    protected boolean fromOrigin;
    protected int ringPoints;
    protected double ringRadius;
    protected double maxDistance;

    public ParticleLineRingEffect(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.ASYNC_ONLY;
        this.startYOffset = mlc.getFloat(new String[]{"startyoffset", "syo", "ystartoffset", "ys"}, 0.0f);
        this.targetYOffset = mlc.getFloat(new String[]{"targetyoffset", "tyo", "ytargetoffset", "yt"}, 0.0f);
        this.distanceBetween = mlc.getFloat(new String[]{"distancebetween", "db"}, 1.0f);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
        this.ringPoints = mlc.getInteger(new String[]{"ringpoints", "rp"}, 16);
        this.ringRadius = mlc.getDouble(new String[]{"ringradius", "rr"}, 0.5);
        this.maxDistance = mlc.getDouble(new String[]{"maxdistance", "md"}, 256.0);
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        Collection<AbstractPlayer> audience = this.audience.get(data, null);
        this.playParticleLineEffect(data, target, audience);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Collection<AbstractPlayer> audience = this.audience.get(data, target);
        this.playParticleLineEffect(data, target.getLocation(), audience);
        return SkillResult.SUCCESS;
    }

    protected void playParticleLineEffect(SkillMetadata data, AbstractLocation target, Collection<AbstractPlayer> audience) {
        int c;
        double distance;
        SkillCaster am = data.getCaster();
        AbstractLocation origin = data.getOrigin();
        AbstractLocation targetLocation = target.clone().add(0.0, this.targetYOffset, 0.0);
        AbstractLocation startLocation = this.fromOrigin ? origin.add(0.0, this.startYOffset, 0.0) : (this.useEyeLocation ? am.getEntity().getEyeLocation() : am.getEntity().getLocation().add(0.0, this.startYOffset, 0.0));
        if (this.setYaw) {
            startLocation.setYaw(this.yaw);
        }
        if (this.setPitch) {
            startLocation.setPitch(this.pitch);
        }
        if (this.startForwardOffset != 0.0f) {
            startLocation = MythicUtil.move(startLocation, this.startForwardOffset, 0.0, 0.0);
        }
        if (this.startSideOffset.get(data) != 0.0f) {
            startLocation = MythicUtil.move(startLocation, 0.0, 0.0, this.startSideOffset.get(data));
        }
        if ((distance = startLocation.distance(targetLocation)) > this.maxDistance) {
            distance = this.maxDistance;
        }
        if ((c = (int)Math.ceil(distance / (double)this.distanceBetween) - 1) <= 0) {
            return;
        }
        AbstractVector direction = targetLocation.toVector().subtract(startLocation.toVector()).normalize().multiply(this.distanceBetween);
        AbstractLocation l2 = startLocation.clone().add(0.0, this.yOffset.get(data), 0.0);
        boolean step = false;
        for (int i = 0; i < c; ++i) {
            l2.add(direction);
            AbstractVector up = Math.abs(direction.getY()) < 0.99 ? new AbstractVector(0, 1, 0) : new AbstractVector(1, 0, 0);
            AbstractVector side = direction.crossProduct(up).normalize();
            up = direction.crossProduct(side).normalize();
            for (int j = 0; j < c; ++j) {
                double angle = Math.PI * 2 * (double)j / (double)c;
                double xOffset = this.ringRadius * Math.cos(angle);
                double zOffset = this.ringRadius * Math.sin(angle);
                AbstractVector offset = side.clone().multiply(xOffset).add(up.clone().multiply(zOffset));
                AbstractLocation particleLocation = l2.clone().add(offset);
                this.playParticleEffect(data, particleLocation, audience);
            }
        }
    }
}

