/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@MythicMechanic(author="Ashijin", name="potionclear", aliases={"clearpotions", "clearpotion"}, description="Clears all potion effects on the target entity")
public class PotionClearMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private PlaceholderString types;

    public PotionClearMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.types = mlc.getPlaceholderString(new String[]{"types", "type", "t"}, null, new String[0]);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (this.types == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String types = this.types.get((PlaceholderMeta)data, target);
        LivingEntity bukkitEntity = (LivingEntity)target.getBukkitEntity();
        if (types.isEmpty()) {
            for (PotionEffect pe : bukkitEntity.getActivePotionEffects()) {
                bukkitEntity.removePotionEffect(pe.getType());
            }
        } else if (types.contains(",")) {
            for (String type : types.split(",")) {
                try {
                    PotionEffectType potionType = PotionEffectType.getByName((String)type);
                    if (potionType == null) {
                        return SkillResult.INVALID_CONFIG;
                    }
                    bukkitEntity.removePotionEffect(potionType);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        } else {
            try {
                PotionEffectType potionType = PotionEffectType.getByName((String)types);
                if (potionType == null) {
                    return SkillResult.INVALID_CONFIG;
                }
                bukkitEntity.removePotionEffect(potionType);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return SkillResult.SUCCESS;
    }
}

