/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.compatibility.AbstractModelEngineSupport;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.MythicUtil;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;

@MythicMechanic(author="Ashijin", name="raytraceTo", premium=true, aliases={}, description="Executes a skill with the result of a raytrace to the target location")
public class RaytraceToMechanic
extends SkillMechanic
implements ITargetedLocationSkill {
    protected String strEntitySkill;
    protected String strLocationSkill;
    protected String strHeadshotSkill;
    protected Optional<Skill> entitySkill = Optional.empty();
    protected Optional<Skill> locationSkill = Optional.empty();
    protected Optional<Skill> headshotSkill = Optional.empty();
    protected String rtConditionString;
    protected double maxDistance;
    protected double rayWidth;
    protected boolean ignorePassableBlocks;
    protected FluidCollisionMode fluidCollisionMode;
    protected float projectileVelocityAccuracy;
    protected float projectileVelocityVertNoise;
    protected float projectileVelocityHorizNoise;
    protected float projectileVelocityVertNoiseBase;
    protected float projectileVelocityHorizNoiseBase;
    protected float headshotMultiplier;
    @MythicField(name="raytraceConditions", aliases={"rconditions", "rcond", "rc"}, defValue="NONE", version="4.10", description="Conditions applied to the bounce target")
    protected List<SkillCondition> raytraceConditions = null;
    protected float startYOffset;
    protected float targetYOffset;
    protected boolean fromOrigin;
    protected boolean useEyeLocation;
    protected float startForwardOffset;
    protected float startSideOffset;

    public RaytraceToMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.target_creative = true;
        if (!MythicBukkit.isVolatile()) {
            MythicLogger.errorMechanicConfig(this, mlc, "RayTraceTo mechanic requires Mythic Premium");
            return;
        }
        this.strEntitySkill = mlc.getString(new String[]{"entityskill", "eskill", "es"}, null, new String[0]);
        this.strLocationSkill = mlc.getString(new String[]{"locationskill", "lskill", "ls"}, null, new String[0]);
        this.strHeadshotSkill = mlc.getString(new String[]{"headshotskill", "hsskill", "hs"}, null, new String[0]);
        this.maxDistance = mlc.getDouble(new String[]{"maxdistance", "distance", "md", "d"}, 50.0);
        this.rayWidth = mlc.getDouble(new String[]{"raywidth", "rw", "w"}, 0.2);
        this.ignorePassableBlocks = mlc.getBoolean(new String[]{"ignorepassableblocks", "ignorepassable", "ip"}, true);
        try {
            String strFluidCollisionMode = mlc.getString(new String[]{"fluidcollisionmode", "fcm"}, "NEVER", new String[0]);
            this.fluidCollisionMode = FluidCollisionMode.valueOf((String)strFluidCollisionMode.toUpperCase());
        }
        catch (Error | Exception ex) {
            this.fluidCollisionMode = FluidCollisionMode.NEVER;
        }
        this.projectileVelocityAccuracy = mlc.getFloat(new String[]{"accuracy", "ac", "a"}, 1.0f);
        float defNoise = (1.0f - this.projectileVelocityAccuracy) * 45.0f;
        this.projectileVelocityVertNoise = mlc.getFloat(new String[]{"verticalnoise", "vn"}, defNoise) / 10.0f;
        this.projectileVelocityHorizNoise = mlc.getFloat(new String[]{"horizontalnoise", "hn"}, defNoise) * 5.0f;
        this.projectileVelocityVertNoiseBase = 0.0f - this.projectileVelocityVertNoise / 2.0f;
        this.projectileVelocityHorizNoiseBase = 0.0f - this.projectileVelocityHorizNoise / 2.0f;
        this.headshotMultiplier = mlc.getFloat(new String[]{"headshotmultiplier", "hsmultipler", "hsm"}, 1.0f);
        this.rtConditionString = mlc.getString(new String[]{"raytraceConditions", "rconditions", "rcond", "rc"}, null, new String[0]);
        ((MythicBukkit)this.getPlugin()).getSkillManager().queueSecondPass(() -> {
            if (this.strEntitySkill != null) {
                this.entitySkill = ((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(file, this, this.strEntitySkill);
                if (this.entitySkill.isEmpty()) {
                    MythicLogger.errorMechanicConfig(this, mlc, "Could not find RayTrace Entity MetaSkill " + this.entitySkill);
                } else {
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Loaded RayTraceMechanic EntitySkill successfully", new Object[0]);
                }
            }
            if (this.strLocationSkill != null) {
                this.locationSkill = ((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(file, this, this.strLocationSkill);
                if (this.locationSkill.isEmpty()) {
                    MythicLogger.errorMechanicConfig(this, mlc, "Could not find RayTrace Location MetaSkill " + this.locationSkill);
                } else {
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Loaded RayTraceMechanic LocationSkill successfully", new Object[0]);
                }
            }
            if (this.strHeadshotSkill != null) {
                this.headshotSkill = ((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(file, this, this.strHeadshotSkill);
                if (this.headshotSkill.isEmpty()) {
                    MythicLogger.errorMechanicConfig(this, mlc, "Could not find RayTrace Location MetaSkill " + this.headshotSkill);
                } else {
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Loaded RayTraceMechanic LocationSkill successfully", new Object[0]);
                }
            }
            if (this.rtConditionString != null) {
                this.raytraceConditions = ((MythicBukkit)this.getPlugin()).getSkillManager().getConditions(this.rtConditionString);
            }
        });
        this.startYOffset = mlc.getFloat(new String[]{"startyoffset", "syo", "ystartoffset", "ys"}, 0.0f);
        this.targetYOffset = mlc.getFloat(new String[]{"targetyoffset", "tyo", "ytargetoffset", "yt"}, 0.0f);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
        this.useEyeLocation = mlc.getBoolean(new String[]{"useeyelocation", "uel"}, false);
        this.startForwardOffset = mlc.getFloat(new String[]{"forwardoffset", "startfoffset", "sfo"}, 0.0f);
        this.startSideOffset = mlc.getFloat(new String[]{"sideoffset", "soffset", "sso"}, 0.0f);
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        float noise;
        if (!MythicBukkit.isVolatile()) {
            MythicLogger.errorMechanicConfig(this, this.config, "RayTraceTo mechanic requires Mythic Premium");
            return SkillResult.REQUIRES_PREMIUM;
        }
        SkillCaster am = data.getCaster();
        AbstractLocation origin = data.getOrigin();
        AbstractLocation targetLocation = target.clone().add(0.0, this.targetYOffset, 0.0);
        AbstractLocation startLocation = this.fromOrigin ? origin.add(0.0, this.startYOffset, 0.0) : (this.useEyeLocation ? am.getEntity().getEyeLocation().add(0.0, this.startYOffset, 0.0) : am.getEntity().getLocation().add(0.0, this.startYOffset, 0.0));
        if (this.startForwardOffset != 0.0f) {
            startLocation = MythicUtil.move(startLocation, this.startForwardOffset, 0.0, 0.0);
        }
        if (this.startSideOffset != 0.0f) {
            startLocation = MythicUtil.move(startLocation, 0.0, 0.0, this.startSideOffset);
        }
        AbstractVector aDirection = targetLocation.toVector().subtract(startLocation.toVector()).normalize();
        LivingEntity caster = (LivingEntity)data.getCaster().getEntity().getBukkitEntity();
        if (this.projectileVelocityHorizNoise > 0.0f) {
            noise = (float)((double)this.projectileVelocityHorizNoiseBase + Numbers.randomDouble() * (double)this.projectileVelocityHorizNoise);
            aDirection.rotate(noise);
        }
        if (this.projectileVelocityVertNoise > 0.0f) {
            noise = (float)((double)this.projectileVelocityVertNoiseBase + Numbers.randomDouble() * (double)this.projectileVelocityVertNoise);
            aDirection.add(new AbstractVector(0.0f, noise, 0.0f)).normalize();
        }
        Optional<AbstractModelEngineSupport> megSupport = ((MythicBukkit)this.getPlugin()).getCompatibility().getModelEngine();
        RayTraceResult result = ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getWorldHandler().rayTrace(BukkitAdapter.adapt(startLocation), BukkitAdapter.adapt(aDirection), this.maxDistance, this.fluidCollisionMode, this.rayWidth, entity -> {
            AbstractModelEngineSupport meg;
            if (entity.getUniqueId().equals(caster.getUniqueId())) {
                return false;
            }
            if (megSupport.isPresent() && (meg = (AbstractModelEngineSupport)megSupport.get()).getParentUUID(entity.getUniqueId()).equals(caster.getUniqueId())) {
                return false;
            }
            if (this.raytraceConditions != null) {
                for (SkillCondition condition : this.raytraceConditions) {
                    if (condition.evaluateEntity(BukkitAdapter.adapt(entity))) continue;
                    return false;
                }
            }
            return true;
        }, material -> material == Material.BARRIER);
        if (result != null) {
            if (this.entitySkill.isPresent() && result.getHitEntity() != null) {
                Skill skill;
                Skill headshotSkill;
                AbstractEntity aEntity = BukkitAdapter.adapt(result.getHitEntity());
                boolean headshot = false;
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "RaytraceTo hit {0}", aEntity.getUniqueId());
                if (result.getHitPosition().getY() - aEntity.getLocation().getY() >= result.getHitEntity().getBoundingBox().getHeight() - 0.4) {
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Mechanic was a headshot", new Object[0]);
                    data.setPower(data.getPower() * this.headshotMultiplier);
                    headshot = true;
                }
                SkillMetadata entityData = data.deepClone().setEntityTarget(aEntity);
                if (this.headshotSkill.isPresent() && headshot && (headshotSkill = this.headshotSkill.get()).isUsable(entityData)) {
                    headshotSkill.execute(entityData);
                }
                if ((skill = this.entitySkill.get()).isUsable(entityData)) {
                    skill.execute(entityData);
                } else {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "RaytraceTo skill failed: not usable", new Object[0]);
                }
            }
            if (this.locationSkill.isPresent()) {
                AbstractLocation aLocation = BukkitAdapter.adapt(result.getHitPosition().toLocation(caster.getWorld()));
                SkillMetadata locationData = data.deepClone().setLocationTarget(aLocation);
                Skill skill = this.locationSkill.get();
                if (skill.isUsable(locationData)) {
                    skill.execute(locationData);
                }
            }
        } else if (this.locationSkill.isPresent()) {
            AbstractLocation aLocation = BukkitAdapter.adapt(((Player)BukkitAdapter.adapt(data.getCaster().getEntity())).getTargetBlock(((MythicBukkit)this.getPlugin()).getConfiguration().getTransparentBlocks(), (int)this.maxDistance).getLocation());
            SkillMetadata locationData = data.deepClone().setLocationTarget(aLocation);
            Skill skill = this.locationSkill.get();
            if (skill.isUsable(locationData)) {
                skill.execute(locationData);
            }
        }
        return SkillResult.SUCCESS;
    }
}

