/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.adapters.SkillAdapter;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.compatibility.CompatibilityManager;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.bukkit.utils.terminable.TerminableRegistry;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMetadataImpl;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.skills.damage.DamagingMechanic;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.utils.MythicUtil;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Trident;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;

@MythicMechanic(author="Ashijin", name="shoot", aliases={"shootprojetile"}, description="Shoots a projectile at the target location")
public class ShootMechanic
extends DamagingMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected ProjectileType projectileType = ProjectileType.REGULAR;
    protected PlaceholderDouble damage;
    protected PlaceholderInt maxdistance;
    protected float startYOffset;
    protected float startForwardOffset;
    protected float startSideOffset;
    protected PlaceholderDouble projectileVelocity;
    protected PlaceholderFloat projectileVelocityVertOffset;
    protected PlaceholderFloat projectileVelocityHorizOffset;
    protected float projectileVelocityAccuracy;
    protected float projectileVelocityVertNoise;
    protected float projectileVelocityHorizNoise;
    protected float projectileVelocityVertNoiseBase;
    protected float projectileVelocityHorizNoiseBase;
    protected boolean powerAffectsVelocity;
    protected Class<? extends Projectile> projectileClass;
    protected ItemStack projectileItem;
    protected Optional<Skill> onTickSkill = Optional.empty();
    protected Optional<Skill> onHitSkill = Optional.empty();
    protected Optional<Skill> onEndSkill = Optional.empty();
    protected int tickInterval;
    protected String onTickSkillName;
    protected String onHitSkillName;
    protected String onEndSkillName;
    protected String onStartSkillName;
    protected Boolean adjustVelocity;
    protected Boolean bounce;
    protected Boolean canPickup;
    protected int pierceLevel;
    protected int knockbackStrength;
    protected int expirationTime;
    protected boolean gravity;
    protected boolean calculateFiringAngle;
    protected Boolean fromOrigin;
    protected PlaceholderString potionEffectType;
    protected PlaceholderInt potionDuration;
    protected PlaceholderInt potionAmplifier;
    protected boolean overwrite;
    protected boolean ambientParticles;
    protected boolean hasParticles;
    protected boolean hasIcon;
    protected String potionColor;
    protected PlaceholderString tridentItem;
    protected Optional<String> disguise;

    public ShootMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        String strProjectile = mlc.getString(new String[]{"type", "t"}, "arrow", new String[0]);
        this.damage = mlc.getPlaceholderDouble(new String[]{"damage", "d", "amount"}, 5.0, new String[0]);
        this.maxdistance = mlc.getPlaceholderInteger(new String[]{"maxdistance", "md"}, 64, new String[0]);
        this.projectileVelocity = mlc.getPlaceholderDouble(new String[]{"velocity", "v"}, 1.0, new String[0]);
        this.projectileVelocityVertOffset = mlc.getPlaceholderFloat(new String[]{"verticaloffset", "vo"}, 0.0f, new String[0]);
        this.projectileVelocityHorizOffset = mlc.getPlaceholderFloat(new String[]{"horizontaloffset", "ho"}, 0.0f, new String[0]);
        this.powerAffectsVelocity = mlc.getBoolean(new String[]{"poweraffectsvelocity", "pav"}, true);
        this.bounce = mlc.getBoolean(new String[]{"bounce"}, false);
        this.canPickup = mlc.getBoolean(new String[]{"pickup"}, false);
        this.knockbackStrength = mlc.getInteger(new String[]{"knockback", "kb"}, 0);
        this.pierceLevel = mlc.getInteger(new String[]{"pierceLevel", "pl"}, 0);
        this.gravity = mlc.getBoolean(new String[]{"gravity", "g"}, true);
        this.tickInterval = mlc.getInteger(new String[]{"interval", "int", "i"}, 4);
        this.expirationTime = mlc.getInteger(new String[]{"expiration", "expire", "e", "duration"}, 100);
        this.startYOffset = mlc.getFloat(new String[]{"startyoffset", "syo"}, 0.0f);
        this.adjustVelocity = mlc.getBoolean(new String[]{"adjustvelocity", "av"}, true);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
        this.calculateFiringAngle = mlc.getBoolean(new String[]{"calculatefiringangle", "cfa"}, false);
        this.disguise = Optional.ofNullable(mlc.getString(new String[]{"disguise", "d"}, null, new String[0]));
        this.projectileVelocityAccuracy = mlc.getFloat(new String[]{"accuracy", "ac", "a"}, 1.0f);
        float defNoise = (1.0f - this.projectileVelocityAccuracy) * 45.0f;
        this.projectileVelocityVertNoise = mlc.getFloat(new String[]{"verticalnoise", "vn"}, defNoise) / 10.0f;
        this.projectileVelocityHorizNoise = mlc.getFloat(new String[]{"horizontalnoise", "hn"}, defNoise);
        this.projectileVelocityVertNoiseBase = 0.0f - this.projectileVelocityVertNoise / 2.0f;
        this.projectileVelocityHorizNoiseBase = 0.0f - this.projectileVelocityHorizNoise / 2.0f;
        switch (strProjectile.toUpperCase()) {
            case "ARROW": {
                this.projectileClass = Arrow.class;
                break;
            }
            case "SNOWBALL": {
                this.projectileClass = Snowball.class;
                break;
            }
            case "EGG": {
                this.projectileClass = Egg.class;
                break;
            }
            case "ENDERPEARL": {
                this.projectileClass = EnderPearl.class;
                break;
            }
            case "POTION": 
            case "SPLASH_POTION": 
            case "LINGERING_POTION": {
                this.projectileType = strProjectile.toUpperCase().equals("LINGERING_POTION") ? ProjectileType.LINGERING_POTION : ProjectileType.POTION;
                this.projectileClass = ThrownPotion.class;
                this.potionEffectType = mlc.getPlaceholderString(new String[]{"potiontype", "ptype", "effect", "pt", "pe"}, "SLOW", new String[0]);
                this.potionDuration = mlc.getPlaceholderInteger(new String[]{"potionduration", "pduration", "pd"}, 100, new String[0]);
                this.potionAmplifier = mlc.getPlaceholderInteger(new String[]{"potionlevel", "plevel", "lvl", "pl"}, 1, new String[0]);
                this.overwrite = mlc.getBoolean(new String[]{"overwrite", "ow", "override", "or", "force"}, false);
                this.potionColor = mlc.getString(new String[]{"potioncolor", "pc"}, "#FFFFFF", new String[0]);
                this.ambientParticles = mlc.getBoolean(new String[]{"ambientparticles", "ambient"}, false);
                this.hasParticles = mlc.getBoolean(new String[]{"hasparticles", "particles"}, true);
                this.hasIcon = mlc.getBoolean(new String[]{"hasicon", "icon"}, true);
                break;
            }
            case "ITEM": {
                this.projectileType = ProjectileType.ITEM;
                break;
            }
            case "BLOCK": 
            case "FALLING_BLOCK": {
                this.projectileType = ProjectileType.BLOCK;
                break;
            }
            case "TRIDENT": {
                this.projectileClass = Trident.class;
                this.tridentItem = mlc.getPlaceholderString(new String[]{"tridentitem", "titem", "ti"}, "", new String[0]);
                this.projectileType = ProjectileType.TRIDENT;
                break;
            }
            default: {
                this.projectileClass = Arrow.class;
            }
        }
        this.onTickSkillName = mlc.getString(new String[]{"ontickskill", "ontick", "ot", "skill", "s", "meta", "m"});
        this.onHitSkillName = mlc.getString(new String[]{"onhitskill", "onhit", "oh"});
        this.onEndSkillName = mlc.getString(new String[]{"onendskill", "onend", "oe"});
        this.getManager().queueSecondPass(() -> {
            if (this.onTickSkillName != null) {
                this.onTickSkill = this.getManager().getSkill(file, this, this.onTickSkillName);
            }
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Shoot Loaded onTick pointing at " + this.onTickSkillName, new Object[0]);
            if (this.onHitSkillName != null) {
                this.onHitSkill = this.getManager().getSkill(file, this, this.onHitSkillName);
            }
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loaded onHit pointing at " + this.onHitSkillName, new Object[0]);
            if (this.onEndSkillName != null) {
                this.onEndSkill = this.getManager().getSkill(file, this, this.onEndSkillName);
            }
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loaded onEnd pointing at " + this.onEndSkillName, new Object[0]);
        });
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.shoot(data, target.getLocation());
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        return this.shoot(data, target);
    }

    public SkillResult shoot(SkillMetadata data, AbstractLocation target) {
        Entity entity;
        float noise;
        AbstractVector vector;
        SkillCaster caster = data.getCaster();
        AbstractLocation origin = data.getOrigin().clone();
        float power = data.getPower();
        if (!this.onTickSkill.isPresent() && this.onTickSkillName != null) {
            this.onTickSkill = ((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(this.file, this, this.onTickSkillName);
        }
        if (!this.onHitSkill.isPresent() && this.onHitSkillName != null) {
            this.onHitSkill = ((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(this.file, this, this.onHitSkillName);
        }
        if (!this.onEndSkill.isPresent() && this.onEndSkillName != null) {
            this.onEndSkill = ((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(this.file, this, this.onEndSkillName);
        }
        float v = (float)this.projectileVelocity.get(data) * 3.0f;
        if (this.powerAffectsVelocity) {
            v *= power;
        }
        if (this.startYOffset > 0.0f) {
            origin = origin.add(0.0, this.startYOffset, 0.0);
        }
        if (this.startForwardOffset != 0.0f) {
            origin = MythicUtil.move(origin, this.startForwardOffset, 0.0, 0.0);
        }
        if (this.startSideOffset != 0.0f) {
            origin = MythicUtil.move(origin, 0.0, 0.0, this.startSideOffset);
        }
        if (this.fromOrigin.booleanValue()) {
            vector = target.toVector().rotate(0.001f).subtract(origin.toVector()).normalize();
        } else if (caster.getEntity().isPlayer() && this.adjustVelocity.booleanValue()) {
            float yaw = caster.getEntity().getEyeLocation().getYaw();
            float pitch = caster.getEntity().getEyeLocation().getPitch();
            double xVel = -Math.sin(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch));
            double yVel = -Math.sin(Math.toRadians(pitch));
            double zVel = Math.cos(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch));
            vector = new AbstractVector(xVel, yVel, zVel).normalize();
        } else {
            vector = target.toVector().rotate(0.001f).subtract(caster.getEntity().getLocation().toVector()).normalize();
        }
        if (this.projectileVelocityHorizOffset.get(data) != 0.0f || this.projectileVelocityHorizNoise > 0.0f) {
            noise = 0.0f;
            if (this.projectileVelocityHorizNoise > 0.0f) {
                noise = (float)((double)this.projectileVelocityHorizNoiseBase + Numbers.randomDouble() * (double)this.projectileVelocityHorizNoise);
            }
            vector.rotate(this.projectileVelocityHorizOffset.get(data) + noise);
        }
        if (this.projectileVelocityVertOffset.get(data) != 0.0f || this.projectileVelocityVertNoise > 0.0f) {
            noise = 0.0f;
            if (this.projectileVelocityVertNoise > 0.0f) {
                noise = (float)((double)this.projectileVelocityVertNoiseBase + Numbers.randomDouble() * (double)this.projectileVelocityVertNoise);
            }
            vector.add(new AbstractVector(0.0f, this.projectileVelocityVertOffset.get(data) + noise, 0.0f)).normalize();
        }
        vector = vector.multiply(v);
        AbstractEntity projectile = this.projectileType == ProjectileType.ITEM || this.projectileType == ProjectileType.BLOCK || this.projectileType == ProjectileType.POTION || this.projectileType == ProjectileType.LINGERING_POTION || this.projectileType == ProjectileType.TRIDENT ? SkillAdapter.get().shootProjectile(caster, target, origin, this.projectileClass, vector, this) : (this.calculateFiringAngle && this.gravity ? SkillAdapter.get().shootArcProjectile(caster, target, origin, this.projectileClass, v, this.fromOrigin) : SkillAdapter.get().shootProjectile(caster, target, origin, this.projectileClass, vector, this));
        if (!this.gravity) {
            projectile.setGravity(false);
        }
        if (!this.canPickup.booleanValue() && (entity = projectile.getBukkitEntity()) instanceof Arrow) {
            Arrow arrow = (Arrow)entity;
            arrow.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
        }
        if (this.disguise.isPresent()) {
            ((MythicBukkit)this.getPlugin()).getCompatibility();
            if (CompatibilityManager.LibsDisguises.enabled) {
                Entity entity2 = BukkitAdapter.adapt(projectile);
                ((MythicBukkit)this.getPlugin()).getCompatibility();
                DisguiseAPI.disguiseEntity((Entity)entity2, (Disguise)CompatibilityManager.LibsDisguises.getParsedDisguise(this.disguise.get()));
            }
        }
        new ProjectileTracker(data, projectile, power);
        return SkillResult.SUCCESS;
    }

    public ProjectileType getProjectileType() {
        return this.projectileType;
    }

    public Boolean getAdjustVelocity() {
        return this.adjustVelocity;
    }

    public Boolean getBounce() {
        return this.bounce;
    }

    public Boolean getCanPickup() {
        return this.canPickup;
    }

    public int getPierceLevel() {
        return this.pierceLevel;
    }

    public int getKnockbackStrength() {
        return this.knockbackStrength;
    }

    public int getExpirationTime() {
        return this.expirationTime;
    }

    public Boolean getFromOrigin() {
        return this.fromOrigin;
    }

    public PlaceholderString getPotionEffectType() {
        return this.potionEffectType;
    }

    public PlaceholderInt getPotionDuration() {
        return this.potionDuration;
    }

    public PlaceholderInt getPotionAmplifier() {
        return this.potionAmplifier;
    }

    public String getPotionColor() {
        return this.potionColor;
    }

    public PlaceholderString getTridentItem() {
        return this.tridentItem;
    }

    public static enum ProjectileType {
        REGULAR,
        ITEM,
        BLOCK,
        POTION,
        LINGERING_POTION,
        TRIDENT;

    }

    protected class ProjectileTracker
    implements Runnable,
    Terminable {
        private final TerminableRegistry registry = TerminableRegistry.create();
        private SkillMetadata data;
        private SkillCaster caster;
        private AbstractEntity projectile;
        private boolean hasEnded = false;
        private float power;

        public ProjectileTracker(SkillMetadata caster, AbstractEntity projectile, float power) {
            this.caster = caster.getCaster();
            this.data = caster.deepClone();
            this.data.setIsAsync(true);
            this.projectile = projectile;
            this.power = power;
            this.registry.accept(Events.subscribe(EntityDamageByEntityEvent.class).filter(event -> event.getDamager() instanceof Projectile).filter(event -> event.getEntity() instanceof LivingEntity).filter(event -> event.getDamager().getUniqueId().equals(projectile.getUniqueId())).handler(this::doHitSkill));
            this.registry.accept(Schedulers.async().runRepeating(this, 0L, (long)ShootMechanic.this.tickInterval));
        }

        @Override
        public void run() {
            if (!this.projectile.isValid() || this.projectile.getBukkitEntity() instanceof Projectile && this.projectile.getBukkitEntity().isOnGround()) {
                this.doEndSkill();
                this.close();
            }
            if (ShootMechanic.this.onTickSkill.isPresent() && ShootMechanic.this.onTickSkill.get().isUsable(this.data)) {
                SkillMetadata sData = this.data.deepClone();
                HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
                targets.add(this.projectile.getLocation().clone());
                sData.setLocationTargets(targets);
                sData.setOrigin(this.projectile.getLocation().clone());
                sData.setPower(this.power);
                ShootMechanic.this.onTickSkill.get().execute(sData);
            }
            if (this.projectile.getLocation().distanceGreaterOrEq(this.data.getOrigin(), ShootMechanic.this.maxdistance.get(this.data))) {
                this.doEndSkill();
                Schedulers.sync().runLater(() -> this.projectile.remove(), 2L);
                this.close();
            }
        }

        public void doHitSkill(EntityDamageByEntityEvent event) {
            this.close();
            Projectile projectile = (Projectile)event.getDamager();
            AbstractEntity proj = BukkitAdapter.adapt((Entity)projectile);
            AbstractEntity target = BukkitAdapter.adapt(event.getEntity());
            HashSet t2 = Sets.newHashSet();
            t2.add(target);
            SkillMetadataImpl meta = new SkillMetadataImpl(SkillTriggers.ATTACK, this.caster, target, proj.getLocation(), t2, null, this.power);
            meta.getVariables().putAll((Map<String, ? extends Variable>)this.data.getVariables().asMap());
            event.setCancelled(true);
            if (ShootMechanic.this.damage.get(this.data, target) != 0.0) {
                ShootMechanic.this.doDamage(this.data, target, ShootMechanic.this.damage.get(this.data, target));
            }
            if (ShootMechanic.this.onHitSkill.isPresent() && ShootMechanic.this.onHitSkill.get().isUsable(meta)) {
                ShootMechanic.this.onHitSkill.get().execute(meta);
            }
            if (!ShootMechanic.this.bounce.booleanValue()) {
                Schedulers.sync().run(() -> ((Projectile)projectile).remove());
            }
        }

        private void doEndSkill() {
            if (!this.hasEnded && ShootMechanic.this.onEndSkill.isPresent()) {
                if (ShootMechanic.this.onEndSkill.get().isUsable(this.data)) {
                    SkillMetadata sData = this.data.deepClone();
                    ArrayList targets = Lists.newArrayList();
                    targets.add(this.projectile.getLocation().clone());
                    sData.setLocationTargets(targets);
                    sData.setOrigin(this.projectile.getLocation().clone());
                    sData.setPower(this.power);
                    ShootMechanic.this.onEndSkill.get().execute(sData);
                }
                this.hasEnded = true;
            }
        }

        @Override
        public void close() {
            this.registry.terminate();
            if (ShootMechanic.this.expirationTime > 0) {
                Schedulers.sync().runLater(() -> this.projectile.remove(), ShootMechanic.this.expirationTime);
            }
        }
    }
}

