/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillAudience;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.audience.WorldAudience;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;

@MythicMechanic(author="Ashijin", name="effect:sound", aliases={"sound", "s", "e:sound", "e:s"}, description="Plays a sound at the target location")
public class SoundEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private PlaceholderString sound;
    private SkillAudience audience;
    private PlaceholderFloat pitch;
    private float volume;
    private double radiusSq;
    private SoundCategory soundCategory = null;

    public SoundEffect(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.sound = mlc.getPlaceholderString(new String[]{"sound", "s"}, "entity.zombie.attack_iron_door", new String[0]);
        this.audience = mlc.getAudience("audience", "world");
        this.pitch = mlc.getPlaceholderFloat(new String[]{"pitch", "p"}, 1.0f, new String[0]);
        this.volume = mlc.getFloat(new String[]{"volume", "v"}, 1.0f);
        this.radiusSq = mlc.getDouble(new String[]{"radius", "r"}, (double)(this.volume * 16.0f));
        this.radiusSq = Math.pow(this.radiusSq, 2.0);
        String soundCategoryString = mlc.getString(new String[]{"soundcategory", "category", "sc"}, null, new String[0]);
        if (soundCategoryString != null) {
            for (SoundCategory sc : SoundCategory.values()) {
                if (!soundCategoryString.toUpperCase().equals(sc.toString())) continue;
                this.soundCategory = sc;
                break;
            }
            if (this.soundCategory == null) {
                MythicLogger.errorMechanicConfig(this, mlc, "Invalid SoundCategory specified");
            }
        }
        if (this.sound.isStatic()) {
            String test = this.sound.get();
            ((MythicBukkit)this.getPlugin()).getCompatibility().getCrucible().ifPresent(crucible -> {
                if (crucible.isGeneratedSound(test) && !test.startsWith("mythic:")) {
                    this.sound = PlaceholderString.of("mythic:" + test);
                }
            });
        }
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        Collection<AbstractPlayer> audience = this.audience instanceof WorldAudience ? null : this.audience.get(data, null);
        this.playSound(data, target, audience);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Collection<AbstractPlayer> audience = this.audience instanceof WorldAudience ? null : this.audience.get(data, target);
        this.playSound(data, target.getLocation(), audience);
        return SkillResult.SUCCESS;
    }

    protected void playSound(SkillMetadata data, AbstractLocation target, Collection<AbstractPlayer> audience) {
        Location l = BukkitAdapter.adapt(target);
        if (audience == null) {
            l.getWorld().playSound(l, this.sound.get(data), this.soundCategory == null ? SoundCategory.MASTER : this.soundCategory, this.volume, this.pitch.get(data));
        } else {
            for (AbstractEntity abstractEntity : audience) {
                ((Player)abstractEntity.getBukkitEntity()).playSound(l, this.sound.get(data), this.soundCategory == null ? SoundCategory.MASTER : this.soundCategory, this.volume, this.pitch.get(data));
            }
        }
    }
}

