/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.SkillAdapter;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;

@MythicMechanic(author="Ashijin", name="throw", description="Throws the target entity")
public class ThrowMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderFloat velocity;
    protected PlaceholderFloat velocityY;
    private boolean fromOrigin;

    public ThrowMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.velocity = mlc.getPlaceholderFloat(new String[]{"velocity", "v"}, 1.0f, new String[0]);
        this.velocityY = mlc.getPlaceholderFloat(new String[]{"velocityy", "yvelocity", "vy", "yv"}, 1.0f, new String[0]);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        float velocity = this.velocity.get(data, target) / 10.0f;
        float velocityY = this.velocityY.get(data, target) / 10.0f;
        AbstractLocation location = this.fromOrigin ? data.getOrigin() : data.getCaster().getLocation();
        SkillAdapter.get().throwSkill(location, target, velocity, velocityY);
        return SkillResult.SUCCESS;
    }
}

