/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableMechanic;
import io.lumine.mythic.core.skills.variables.VariableRegistry;
import io.lumine.mythic.core.skills.variables.types.FloatVariable;
import io.lumine.mythic.core.skills.variables.types.IntegerVariable;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.core.utils.math.Functions;
import io.lumine.mythic.core.utils.math.Operators;
import java.io.File;
import net.objecthunter.exp4j.ExpressionBuilder;

@MythicMechanic(author="Ashijin", name="variableMath", aliases={"varMath", "mathVariable", "mathVar"}, description="Sets a variable to the result of a math equation, where 'x' is the variable's current value")
public class VariableMathMechanic
extends VariableMechanic
implements ITargetedEntitySkill {
    protected PlaceholderString equation;

    public VariableMathMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.equation = mlc.getPlaceholderString(new String[]{"equation", "eq", "e"}, "x", new String[0]);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        VariableRegistry variables = this.getVariableManager().getRegistry(this.scope, data, target);
        Variable var = variables.get(this.key.get((PlaceholderMeta)data, target));
        if (var == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String eq = this.equation.get((PlaceholderMeta)data, target);
        if (var instanceof IntegerVariable) {
            int val = ((IntegerVariable)var).getValue();
            double amount = new ExpressionBuilder(eq).variable("x").operator(Operators.operators).functions(Functions.functions).build().setVariable("x", val).evaluate();
            ((IntegerVariable)var).setValue((int)amount);
        } else if (var instanceof FloatVariable) {
            float val = ((FloatVariable)var).getValue();
            double amount = new ExpressionBuilder(eq).variable("x").operator(Operators.operators).functions(Functions.functions).build().setVariable("x", val).evaluate();
            ((FloatVariable)var).setValue((float)amount);
        } else {
            MythicLogger.errorMechanicConfig(this, this.config, "Could not perform math operation on non-numeric variable type");
            return SkillResult.INVALID_CONFIG;
        }
        this.handleDuration(var);
        return SkillResult.SUCCESS;
    }
}

