/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableMechanic;
import io.lumine.mythic.core.skills.variables.VariableRegistry;
import io.lumine.mythic.core.skills.variables.types.FloatVariable;
import io.lumine.mythic.core.skills.variables.types.IntegerVariable;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.math.BigDecimal;

@MythicMechanic(author="Ashijin", name="variableSubtract", aliases={"variableSub", "subtractVariable", "subVar", "reduceVariable"}, description="Reduces the value of the given variable on the target entity")
public class VariableSubtractMechanic
extends VariableMechanic
implements ITargetedEntitySkill {
    protected PlaceholderFloat amount;

    public VariableSubtractMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.amount = mlc.getPlaceholderFloat(new String[]{"amount", "a"}, 0.0f, new String[0]);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        VariableRegistry variables = this.getVariableManager().getRegistry(this.scope, data, target);
        Variable var = variables.get(this.key.get((PlaceholderMeta)data, target));
        float amount = this.amount.get(data, target);
        if (var == null) {
            return SkillResult.INVALID_CONFIG;
        }
        if (var instanceof IntegerVariable) {
            IntegerVariable intVar = (IntegerVariable)var;
            int val = intVar.getValue();
            intVar.setValue(val - (int)amount);
        } else if (var instanceof FloatVariable) {
            FloatVariable floatVar = (FloatVariable)var;
            BigDecimal val = BigDecimal.valueOf(floatVar.getValue());
            floatVar.setValue(val.subtract(BigDecimal.valueOf(amount)).floatValue());
        } else {
            MythicLogger.errorMechanicConfig(this, this.config, "Could not perform math operation on non-numeric variable type");
            return SkillResult.INVALID_CONFIG;
        }
        this.handleDuration(var);
        return SkillResult.SUCCESS;
    }
}

