/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderManager;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.config.properties.Property;
import io.lumine.mythic.bukkit.utils.config.properties.types.NodeListProp;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.config.MythicLineConfigImpl;
import io.lumine.mythic.core.config.Scope;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.MetaSkill;
import io.lumine.mythic.core.skills.placeholders.Placeholder;
import io.lumine.mythic.core.skills.placeholders.PlaceholderParser;
import io.lumine.mythic.core.skills.placeholders.all.BarHolderPlaceholder;
import io.lumine.mythic.core.skills.placeholders.all.BarPlaceholder;
import io.lumine.mythic.core.skills.placeholders.all.ConditionalPlaceholder;
import io.lumine.mythic.core.skills.placeholders.all.RandomLinePlaceholder;
import io.lumine.mythic.core.skills.variables.VariableScope;
import io.lumine.mythic.core.utils.annotations.AnnotationUtil;
import io.lumine.mythic.core.utils.annotations.MythicPlaceholder;
import java.io.File;
import java.lang.reflect.Constructor;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.scoreboard.Objective;
import org.bukkit.util.RayTraceResult;

public class PlaceholderExecutor
extends ReloadableModule<MythicBukkit>
implements PlaceholderManager {
    private static final NodeListProp NODES = Property.NodeList(Scope.PACK, "");
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("(\\<(?:[^<>]+|\\<[^<>]+\\>)+\\>)");
    private static final DecimalFormat df = new DecimalFormat("0.00");
    private List<PlaceholderParser> parsers = Lists.newArrayList();
    private PlaceholderTree placeholders = new PlaceholderTree();
    private PlaceholderClassTree placeholderClasses = new PlaceholderClassTree();
    private boolean initialized = false;
    private boolean acceptingRegisteredParsers = true;

    public PlaceholderExecutor(MythicBukkit plugin) {
        super(plugin, false);
    }

    @Override
    public void unload() {
        this.parsers.clear();
    }

    @Override
    public void load(MythicBukkit plugin) {
        this.initialized = false;
        this.acceptingRegisteredParsers = true;
        this.placeholders = new PlaceholderTree();
        this.register("bar", (Placeholder)new BarHolderPlaceholder(this));
        this.register("caster.name", (Placeholder)Placeholder.meta((meta, arg) -> {
            SkillCaster caster = meta.getCaster();
            if (caster instanceof ActiveMob) {
                if (((ActiveMob)caster).getDisplayName() != null) {
                    return ((ActiveMob)caster).getDisplayName();
                }
                String name = ((ActiveMob)caster).getEntity().getBukkitEntity().getType().getName();
                name = WordUtils.capitalize((String)name);
                return name;
            }
            if (caster.getEntity().isPlayer()) {
                return caster.getEntity().asPlayer().getName();
            }
            return caster.getEntity().getName();
        }));
        this.register("caster.display", (Placeholder)Placeholder.meta((meta, arg) -> {
            SkillCaster caster = meta.getCaster();
            return caster.getEntity().getName();
        }));
        this.register("caster.uuid", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getEntity().getUniqueId())));
        this.register("caster.l.w", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getLocation().getWorld().getName())));
        this.register("caster.l.x", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getLocation().getBlockX())));
        this.register("caster.l.y", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getLocation().getBlockY())));
        this.register("caster.l.z", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getLocation().getBlockZ())));
        this.register("caster.l.x.double", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getLocation().getX())));
        this.register("caster.l.y.double", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getLocation().getY())));
        this.register("caster.l.z.double", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getLocation().getZ())));
        this.register("caster.l.yaw", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getLocation().getYaw())));
        this.register("caster.l.pitch", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getLocation().getPitch())));
        this.register("caster.velocity", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf((int)meta.getCaster().getEntity().getVelocity().length())));
        this.register("caster.hp", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf((int)meta.getCaster().getEntity().getHealth())));
        this.register("caster.thp", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getEntity().getHealth())));
        this.register("caster.mhp", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf((int)meta.getCaster().getEntity().getMaxHealth())));
        this.register("caster.php", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(100.0 * (meta.getCaster().getEntity().getHealth() / meta.getCaster().getEntity().getMaxHealth()))));
        this.register("caster.level", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf((int)meta.getCaster().getLevel())));
        this.register("caster.stance", (Placeholder)Placeholder.meta((meta, arg) -> meta.getCaster() instanceof ActiveMob ? String.valueOf(((ActiveMob)meta.getCaster()).getStance()) : "None"));
        this.register("caster.luck", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getEntity().getLuck())));
        this.register("caster.enchantlevel", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getEntity().getEnchantmentLevel((String)arg))));
        this.register("caster.heldenchantlevel", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getEntity().getEnchantmentLevelHeld((String)arg))));
        this.register("caster.damage", (Placeholder)Placeholder.meta((meta, arg) -> {
            SkillCaster caster = meta.getCaster();
            if (caster instanceof ActiveMob) {
                return String.valueOf(((ActiveMob)caster).getDamage());
            }
            if (caster.getEntity().isPlayer()) {
                return String.valueOf(BukkitAdapter.adapt(caster.getEntity().asPlayer()).getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).getValue());
            }
            return "0";
        }));
        this.register("caster.score", (Placeholder)Placeholder.meta((meta, arg) -> {
            AbstractEntity target = meta.getCaster().getEntity();
            Objective obj = Bukkit.getScoreboardManager().getMainScoreboard().getObjective(arg);
            int score = 0;
            if (obj != null) {
                score = target.isPlayer() ? obj.getScore(target.asPlayer().getName()).getScore() : obj.getScore(target.getUniqueId().toString()).getScore();
            }
            return String.valueOf(score);
        }));
        this.register("caster.tt.top", (Placeholder)Placeholder.meta((meta, arg) -> {
            ActiveMob am;
            if (meta.getCaster() instanceof ActiveMob && (am = (ActiveMob)meta.getCaster()).hasThreatTable() && am.getThreatTable().inCombat()) {
                return am.getThreatTable().getTopThreatHolder().getName();
            }
            return "Unknown";
        }));
        this.register("caster.tt.size", (Placeholder)Placeholder.meta((meta, arg) -> {
            ActiveMob am;
            if (meta.getCaster() instanceof ActiveMob && (am = (ActiveMob)meta.getCaster()).hasThreatTable()) {
                return String.valueOf(am.getThreatTable().size());
            }
            return String.valueOf(0);
        }));
        this.register("caster.mythic_type", (Placeholder)Placeholder.meta((meta, arg) -> {
            SkillCaster patt8897$temp = meta.getCaster();
            if (patt8897$temp instanceof ActiveMob) {
                ActiveMob activeMob = (ActiveMob)patt8897$temp;
                return activeMob.getMobType();
            }
            return "Unknown";
        }));
        this.register("caster.children.size", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getChildren().size())));
        this.register("caster.skill", (Placeholder)Placeholder.meta((meta, arg) -> {
            String[] split = arg.split("\\.");
            Optional<Skill> maybeSkill = ((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(split[0]);
            if (!maybeSkill.isPresent()) {
                return "Skill Not Found";
            }
            MetaSkill skill = (MetaSkill)maybeSkill.get();
            if ("cooldown".equalsIgnoreCase(split[1])) {
                if (split.length > 2 && "millis".equals(split[2])) {
                    return String.valueOf(skill.getCooldown(meta.getCaster()));
                }
                return String.valueOf(Numbers.round(skill.getCooldown(meta.getCaster()), 2));
            }
            return "Invalid Placeholder";
        }));
        this.register("caster.raycast", (Placeholder)Placeholder.meta((meta, arg) -> this.rayCast(BukkitAdapter.adapt(meta.getCaster().getEntity()))));
        this.register("caster.raytrace", (Placeholder)Placeholder.meta((meta, arg) -> this.rayCast(BukkitAdapter.adapt(meta.getCaster().getEntity()))));
        this.register("skill.var", (Placeholder)Placeholder.meta((meta, arg) -> {
            if (meta instanceof SkillMetadata) {
                SkillMetadata data = (SkillMetadata)meta;
                return data.getVariables().getString((String)arg);
            }
            return null;
        }));
        this.register("skill.targets", (Placeholder)Placeholder.meta((meta, arg) -> {
            if (meta instanceof SkillMetadata) {
                SkillMetadata data = (SkillMetadata)meta;
                if (!data.getEntityTargets().isEmpty()) {
                    return String.valueOf(data.getEntityTargets().size());
                }
                if (!data.getLocationTargets().isEmpty()) {
                    return String.valueOf(data.getLocationTargets().size());
                }
                return "0";
            }
            return "0";
        }));
        this.register("skill", (Placeholder)Placeholder.meta((meta, arg) -> {
            if (arg == null) {
                return null;
            }
            if (meta instanceof SkillMetadata) {
                String parameter;
                SkillMetadata data = (SkillMetadata)meta;
                String def = null;
                if (arg.contains("|")) {
                    String[] split = arg.split("\\|");
                    arg = split[0];
                    try {
                        def = split[1];
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if ((parameter = data.getParameters().get(arg.toLowerCase())) == null) {
                    return def;
                }
                return parameter;
            }
            return null;
        }));
        this.register("trigger.name", (Placeholder)Placeholder.meta((meta, arg) -> {
            AbstractEntity trigger = meta.getTrigger();
            if (trigger == null) {
                return "Unknown";
            }
            if (trigger.isPlayer()) {
                return trigger.asPlayer().getName();
            }
            return trigger.getName();
        }));
        this.register("trigger.uuid", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getTrigger().getUniqueId())));
        this.register("trigger.l.w", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getTrigger().getLocation().getWorld().getName())));
        this.register("trigger.l.x", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getTrigger().getLocation().getBlockX())));
        this.register("trigger.l.y", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getTrigger().getLocation().getBlockY())));
        this.register("origin.l.y", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(((SkillMetadata)meta).getOrigin().getY())));
        this.register("trigger.l.z", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getTrigger().getLocation().getBlockZ())));
        this.register("trigger.l.x.double", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getTrigger().getLocation().getX())));
        this.register("trigger.l.y.double", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getTrigger().getLocation().getY())));
        this.register("trigger.l.z.double", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getTrigger().getLocation().getZ())));
        this.register("trigger.l.yaw", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getTrigger().getLocation().getYaw())));
        this.register("trigger.l.pitch", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getTrigger().getLocation().getPitch())));
        this.register("trigger.hp", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf((int)meta.getTrigger().getHealth())));
        this.register("trigger.thp", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getTrigger().getHealth())));
        this.register("trigger.mhp", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf((int)meta.getTrigger().getMaxHealth())));
        this.register("trigger.php", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(100.0 * (meta.getTrigger().getHealth() / meta.getTrigger().getMaxHealth()))));
        this.register("trigger.var", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(((MythicBukkit)this.getPlugin()).getVariableManager().getRegistry(VariableScope.TARGET, meta.getTrigger()).getString((String)arg))));
        this.register("trigger.luck", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getTrigger().getLuck())));
        this.register("trigger.score", (Placeholder)Placeholder.meta((meta, arg) -> {
            AbstractEntity target = meta.getTrigger();
            Objective obj = Bukkit.getScoreboardManager().getMainScoreboard().getObjective(arg);
            int score = 0;
            if (obj != null) {
                score = target.isPlayer() ? obj.getScore(target.asPlayer().getName()).getScore() : obj.getScore(target.getUniqueId().toString()).getScore();
            }
            return String.valueOf(score);
        }));
        this.register("trigger.threat", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(((ActiveMob)meta.getCaster()).getThreatTable().getThreat(meta.getTrigger()))));
        this.register("trigger.damage", (Placeholder)Placeholder.meta((meta, arg) -> {
            if (meta.getTrigger() instanceof ActiveMob) {
                return String.valueOf(((ActiveMob)((Object)meta.getTrigger())).getDamage());
            }
            if (meta.getTrigger().isPlayer()) {
                return String.valueOf(BukkitAdapter.adapt(meta.getTrigger().asPlayer()).getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).getValue());
            }
            return "0";
        }));
        this.register("trigger.held.item", (Placeholder)Placeholder.meta((meta, arg) -> {
            AbstractEntity trigger = meta.getTrigger();
            if (trigger == null || !trigger.isLiving()) {
                return "AIR";
            }
            LivingEntity entity = (LivingEntity)trigger.getBukkitEntity();
            if (entity.getEquipment().getItemInMainHand() == null) {
                return "AIR";
            }
            return entity.getEquipment().getItemInMainHand().getType().toString();
        }));
        this.register("trigger.mythic_type", (Placeholder)Placeholder.meta((meta, arg) -> {
            if (plugin.getMobManager().isActiveMob(meta.getTrigger())) {
                ActiveMob am = plugin.getMobManager().getMythicMobInstance(meta.getTrigger());
                return am.getMobType();
            }
            return "Unknown";
        }));
        this.register("trigger.raycast", (Placeholder)Placeholder.meta((meta, arg) -> this.rayCast(meta.getTrigger().getBukkitEntity())));
        this.register("trigger.raytrace", (Placeholder)Placeholder.meta((meta, arg) -> this.rayCast(meta.getTrigger().getBukkitEntity())));
        this.register("target.name", (Placeholder)Placeholder.entity((entity, arg) -> {
            if (entity == null) {
                return "Unknown";
            }
            if (entity.isPlayer()) {
                return entity.asPlayer().getName();
            }
            if (entity.getName() != null) {
                return entity.getName();
            }
            return entity.getBukkitEntity().getType().getName();
        }));
        this.register("target.uuid", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getUniqueId())));
        this.register("target.entity_type", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getBukkitEntity().getType().toString())));
        this.register("target.l.w", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getLocation().getWorld().getName())));
        this.register("target.l.x", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getLocation().getBlockX())));
        this.register("target.l.y", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getLocation().getBlockY())));
        this.register("target.l.z", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getLocation().getBlockZ())));
        this.register("target.l.x.double", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getLocation().getX())));
        this.register("target.l.y.double", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getLocation().getY())));
        this.register("target.l.z.double", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getLocation().getZ())));
        this.register("target.l.yaw", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getLocation().getYaw())));
        this.register("target.l.pitch", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getLocation().getPitch())));
        this.register("target.hp", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf((int)entity.getHealth())));
        this.register("target.thp", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getHealth())));
        this.register("target.mhp", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf((int)entity.getMaxHealth())));
        this.register("target.php", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(100.0 * (entity.getHealth() / entity.getMaxHealth()))));
        this.register("target.level", (Placeholder)Placeholder.entity((entity, arg) -> {
            if (entity instanceof ActiveMob) {
                return String.valueOf((int)((ActiveMob)((Object)entity)).getLevel());
            }
            return "0";
        }));
        this.register("target.damage", (Placeholder)Placeholder.entity((entity, arg) -> {
            if (entity instanceof ActiveMob) {
                return String.valueOf(((ActiveMob)((Object)entity)).getDamage());
            }
            if (entity.isPlayer()) {
                return String.valueOf(BukkitAdapter.adapt(entity.asPlayer()).getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).getValue());
            }
            return "0";
        }));
        this.register("target.var", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(((MythicBukkit)this.getPlugin()).getVariableManager().getRegistry(VariableScope.TARGET, (AbstractEntity)entity).getString((String)arg))));
        this.register("target.luck", (Placeholder)Placeholder.entity((entity, arg) -> String.valueOf(entity.getLuck())));
        this.register("target.score", (Placeholder)Placeholder.entity((entity, arg) -> {
            AbstractEntity target = entity;
            Objective obj = Bukkit.getScoreboardManager().getMainScoreboard().getObjective(arg);
            int score = 0;
            if (obj != null) {
                score = target.isPlayer() ? obj.getScore(target.asPlayer().getName()).getScore() : obj.getScore(target.getUniqueId().toString()).getScore();
            }
            return String.valueOf(score);
        }));
        this.register("target.ydiff", (Placeholder)Placeholder.target((meta, entity, arg) -> {
            double tY = entity.getLocation().getY();
            double cY = meta.getCaster().getEntity().getLocation().getY();
            return String.valueOf(tY - cY);
        }));
        this.register("target.block.type", (Placeholder)Placeholder.location((location, arg) -> {
            try {
                return BukkitAdapter.adapt(location).getBlock().getType().toString();
            }
            catch (Exception ex) {
                return "AIR";
            }
        }));
        this.register("target.block.data", (Placeholder)Placeholder.location((location, args) -> {
            Block block = BukkitAdapter.adapt(location).getBlock();
            return block.getBlockData().getAsString();
        }));
        this.register("target.block.hardness", (Placeholder)Placeholder.location((location, arg) -> {
            try {
                return String.valueOf(BukkitAdapter.adapt(location).getBlock().getType().getHardness());
            }
            catch (Exception ex) {
                return "0";
            }
        }));
        this.register("target.held.item", (Placeholder)Placeholder.target((meta, target, arg) -> {
            if (target == null || !target.isLiving()) {
                return "AIR";
            }
            LivingEntity entity = (LivingEntity)target.getBukkitEntity();
            if (entity.getEquipment().getItemInMainHand() == null) {
                return "AIR";
            }
            return entity.getEquipment().getItemInMainHand().getType().toString();
        }));
        this.register("target.mythic_type", (Placeholder)Placeholder.entity((entity, arg) -> {
            if (plugin.getMobManager().isActiveMob((AbstractEntity)entity)) {
                ActiveMob am = plugin.getMobManager().getMythicMobInstance((AbstractEntity)entity);
                return am.getMobType();
            }
            return "Unknown";
        }));
        this.register("target.itemstack_amount", (Placeholder)Placeholder.entity((entity, arg) -> {
            Entity patt23019$temp = entity.getBukkitEntity();
            if (!(patt23019$temp instanceof Item)) {
                return "0";
            }
            Item item = (Item)patt23019$temp;
            return String.valueOf(item.getItemStack().getAmount());
        }));
        this.register("target.item.type", (Placeholder)Placeholder.entity((entity, arg) -> {
            Entity patt23241$temp = entity.getBukkitEntity();
            if (!(patt23241$temp instanceof Item)) {
                return "air";
            }
            Item item = (Item)patt23241$temp;
            return item.getItemStack().getType().toString();
        }));
        this.register("target.item.model", (Placeholder)Placeholder.entity((entity, arg) -> {
            Entity patt23459$temp = entity.getBukkitEntity();
            if (!(patt23459$temp instanceof Item)) {
                return "0";
            }
            Item item = (Item)patt23459$temp;
            return String.valueOf(item.getItemStack().getItemMeta().getCustomModelData());
        }));
        this.register("target.raycast", (Placeholder)Placeholder.entity((entity, arg) -> this.rayCast(entity.getBukkitEntity())));
        this.register("target.raytrace", (Placeholder)Placeholder.entity((entity, arg) -> this.rayCast(entity.getBukkitEntity())));
        this.register("parent.name", (Placeholder)Placeholder.parent((entity, arg) -> {
            if (entity == null) {
                return "Unknown";
            }
            if (entity.isPlayer()) {
                return entity.asPlayer().getName();
            }
            return entity.getName();
        }));
        this.register("parent.uuid", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf(entity.getUniqueId())));
        this.register("parent.l.w", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf(entity.getLocation().getWorld().getName())));
        this.register("parent.l.x", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf(entity.getLocation().getBlockX())));
        this.register("parent.l.y", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf(entity.getLocation().getBlockY())));
        this.register("parent.l.z", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf(entity.getLocation().getBlockZ())));
        this.register("parent.l.z.double", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf(entity.getLocation().getX())));
        this.register("parent.l.z.double", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf(entity.getLocation().getY())));
        this.register("parent.l.z.double", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf(entity.getLocation().getZ())));
        this.register("parent.l.yaw", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf(entity.getLocation().getYaw())));
        this.register("parent.l.pitch", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf(entity.getLocation().getPitch())));
        this.register("parent.hp", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf((int)entity.getHealth())));
        this.register("parent.thp", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf(entity.getHealth())));
        this.register("parent.mhp", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf((int)entity.getMaxHealth())));
        this.register("parent.php", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf(100.0 * (entity.getHealth() / entity.getMaxHealth()))));
        this.register("parent.damage", (Placeholder)Placeholder.parent((entity, arg) -> {
            if (entity instanceof ActiveMob) {
                return String.valueOf(((ActiveMob)((Object)entity)).getDamage());
            }
            if (entity.isPlayer()) {
                return String.valueOf(BukkitAdapter.adapt(entity.asPlayer()).getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).getValue());
            }
            return "0";
        }));
        this.register("parent.var", (Placeholder)Placeholder.parent((entity, arg) -> String.valueOf(((MythicBukkit)this.getPlugin()).getVariableManager().getRegistry(VariableScope.TARGET, (AbstractEntity)entity).getString((String)arg))));
        this.register("parent.raycast", (Placeholder)Placeholder.parent((parent, arg) -> this.rayCast(parent.getBukkitEntity())));
        this.register("parent.raytrace", (Placeholder)Placeholder.parent((parent, arg) -> this.rayCast(parent.getBukkitEntity())));
        this.register("spawner.pir", (Placeholder)Placeholder.spawner((spawner, arg) -> {
            double radius = spawner.getScalingRange();
            int players = ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getWorldHandler().getEntitiesNearLocation(spawner.getLocation(), radius, entity -> entity.isPlayer()).size();
            return String.valueOf(players);
        }));
        this.register("score", (Placeholder)Placeholder.general(arg -> {
            String[] split = arg.split("\\.");
            if (split.length < 2) {
                return null;
            }
            String objective = split[0];
            String entry = split[1];
            Objective obj = Bukkit.getScoreboardManager().getMainScoreboard().getObjective(objective);
            int score = 0;
            if (obj != null) {
                score = obj.getScore(entry).getScore();
            }
            return String.valueOf(score);
        }));
        this.register("world.var", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(((MythicBukkit)this.getPlugin()).getVariableManager().getRegistry(VariableScope.WORLD, (SkillMetadata)meta, meta.getTrigger()).getString((String)arg))));
        this.register("global.var", (Placeholder)Placeholder.general(arg -> String.valueOf(((MythicBukkit)this.getPlugin()).getVariableManager().getRegistry(VariableScope.GLOBAL, null, null).getString((String)arg))));
        this.register("global.score", (Placeholder)Placeholder.general(arg -> {
            Objective obj = Bukkit.getScoreboardManager().getMainScoreboard().getObjective(arg);
            int score = 0;
            if (obj != null) {
                score = obj.getScore("__GLOBAL__").getScore();
            }
            return String.valueOf(score);
        }));
        Collection<Class<?>> placeholderClasses = AnnotationUtil.getAnnotatedClasses(this.getPlugin(), "io.lumine.mythic.core.skills.placeholders.all", MythicPlaceholder.class);
        for (Class<Placeholder> clazz : placeholderClasses) {
            try {
                String name = clazz.getAnnotation(MythicPlaceholder.class).placeholder();
                if (!Placeholder.class.isAssignableFrom(clazz)) continue;
                this.register(name, clazz);
            }
            catch (Exception ex) {
                MythicLogger.error("Failed to load placeholder {0}", clazz.getCanonicalName());
            }
        }
        for (Pack pack : ((MythicBukkit)this.getPlugin()).getPackManager().getPacks()) {
            File file = pack.getPackFile("placeholders.yml");
            if (!file.exists()) continue;
            MythicConfigImpl baseConfig = new MythicConfigImpl(file);
            for (String node : baseConfig.getKeys("")) {
                if (baseConfig.isConfigurationSection(node)) {
                    this.register("placeholder." + node, (Placeholder)new ConditionalPlaceholder(this, node, baseConfig.getNestedConfig(node)));
                    continue;
                }
                if (baseConfig.isList(node)) {
                    this.register("placeholder." + node, (Placeholder)new RandomLinePlaceholder(this, baseConfig.getStringList(node)));
                    continue;
                }
                String value = baseConfig.getString(node);
                this.register("placeholder." + node, (Placeholder)Placeholder.general(arg -> value));
            }
        }
        this.initialized = true;
    }

    @Override
    public void register(String[] keys, Placeholder transformer) {
        for (String key : keys) {
            this.register(key, transformer);
        }
    }

    @Override
    public void register(String key, Placeholder transformer) {
        String[] split = key.split("\\.");
        PlaceholderTree ref = this.placeholders;
        for (int i = 0; i <= split.length; ++i) {
            if (i == split.length) {
                ref.setPlaceholder(transformer);
                continue;
            }
            if (!ref.getSubPlaceholders().containsKey(split[i])) {
                ref.getSubPlaceholders().put(split[i], new PlaceholderTree());
            }
            ref = ref.getSubPlaceholders().get(split[i]);
        }
        if (this.initialized) {
            this.recheckForPlaceholders();
        }
    }

    public void register(String[] keys, Class<Placeholder> transformer) {
        for (String key : keys) {
            this.register(key, transformer);
        }
    }

    public void register(String key, Class<Placeholder> transformer) {
        String[] split = key.split("\\.");
        PlaceholderClassTree ref = this.placeholderClasses;
        for (int i = 0; i <= split.length; ++i) {
            if (i == split.length) {
                ref.setPlaceholder(transformer);
                continue;
            }
            if (!ref.getSubPlaceholders().containsKey(split[i])) {
                ref.getSubPlaceholders().put(split[i], new PlaceholderClassTree());
            }
            ref = ref.getSubPlaceholders().get(split[i]);
        }
        if (this.initialized) {
            this.recheckForPlaceholders();
        }
    }

    @Override
    public PlaceholderEntry getPlaceholder(String key) {
        if (key.startsWith("&")) {
            return null;
        }
        String[] split = key.split("\\.");
        PlaceholderClassTree ref = this.placeholderClasses;
        String arg = null;
        MythicLineConfigImpl config = null;
        for (int i = 0; i < split.length; ++i) {
            String currentKey = split[i];
            if (currentKey.contains("{") || currentKey.contains("}")) {
                config = MythicLineConfigImpl.of(currentKey);
                currentKey = config.getKey();
            }
            if (ref.getSubPlaceholders().containsKey(currentKey)) {
                ref = ref.getSubPlaceholders().get(currentKey);
                continue;
            }
            arg = arg == null ? split[i] : arg + "." + split[i];
        }
        Placeholder placeholder = null;
        Class<Placeholder> placeholderClass = ref.getPlaceholder();
        try {
            Constructor<Placeholder> placeholderConstructor = placeholderClass.getConstructor(PlaceholderExecutor.class, MythicLineConfig.class, String.class);
            placeholder = placeholderConstructor.newInstance(this, config, arg);
        }
        catch (Throwable ex) {
            try {
                Constructor<Placeholder> placeholderConstructor = placeholderClass.getConstructor(PlaceholderExecutor.class, String.class);
                placeholder = placeholderConstructor.newInstance(this, arg);
            }
            catch (Throwable ex2) {
                try {
                    Constructor<Placeholder> placeholderConstructor = placeholderClass.getConstructor(PlaceholderExecutor.class);
                    placeholder = placeholderConstructor.newInstance(this);
                }
                catch (Throwable ex3) {
                    try {
                        Constructor<Placeholder> placeholderConstructor = placeholderClass.getConstructor(String.class);
                        placeholder = placeholderConstructor.newInstance(arg);
                    }
                    catch (Throwable ex4) {
                        try {
                            Constructor<Placeholder> placeholderConstructor = placeholderClass.getConstructor(new Class[0]);
                            placeholder = placeholderConstructor.newInstance(new Object[0]);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (placeholder != null) {
            return new PlaceholderEntry(placeholder, arg);
        }
        PlaceholderTree ref2 = this.placeholders;
        arg = null;
        for (int i = 0; i < split.length; ++i) {
            if (ref2.getSubPlaceholders().containsKey(split[i])) {
                ref2 = ref2.getSubPlaceholders().get(split[i]);
                continue;
            }
            arg = arg == null ? split[i] : arg + "." + split[i];
        }
        if (ref2.getPlaceholder() instanceof BarHolderPlaceholder) {
            BarPlaceholder pl = new BarPlaceholder(this, arg);
            return new PlaceholderEntry(pl, arg);
        }
        return new PlaceholderEntry(ref2.getPlaceholder(), arg);
    }

    @Override
    public boolean checkForVariables(String string) {
        return VARIABLE_PATTERN.matcher(string).find();
    }

    public Matcher matcher(String string) {
        return VARIABLE_PATTERN.matcher(string);
    }

    @Override
    public void registerParser(PlaceholderParser placeholderParser) {
        if (this.acceptingRegisteredParsers) {
            this.parsers.add(placeholderParser);
        }
    }

    @Override
    public void recheckForPlaceholders() {
        ArrayList parsers = Lists.newArrayList(this.parsers);
        parsers.forEach(parser -> parser.checkForVariables());
    }

    String rayCast(Entity entity) {
        Block targetBlock;
        if (!(entity instanceof LivingEntity)) {
            return "AIR";
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        RayTraceResult rayTraceResult = entity.getWorld().rayTraceBlocks(livingEntity.getEyeLocation(), entity.getLocation().getDirection(), 4.5);
        if (rayTraceResult != null && (targetBlock = rayTraceResult.getHitBlock()) != null) {
            Material blockType = targetBlock.getType();
            return blockType.toString();
        }
        return "AIR";
    }

    public List<PlaceholderParser> getParsers() {
        return this.parsers;
    }

    public boolean isAcceptingRegisteredParsers() {
        return this.acceptingRegisteredParsers;
    }

    public void setAcceptingRegisteredParsers(boolean acceptingRegisteredParsers) {
        this.acceptingRegisteredParsers = acceptingRegisteredParsers;
    }

    private class PlaceholderTree {
        private Placeholder placeholder = null;
        private Map<String, PlaceholderTree> subPlaceholders = new HashMap<String, PlaceholderTree>();

        public Placeholder getPlaceholder() {
            return this.placeholder;
        }

        public Map<String, PlaceholderTree> getSubPlaceholders() {
            return this.subPlaceholders;
        }

        public void setPlaceholder(Placeholder placeholder) {
            this.placeholder = placeholder;
        }

        public void setSubPlaceholders(Map<String, PlaceholderTree> subPlaceholders) {
            this.subPlaceholders = subPlaceholders;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlaceholderTree)) {
                return false;
            }
            PlaceholderTree other = (PlaceholderTree)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Placeholder this$placeholder = this.getPlaceholder();
            Placeholder other$placeholder = other.getPlaceholder();
            if (this$placeholder == null ? other$placeholder != null : !this$placeholder.equals(other$placeholder)) {
                return false;
            }
            Map<String, PlaceholderTree> this$subPlaceholders = this.getSubPlaceholders();
            Map<String, PlaceholderTree> other$subPlaceholders = other.getSubPlaceholders();
            return !(this$subPlaceholders == null ? other$subPlaceholders != null : !((Object)this$subPlaceholders).equals(other$subPlaceholders));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PlaceholderTree;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Placeholder $placeholder = this.getPlaceholder();
            result = result * 59 + ($placeholder == null ? 43 : $placeholder.hashCode());
            Map<String, PlaceholderTree> $subPlaceholders = this.getSubPlaceholders();
            result = result * 59 + ($subPlaceholders == null ? 43 : ((Object)$subPlaceholders).hashCode());
            return result;
        }

        public String toString() {
            return "PlaceholderExecutor.PlaceholderTree(placeholder=" + this.getPlaceholder() + ", subPlaceholders=" + this.getSubPlaceholders() + ")";
        }
    }

    private class PlaceholderClassTree {
        private Class<Placeholder> placeholder = null;
        private Map<String, PlaceholderClassTree> subPlaceholders = new HashMap<String, PlaceholderClassTree>();

        public Class<Placeholder> getPlaceholder() {
            return this.placeholder;
        }

        public Map<String, PlaceholderClassTree> getSubPlaceholders() {
            return this.subPlaceholders;
        }

        public void setPlaceholder(Class<Placeholder> placeholder) {
            this.placeholder = placeholder;
        }

        public void setSubPlaceholders(Map<String, PlaceholderClassTree> subPlaceholders) {
            this.subPlaceholders = subPlaceholders;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlaceholderClassTree)) {
                return false;
            }
            PlaceholderClassTree other = (PlaceholderClassTree)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<Placeholder> this$placeholder = this.getPlaceholder();
            Class<Placeholder> other$placeholder = other.getPlaceholder();
            if (this$placeholder == null ? other$placeholder != null : !this$placeholder.equals(other$placeholder)) {
                return false;
            }
            Map<String, PlaceholderClassTree> this$subPlaceholders = this.getSubPlaceholders();
            Map<String, PlaceholderClassTree> other$subPlaceholders = other.getSubPlaceholders();
            return !(this$subPlaceholders == null ? other$subPlaceholders != null : !((Object)this$subPlaceholders).equals(other$subPlaceholders));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PlaceholderClassTree;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<Placeholder> $placeholder = this.getPlaceholder();
            result = result * 59 + ($placeholder == null ? 43 : $placeholder.hashCode());
            Map<String, PlaceholderClassTree> $subPlaceholders = this.getSubPlaceholders();
            result = result * 59 + ($subPlaceholders == null ? 43 : ((Object)$subPlaceholders).hashCode());
            return result;
        }

        public String toString() {
            return "PlaceholderExecutor.PlaceholderClassTree(placeholder=" + this.getPlaceholder() + ", subPlaceholders=" + this.getSubPlaceholders() + ")";
        }
    }

    public class PlaceholderEntry {
        private final Placeholder placeholder;
        private final String arg;

        public PlaceholderEntry(Placeholder p, String a) {
            this.placeholder = p;
            this.arg = a != null ? a : "null";
        }

        public Placeholder getPlaceholder() {
            return this.placeholder;
        }

        public String getArg() {
            return this.arg;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlaceholderEntry)) {
                return false;
            }
            PlaceholderEntry other = (PlaceholderEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Placeholder this$placeholder = this.getPlaceholder();
            Placeholder other$placeholder = other.getPlaceholder();
            if (this$placeholder == null ? other$placeholder != null : !this$placeholder.equals(other$placeholder)) {
                return false;
            }
            String this$arg = this.getArg();
            String other$arg = other.getArg();
            return !(this$arg == null ? other$arg != null : !this$arg.equals(other$arg));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PlaceholderEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Placeholder $placeholder = this.getPlaceholder();
            result = result * 59 + ($placeholder == null ? 43 : $placeholder.hashCode());
            String $arg = this.getArg();
            result = result * 59 + ($arg == null ? 43 : $arg.hashCode());
            return result;
        }

        public String toString() {
            return "PlaceholderExecutor.PlaceholderEntry(placeholder=" + this.getPlaceholder() + ", arg=" + this.getArg() + ")";
        }
    }
}

