/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders.parsers;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.placeholders.GenericPlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.PlaceholderParser;
import io.lumine.mythic.core.skills.placeholders.parsers.RandomInt;
import io.lumine.mythic.core.skills.placeholders.parsers.StaticInt;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;
import io.lumine.mythic.core.utils.math.Functions;
import io.lumine.mythic.core.utils.math.Operators;
import net.objecthunter.exp4j.ExpressionBuilder;

public class PlaceholderIntImpl
extends PlaceholderParser
implements PlaceholderInt {
    public PlaceholderIntImpl() {
    }

    public PlaceholderIntImpl(String string) {
        super(string);
        if (string != null && (string.startsWith("=") || string.contains("(") && string.contains(")"))) {
            this.doMath = true;
        }
    }

    @Override
    public int get() {
        String string = this.strValue;
        if (this.papi) {
            string = MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        return this.handleParsing(string);
    }

    @Override
    public int get(PlaceholderMeta meta) {
        return this.get(meta, meta.getTrigger());
    }

    @Override
    public int get(AbstractEntity entity) {
        return this.get(null, entity);
    }

    @Override
    public int get(PlaceholderMeta meta, AbstractEntity entity) {
        String string = this.parse(meta, entity);
        if (this.papi) {
            string = entity != null && entity.isPlayer() ? MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string, entity.asPlayer()) : MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        return this.handleParsing(string);
    }

    @Override
    public int get(SkillCaster caster) {
        return this.get(new GenericPlaceholderMeta(caster, caster.getEntity()));
    }

    public int get(PlaceholderMeta meta, AbstractItemStack itemStack) {
        String string = this.parse(meta, itemStack);
        if (string == null) {
            MythicLogger.error("Item placeholder value is null for {0}", itemStack.toString());
            return 1;
        }
        if (this.papi) {
            string = MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        return this.handleParsing(string);
    }

    @Override
    public int get(MythicSpawner spawner) {
        String string = this.parse(spawner);
        if (string == null) {
            MythicLogger.error("Spawner placeholder value is null for {0}", spawner.getInternalName());
            return 1;
        }
        if (this.papi) {
            string = MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        return this.handleParsing(string);
    }

    private int handleParsing(String string) {
        if (this.doMath) {
            try {
                return (int)new ExpressionBuilder(string).operator(Operators.operators).functions(Functions.functions).build().evaluate();
            }
            catch (Exception ex) {
                MythicLogger.error("Invalid math operation on PlaceholderInt: " + this.strValue);
                ex.printStackTrace();
            }
        }
        try {
            if (string.contains(".")) {
                return Numbers.floor(Double.valueOf(string));
            }
            return Integer.valueOf(string);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public String toString() {
        return this.strValue;
    }

    public static PlaceholderIntImpl of(String string) {
        try {
            if (string == null) {
                return null;
            }
            if (io.lumine.mythic.bukkit.utils.numbers.RandomInt.matches(string)) {
                return new RandomInt(string);
            }
            if (string.matches("-?\\d+")) {
                return new StaticInt(string);
            }
            if (!MythicBukkit.isVolatile()) {
                MythicLogger.error("Failed to parse Placeholder '" + string + "': Math and variables in numeric values require premium! Consider getting MythicMobs Premium at www.mythiccraft.io");
                return new StaticInt("1");
            }
            return new PlaceholderIntImpl(string);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MythicLogger.error("Failed to parse Placeholder '" + string + "': invalid syntax.");
            return new StaticInt("1");
        }
    }

    @Override
    public boolean isStaticallyEqualTo(int value) {
        return this.isStatic() && this.get() == value;
    }
}

