/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.stats;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.api.skills.stats.StatExecution;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.events.MythicStatChangeEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.skills.stats.StatExecutor;
import io.lumine.mythic.core.skills.stats.StatModifierType;
import io.lumine.mythic.core.skills.stats.StatSource;
import io.lumine.mythic.core.skills.stats.StatType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class StatRegistry {
    private static final TreeSet<StatMap> EMPTY_SET = Sets.newTreeSet();
    private final StatExecutor manager;
    private final SkillCaster holder;
    private final Map<StatType, StatMap> stats = Maps.newConcurrentMap();
    private final Map<SkillTrigger, List<StatMap>> statsByApplication = Maps.newConcurrentMap();
    private final Map<SkillTrigger, TreeSet<StatMap>> preProcessedStats = Maps.newConcurrentMap();
    private final Map<SkillTrigger, TreeSet<StatMap>> postProcessedStats = Maps.newConcurrentMap();

    public StatRegistry(StatExecutor manager, SkillCaster holder) {
        this.manager = manager;
        this.holder = holder;
        for (StatType stat : manager.getNonZeroBaseStats()) {
            this.compute(stat);
        }
    }

    private StatMap compute(StatType type) {
        StatMap stat;
        block2: {
            block3: {
                stat = this.stats.get(type);
                if (stat != null) break block2;
                stat = new StatMap(this, type);
                this.stats.put(type, stat);
                if (type.getExecutionPoint() != StatExecution.PRE) break block3;
                for (SkillTrigger app : type.getApplicableTriggers()) {
                    this.preProcessedStats.computeIfAbsent(app, c -> Sets.newTreeSet()).add(stat);
                }
                break block2;
            }
            if (type.getExecutionPoint() != StatExecution.POST) break block2;
            for (SkillTrigger app : type.getApplicableTriggers()) {
                this.postProcessedStats.computeIfAbsent(app, c -> Sets.newTreeSet()).add(stat);
            }
        }
        return stat;
    }

    public double get(StatType type) {
        return this.compute(type).get();
    }

    public void putBaseValue(StatType type, double value) {
        this.compute(type).setBaseValue(value);
    }

    public void putBaseValueSilently(StatType type, double value) {
        this.compute(type).setBaseValueSilently(value);
    }

    public void putValue(StatType type, StatSource source, StatModifierType operation, double value) {
        this.compute(type).put(source, operation, value, true);
    }

    public void putValueSilently(StatType type, StatSource source, StatModifierType operation, double value) {
        this.compute(type).put(source, operation, value, false);
    }

    public void removeValue(StatType type, StatSource source) {
        StatMap stat = this.stats.get(type);
        if (stat != null) {
            stat.remove(source);
        }
    }

    public void removeValueSilently(StatType type, StatSource source) {
        StatMap stat = this.stats.get(type);
        if (stat != null) {
            stat.remove(source, false);
        }
    }

    public Collection<StatType> getApplicableStats() {
        return Collections.unmodifiableCollection(this.stats.keySet());
    }

    public Map<StatType, StatMap> getStatMaps() {
        return this.stats;
    }

    public Collection<StatType> getApplicableStats(SkillTrigger trigger) {
        return this.stats.keySet().stream().filter(stat -> stat.isApplicable(trigger)).collect(Collectors.toUnmodifiableSet());
    }

    public Collection<StatMap> getPreProcessStats(SkillTrigger trigger) {
        return this.preProcessedStats.getOrDefault(trigger, EMPTY_SET);
    }

    public Collection<StatMap> getPostProcessStats(SkillTrigger trigger) {
        return this.postProcessedStats.getOrDefault(trigger, EMPTY_SET);
    }

    public Optional<StatMap> getStatData(StatType type) {
        return Optional.ofNullable(this.stats.getOrDefault(type, null));
    }

    public boolean isEmpty() {
        return this.stats.isEmpty();
    }

    public HashMap<String, Double> getBaseStats() {
        HashMap map = Maps.newHashMap();
        for (StatMap statMap : this.stats.values()) {
            StatType type = statMap.getType();
            double baseValue = statMap.getBaseValue();
            map.put(type.getKey(), baseValue);
        }
        return map;
    }

    public void updateDirtyStats() {
        this.stats.values().forEach(StatMap::updateIfDirty);
    }

    public void refresh() {
        ConcurrentMap stats = Maps.newConcurrentMap();
        for (Map.Entry<StatType, StatMap> entry : this.stats.entrySet()) {
            String key = entry.getKey().getKey();
            StatMap statMap = entry.getValue();
            Optional<StatType> maybeNewStat = MythicBukkit.inst().getStatManager().getStat(key);
            if (maybeNewStat.isEmpty()) {
                this.statsByApplication.forEach((skillTrigger, statMaps) -> {
                    statMaps.remove(statMap);
                    if (statMaps.isEmpty()) {
                        this.statsByApplication.remove(skillTrigger);
                    }
                });
                this.preProcessedStats.forEach((skillTrigger, statMaps) -> {
                    statMaps.remove(statMap);
                    if (statMaps.isEmpty()) {
                        this.preProcessedStats.remove(skillTrigger);
                    }
                });
                this.postProcessedStats.forEach((skillTrigger, statMaps) -> {
                    statMaps.remove(statMap);
                    if (statMaps.isEmpty()) {
                        this.postProcessedStats.remove(skillTrigger);
                    }
                });
                continue;
            }
            StatType newStat = maybeNewStat.get();
            statMap.setType(newStat);
            stats.put(newStat, statMap);
            statMap.handleReload();
        }
        this.stats.clear();
        this.stats.putAll(stats);
    }

    public StatExecutor getManager() {
        return this.manager;
    }

    public SkillCaster getHolder() {
        return this.holder;
    }

    public Map<SkillTrigger, List<StatMap>> getStatsByApplication() {
        return this.statsByApplication;
    }

    public Map<SkillTrigger, TreeSet<StatMap>> getPreProcessedStats() {
        return this.preProcessedStats;
    }

    public Map<SkillTrigger, TreeSet<StatMap>> getPostProcessedStats() {
        return this.postProcessedStats;
    }

    public class StatMap
    implements Comparable<StatMap> {
        private StatType type;
        private double baseValue = 1.0;
        private final Map<StatSource, Double> additives = Maps.newConcurrentMap();
        private final Map<StatSource, Double> additiveMultipliers = Maps.newConcurrentMap();
        private final Map<StatSource, Double> compoundMultipliers = Maps.newConcurrentMap();
        private final Map<StatSource, Double> setters = Maps.newConcurrentMap();
        private double cachedAdditives = 0.0;
        private double cachedAdditiveMultipliers = 1.0;
        private double cachedValue = 0.0;
        private boolean dirty = false;

        public StatMap(StatRegistry registry, StatType type) {
            this.type = type;
            this.setBaseValue(type.getBaseValue(registry));
        }

        public void setBaseValue(double value) {
            this.baseValue = value;
            this.calculateCachedValue();
        }

        public void setBaseValueSilently(double value) {
            this.baseValue = value;
            this.dirty = true;
        }

        public void updateIfDirty() {
            if (this.dirty) {
                this.dirty = false;
                this.calculateCachedValue();
            }
        }

        public void calculateCachedValue() {
            double cachedValue = this.baseValue + this.additives.values().stream().mapToDouble(Double::doubleValue).sum();
            if (!this.additiveMultipliers.isEmpty()) {
                cachedValue *= this.additiveMultipliers.values().stream().mapToDouble(Double::doubleValue).sum();
            }
            if (!this.compoundMultipliers.isEmpty()) {
                for (Double value : this.compoundMultipliers.values()) {
                    cachedValue *= value.doubleValue();
                }
            }
            if (!this.setters.isEmpty()) {
                for (Double value : this.setters.values()) {
                    cachedValue = value;
                }
            }
            if ((cachedValue = Numbers.clamp(cachedValue, this.type.getMinValue(), this.type.getMaxValue())) != this.cachedValue) {
                try {
                    double oldValue = this.cachedValue;
                    this.cachedValue = cachedValue;
                    Events.call(new MythicStatChangeEvent(StatRegistry.this.holder, this.type, oldValue, cachedValue));
                }
                catch (Error | Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public void put(StatSource source, StatModifierType operation, double value) {
            this.put(source, operation, value, true);
        }

        public void put(StatSource source, StatModifierType operation, double value, boolean refresh) {
            switch (operation) {
                case ADDITIVE: {
                    this.additives.put(source, value);
                    this.cachedAdditives = this.additives.values().stream().mapToDouble(Double::doubleValue).sum();
                    break;
                }
                case ADDITIVE_MULTIPLIER: {
                    this.additiveMultipliers.put(source, value);
                    this.cachedAdditiveMultipliers = 1.0 + this.additiveMultipliers.values().stream().mapToDouble(Double::doubleValue).sum();
                    break;
                }
                case COMPOUND_MULTIPLIER: {
                    this.compoundMultipliers.put(source, value);
                    break;
                }
                case SETTER: {
                    this.setters.put(source, value);
                }
            }
            if (refresh) {
                this.calculateCachedValue();
            } else {
                this.dirty = true;
            }
        }

        public void remove(StatSource source) {
            this.remove(source, true);
        }

        public void remove(StatSource source, boolean refresh) {
            this.additives.remove(source);
            this.additiveMultipliers.remove(source);
            this.compoundMultipliers.remove(source);
            this.setters.remove(source);
            if (refresh) {
                this.calculateCachedValue();
            } else {
                this.dirty = true;
            }
        }

        public double get() {
            return this.cachedValue;
        }

        public void handleReload() {
            this.additives.keySet().removeIf(source -> source.removeOnReload());
            this.additiveMultipliers.keySet().removeIf(source -> source.removeOnReload());
            this.compoundMultipliers.keySet().removeIf(source -> source.removeOnReload());
            this.setters.keySet().removeIf(source -> source.removeOnReload());
        }

        @Override
        public int compareTo(StatMap other) {
            int priorityComparison = Integer.compare(this.type.getPriority(), other.type.getPriority());
            if (priorityComparison == 0) {
                int val = this.type.getKey().compareTo(other.type.getKey());
                return val;
            }
            return priorityComparison;
        }

        public StatType getType() {
            return this.type;
        }

        public double getBaseValue() {
            return this.baseValue;
        }

        public double getCachedAdditives() {
            return this.cachedAdditives;
        }

        public double getCachedAdditiveMultipliers() {
            return this.cachedAdditiveMultipliers;
        }

        public double getCachedValue() {
            return this.cachedValue;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void setType(StatType type) {
            this.type = type;
        }

        public void setCachedAdditives(double cachedAdditives) {
            this.cachedAdditives = cachedAdditives;
        }

        public void setCachedAdditiveMultipliers(double cachedAdditiveMultipliers) {
            this.cachedAdditiveMultipliers = cachedAdditiveMultipliers;
        }

        public void setCachedValue(double cachedValue) {
            this.cachedValue = cachedValue;
        }

        public void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatMap)) {
                return false;
            }
            StatMap other = (StatMap)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getBaseValue(), other.getBaseValue()) != 0) {
                return false;
            }
            if (Double.compare(this.getCachedAdditives(), other.getCachedAdditives()) != 0) {
                return false;
            }
            if (Double.compare(this.getCachedAdditiveMultipliers(), other.getCachedAdditiveMultipliers()) != 0) {
                return false;
            }
            if (Double.compare(this.getCachedValue(), other.getCachedValue()) != 0) {
                return false;
            }
            if (this.isDirty() != other.isDirty()) {
                return false;
            }
            StatType this$type = this.getType();
            StatType other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Map<StatSource, Double> this$additives = this.getAdditives();
            Map<StatSource, Double> other$additives = other.getAdditives();
            if (this$additives == null ? other$additives != null : !((Object)this$additives).equals(other$additives)) {
                return false;
            }
            Map<StatSource, Double> this$additiveMultipliers = this.getAdditiveMultipliers();
            Map<StatSource, Double> other$additiveMultipliers = other.getAdditiveMultipliers();
            if (this$additiveMultipliers == null ? other$additiveMultipliers != null : !((Object)this$additiveMultipliers).equals(other$additiveMultipliers)) {
                return false;
            }
            Map<StatSource, Double> this$compoundMultipliers = this.getCompoundMultipliers();
            Map<StatSource, Double> other$compoundMultipliers = other.getCompoundMultipliers();
            if (this$compoundMultipliers == null ? other$compoundMultipliers != null : !((Object)this$compoundMultipliers).equals(other$compoundMultipliers)) {
                return false;
            }
            Map<StatSource, Double> this$setters = this.getSetters();
            Map<StatSource, Double> other$setters = other.getSetters();
            return !(this$setters == null ? other$setters != null : !((Object)this$setters).equals(other$setters));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StatMap;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $baseValue = Double.doubleToLongBits(this.getBaseValue());
            result = result * 59 + (int)($baseValue >>> 32 ^ $baseValue);
            long $cachedAdditives = Double.doubleToLongBits(this.getCachedAdditives());
            result = result * 59 + (int)($cachedAdditives >>> 32 ^ $cachedAdditives);
            long $cachedAdditiveMultipliers = Double.doubleToLongBits(this.getCachedAdditiveMultipliers());
            result = result * 59 + (int)($cachedAdditiveMultipliers >>> 32 ^ $cachedAdditiveMultipliers);
            long $cachedValue = Double.doubleToLongBits(this.getCachedValue());
            result = result * 59 + (int)($cachedValue >>> 32 ^ $cachedValue);
            result = result * 59 + (this.isDirty() ? 79 : 97);
            StatType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Map<StatSource, Double> $additives = this.getAdditives();
            result = result * 59 + ($additives == null ? 43 : ((Object)$additives).hashCode());
            Map<StatSource, Double> $additiveMultipliers = this.getAdditiveMultipliers();
            result = result * 59 + ($additiveMultipliers == null ? 43 : ((Object)$additiveMultipliers).hashCode());
            Map<StatSource, Double> $compoundMultipliers = this.getCompoundMultipliers();
            result = result * 59 + ($compoundMultipliers == null ? 43 : ((Object)$compoundMultipliers).hashCode());
            Map<StatSource, Double> $setters = this.getSetters();
            result = result * 59 + ($setters == null ? 43 : ((Object)$setters).hashCode());
            return result;
        }

        public String toString() {
            return "StatRegistry.StatMap(type=" + this.getType() + ", baseValue=" + this.getBaseValue() + ", additives=" + this.getAdditives() + ", additiveMultipliers=" + this.getAdditiveMultipliers() + ", compoundMultipliers=" + this.getCompoundMultipliers() + ", setters=" + this.getSetters() + ", cachedAdditives=" + this.getCachedAdditives() + ", cachedAdditiveMultipliers=" + this.getCachedAdditiveMultipliers() + ", cachedValue=" + this.getCachedValue() + ", dirty=" + this.isDirty() + ")";
        }

        public Map<StatSource, Double> getAdditives() {
            return this.additives;
        }

        public Map<StatSource, Double> getAdditiveMultipliers() {
            return this.additiveMultipliers;
        }

        public Map<StatSource, Double> getCompoundMultipliers() {
            return this.compoundMultipliers;
        }

        public Map<StatSource, Double> getSetters() {
            return this.setters;
        }
    }
}

