/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.IEntitySelector;
import java.util.Collection;
import java.util.HashSet;

public class PlayersInRingTargeter
extends IEntitySelector {
    private final PlaceholderDouble min;
    private final PlaceholderDouble max;

    public PlayersInRingTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.min = mlc.getPlaceholderDouble(new String[]{"min", "minrange"}, 5.0, new String[0]);
        this.max = mlc.getPlaceholderDouble(new String[]{"max", "maxrange"}, 10.0, new String[0]);
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data) {
        SkillCaster am = data.getCaster();
        HashSet<AbstractEntity> targets = new HashSet<AbstractEntity>();
        for (AbstractPlayer p : this.getPlugin().getEntityManager().getPlayers(am.getEntity().getWorld())) {
            if (!am.getLocation().getWorld().equals(p.getWorld()) || !(am.getEntity().getLocation().distanceSquared(p.getLocation()) < Math.pow(this.max.get(data), 2.0)) || !(am.getEntity().getLocation().distanceSquared(p.getLocation()) > Math.pow(this.min.get(data), 2.0))) continue;
            targets.add(p);
        }
        return targets;
    }
}

