/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableManager;
import io.lumine.mythic.core.skills.variables.VariableScope;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VariableMechanic
extends SkillMechanic {
    protected PlaceholderString key;
    protected VariableScope scope;
    protected long duration;

    public VariableMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        String strKey = mlc.getString(new String[]{"name", "n", "variable", "var", "key", "k"}, null, new String[0]);
        if (strKey == null) {
            MythicLogger.errorMechanicConfig(this, mlc, "Variable name must be set.");
            return;
        }
        String prefixVar = VariableScope.SKILL.toString();
        if (strKey.contains(".")) {
            Pattern pattern = Pattern.compile("<[^>]*>");
            Matcher matcher = pattern.matcher(strKey);
            StringBuffer tempKey = new StringBuffer();
            while (matcher.find()) {
                String replacement = matcher.group().replace(".", "##DOT##");
                matcher.appendReplacement(tempKey, replacement);
            }
            matcher.appendTail(tempKey);
            String[] split = tempKey.toString().split("\\.", 2);
            if (split.length > 1) {
                prefixVar = split[0].replace("##DOT##", ".").toUpperCase();
                this.key = PlaceholderString.of(split[1].replace("##DOT##", "."));
            } else {
                this.key = PlaceholderString.of(strKey);
            }
        } else {
            this.key = PlaceholderString.of(strKey);
        }
        String strScope = mlc.getString(new String[]{"scope", "s"}, prefixVar, new String[0]);
        try {
            this.scope = VariableScope.valueOf(strScope.toUpperCase());
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "'" + strScope + "' is not a valid variable scope.");
        }
        boolean shouldSave = mlc.getBoolean("save", false);
        long duration = mlc.getLong(new String[]{"duration", "d", "expire", "e"}, 0L);
        this.duration = duration == 0L ? (shouldSave ? 0L : 1L) : duration * 50L;
    }

    public VariableManager getVariableManager() {
        return ((MythicBukkit)this.getPlugin()).getVariableManager();
    }

    protected void handleDuration(Variable var) {
        if (this.duration > 1L) {
            var.setExpirationTime(System.currentTimeMillis() + this.duration);
        }
    }
}

