/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.spawning.spawners;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.volatilecode.VolatileMaterial;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.listeners.SpawnerListeners;
import io.lumine.mythic.bukkit.utils.config.properties.types.NodeListProp;
import io.lumine.mythic.bukkit.utils.files.Files;
import io.lumine.mythic.bukkit.utils.numbers.RandomInt;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.core.config.IOLoader;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class SpawnerManager
extends ReloadableModule<MythicBukkit> {
    private final SpawnerListeners listener;
    private List<File> spawnerFiles;
    private List<IOLoader<MythicBukkit>> spawnerLoaders;
    public List<MythicSpawner> listSpawners = Lists.newArrayList();
    public Map<AbstractLocation, MythicSpawner> mmSpawners = Maps.newConcurrentMap();
    public Map<String, Collection<MythicSpawner>> mmChunkSpawnerLookup = Maps.newConcurrentMap();
    public Map<Integer, MythicSpawner> mmSpawnerHashcodeLookup = Maps.newConcurrentMap();

    public SpawnerManager(MythicBukkit plugin) {
        super(plugin, false);
        this.listener = new SpawnerListeners(this);
        Bukkit.getPluginManager().registerEvents((Listener)this.listener, (Plugin)plugin);
    }

    @Override
    public void load(MythicBukkit plugin) {
        this.loadSpawners();
    }

    public void loadSpawners() {
        MythicLogger.log("Loading Spawn Blocks...");
        File folder = this.getSpawnerFolder();
        if (!folder.exists()) {
            MythicLogger.log("Spawners folder not found! Creating...");
            folder.mkdir();
        }
        this.listSpawners.clear();
        this.mmSpawners.clear();
        this.mmSpawnerHashcodeLookup.clear();
        this.mmChunkSpawnerLookup.clear();
        block2: for (File file : Files.getAll(folder.getAbsolutePath(), Lists.newArrayList((Object[])new String[]{"yml", "txt"}))) {
            for (String node : NodeListProp.getNodes(file, "")) {
                try {
                    MythicSpawner ms = new MythicSpawner(this, file, node);
                    this.registerSpawner(ms);
                    continue block2;
                }
                catch (Exception ex) {
                    MythicLogger.error("Error loading MythicSpawner {0}: enable debugging for stacktrace.", node);
                    MythicLogger.handleMinorError(ex);
                }
            }
        }
        this.buildSpawnerChunkLookupTable();
    }

    @Override
    public void unload() {
        this.listSpawners.clear();
        this.mmSpawners.clear();
        this.mmSpawnerHashcodeLookup.clear();
        this.mmChunkSpawnerLookup.clear();
    }

    public File getSpawnerFolder() {
        return new File(((MythicBukkit)this.getPlugin()).getDataFolder() + System.getProperty("file.separator") + "Spawners");
    }

    private void registerSpawner(MythicSpawner spawner) {
        this.listSpawners.add(spawner);
        this.mmSpawners.put(spawner.getLocation(), spawner);
        if (!this.mmSpawnerHashcodeLookup.containsKey(spawner.hashCode())) {
            this.mmSpawnerHashcodeLookup.put(spawner.hashCode(), spawner);
        } else {
            MythicSpawner conflict = this.mmSpawnerHashcodeLookup.get(spawner.hashCode());
            MythicLogger.error("WARNING: HashCode collision detected when loading spawners.");
            MythicLogger.error("Spawner 1 Hash: " + spawner.hashCode() + " Type: " + this.mmSpawnerHashcodeLookup.get(spawner.hashCode()).getInternalName());
            MythicLogger.error("Spawner 2 Hash: " + conflict.hashCode() + " Type: " + conflict.getInternalName());
            MythicLogger.error("We recommend changing one of these spawners' names to avoid issues resolving mob type.");
        }
    }

    public void saveSpawners() {
        ArrayList spawners = Lists.newArrayList(this.listSpawners);
        spawners.forEach(ms -> ms.saveSpawnerData());
    }

    public Collection<MythicSpawner> getSpawners() {
        return this.listSpawners;
    }

    public void tickSpawnerClocks() {
        this.listSpawners.stream().forEach(spawner -> {
            MythicBukkit.inst().getTimingsHandler().markSpawnerNew(spawner.getName());
            try {
                spawner.tickSpawnerClock();
            }
            catch (Error | Exception ex) {
                MythicLogger.error("Error ticking spawner {0}", spawner.getInternalName());
                ex.printStackTrace();
                spawner.setInternalCooldown(5);
            }
            MythicBukkit.inst().getTimingsHandler().markSpawnerComplete(spawner.getName());
        });
    }

    public void unloadAllSpawners() {
        for (MythicSpawner ms : this.listSpawners) {
            ms.unloadSpawner();
        }
    }

    public void resetAndSaveAll() {
        for (MythicSpawner ms : this.listSpawners) {
            ms.unloadSpawner();
        }
        this.saveSpawners();
    }

    public Collection<MythicSpawner> getSpawnersByString(String string) {
        return this.getSpawnersByString(null, string);
    }

    public Collection<MythicSpawner> getSpawnersByString(AbstractLocation abstractLocation, String string) {
        if (string == null) {
            return null;
        }
        ArrayList<MythicSpawner> msl = new ArrayList();
        if (string.startsWith("g:")) {
            String group = string.substring(2);
            msl = this.getSpawnersByGroup(group);
        } else if (string.startsWith("r:")) {
            if (abstractLocation == null) {
                return null;
            }
            String sradius = string.substring(2);
            double radius = 0.0;
            try {
                radius = Double.parseDouble(sradius);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (MythicSpawner ms : this.getSpawners()) {
                if (ms.getLocation().getWorld() == null || !ms.getLocation().getWorld().equals(abstractLocation.getWorld()) || !(ms.distanceTo(abstractLocation) <= radius)) continue;
                msl.add(ms);
            }
        } else if (string.equals("*")) {
            for (MythicSpawner ms : this.getSpawners()) {
                msl.add(ms);
            }
        } else if (string.contains("*") || string.contains("?")) {
            for (MythicSpawner ms : this.getSpawners()) {
                if (!ms.getName().matches(string.replace("?", ".?").replace("*", ".*?"))) continue;
                msl.add(ms);
            }
        } else {
            MythicSpawner ms = this.getSpawnerByName(string);
            if (ms != null) {
                msl.add(ms);
            }
        }
        return msl;
    }

    public MythicSpawner getSpawnerByName(String name) {
        for (MythicSpawner s2 : this.listSpawners) {
            if (!s2.getName().equals(name)) continue;
            return s2;
        }
        return null;
    }

    public ArrayList<MythicSpawner> getSpawnersByGroup(String group) {
        ArrayList<MythicSpawner> msl = new ArrayList<MythicSpawner>();
        for (MythicSpawner s2 : this.listSpawners) {
            try {
                if (!s2.getGroup().equals(group)) continue;
                msl.add(s2);
            }
            catch (Exception e) {}
        }
        return msl;
    }

    public MythicSpawner getSpawnerAtLocation(AbstractLocation location) {
        return this.mmSpawners.getOrDefault(location, null);
    }

    public Optional<MythicSpawner> getSpawnerByHashcode(int hashcode) {
        return Optional.ofNullable(this.mmSpawnerHashcodeLookup.getOrDefault(hashcode, null));
    }

    public Optional<Collection<MythicSpawner>> getSpawnersByChunk(String lookup) {
        return Optional.ofNullable(this.mmChunkSpawnerLookup.getOrDefault(lookup, null));
    }

    public boolean hasBreakableSpawner(AbstractLocation location) {
        if (this.mmSpawners.containsKey(location)) {
            return this.mmSpawners.get(location).isBreakable();
        }
        return false;
    }

    public MythicSpawner createSpawner(String name, Location location, String mobName) {
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Creating New Spawner at " + location.getX() + "," + location.getY() + "," + location.getZ(), new Object[0]);
        if (this.getSpawnerByName(name) != null) {
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "-- Spawner creation failed due to bad name.", new Object[0]);
            return null;
        }
        if (((MythicBukkit)this.getPlugin()).getMobManager().getMythicMob(mobName) == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "-- Spawner creation failed due to bad mob name.", new Object[0]);
            return null;
        }
        MythicSpawner newspawner = new MythicSpawner(this, name, BukkitAdapter.adapt(location), mobName);
        this.listSpawners.add(newspawner);
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "New spawner created successfully!", new Object[0]);
        return newspawner;
    }

    public boolean copySpawner(String name, String nameNew, AbstractLocation location) {
        MythicSpawner msNew;
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Creating Copy of Spawner at " + location.getX() + "," + location.getY() + "," + location.getZ(), new Object[0]);
        MythicSpawner ms = this.getSpawnerByName(name);
        try {
            msNew = ms.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return false;
        }
        msNew.setName(nameNew);
        msNew.setLocation(location);
        msNew.setAssociatedMobs(new ArrayList<UUID>());
        msNew.getAssociatedMobs().clear();
        msNew.setBreakable(false);
        msNew.setBreakable(ms.isBreakable());
        this.addSpawnerToChunkLookupTable(msNew);
        msNew.saveClone();
        this.listSpawners.add(msNew);
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "New spawner cloned successfully!", new Object[0]);
        return true;
    }

    public boolean moveSpawner(String name, AbstractLocation location) {
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Moving spawner to " + location.getX() + "," + location.getY() + "," + location.getZ(), new Object[0]);
        MythicSpawner ms = this.getSpawnerByName(name);
        if (ms == null) {
            return false;
        }
        return this.moveSpawner(ms, location);
    }

    public boolean moveSpawner(MythicSpawner ms, AbstractLocation location) {
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Moving spawner to " + location.getX() + "," + location.getY() + "," + location.getZ(), new Object[0]);
        this.removeSpawnerFromChunkLookupTable(ms);
        ms.setLocation(location);
        this.addSpawnerToChunkLookupTable(ms);
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Spawner moved successfully!", new Object[0]);
        return true;
    }

    public static synchronized boolean mobIsValid(Location location, UUID u) {
        if (location.getWorld() == null) {
            return true;
        }
        for (LivingEntity l : location.getWorld().getLivingEntities()) {
            if (!l.getUniqueId().equals(u)) continue;
            return true;
        }
        return false;
    }

    public static boolean playerWithinSpawnerRange(int range, AbstractLocation location) {
        int rangeSquared = (int)Math.pow(range, 2.0);
        for (AbstractPlayer player : MythicBukkit.inst().getEntityManager().getPlayers(location.getWorld())) {
            if (!location.getWorld().equals(player.getWorld()) || !(location.distanceSquared(player.getLocation()) <= (double)rangeSquared)) continue;
            return true;
        }
        return false;
    }

    public static void RemoveMobFromSpawners(ActiveMob am) {
        if (am.getSpawner() != null) {
            am.getSpawner().markMobDead(am);
        }
    }

    public boolean setSpawnerAttribute(MythicSpawner ms, String attr, String value) {
        value = value.trim();
        try {
            switch (attr.toLowerCase()) {
                case "group": {
                    ms.setGroup(value);
                    break;
                }
                case "radius": 
                case "r": {
                    ms.setSpawnRadius(Integer.parseInt(value));
                    break;
                }
                case "radiusy": 
                case "ry": {
                    ms.setSpawnRadiusY(Integer.parseInt(value));
                    break;
                }
                case "cooldown": 
                case "cd": {
                    ms.setCooldownSeconds(Integer.parseInt(value));
                    break;
                }
                case "warmup": 
                case "wu": {
                    ms.setWarmupSeconds(Integer.parseInt(value));
                    break;
                }
                case "maxmobs": {
                    ms.setMaxMobs(PlaceholderInt.of(value));
                    break;
                }
                case "moblevel": 
                case "level": 
                case "moblvl": {
                    try {
                        ms.setMobLevel(new RandomInt(value));
                    }
                    catch (Exception exception) {}
                    break;
                }
                case "mobsperspawn": 
                case "mps": {
                    ms.setMobsPerSpawn(Integer.parseInt(value));
                    break;
                }
                case "usetimer": 
                case "timer": {
                    ms.setUseTimer(Boolean.parseBoolean(value));
                    break;
                }
                case "showflames": 
                case "flames": {
                    ms.setShowFlames(Boolean.parseBoolean(value));
                    break;
                }
                case "activation": 
                case "activationrange": 
                case "ar": {
                    ms.setActivationRange(Integer.parseInt(value));
                    break;
                }
                case "scalingrange": 
                case "scalerange": 
                case "sr": {
                    ms.setScalingRange(Integer.parseInt(value));
                    break;
                }
                case "leash": 
                case "leashrange": {
                    ms.setLeashRange(Integer.parseInt(value));
                    break;
                }
                case "healonleash": 
                case "leashheal": {
                    ms.setHealOnLeash(Boolean.parseBoolean(value));
                    break;
                }
                case "resetthreatonleash": 
                case "leashresetthreat": {
                    ms.setLeashResetsThreat(Boolean.parseBoolean(value));
                    break;
                }
                case "mobtype": {
                    if (!ms.setType(value)) {
                        return false;
                    }
                    break;
                }
                case "breakable": {
                    ms.setBreakable(Boolean.parseBoolean(value));
                    break;
                }
                case "checkforplayers": {
                    ms.setCheckForPlayers(Boolean.parseBoolean(value));
                    break;
                }
                case "yaw": {
                    ms.setYaw(Float.parseFloat(value));
                    break;
                }
                case "pitch": {
                    ms.setPitch(Float.parseFloat(value));
                    break;
                }
                default: {
                    MythicLogger.debug(MythicLogger.DebugLevel.INFO, "The attribute " + attr + " does not exist!", new Object[0]);
                    return false;
                }
            }
        }
        catch (Exception ex) {
            MythicLogger.error("The value " + value + " is invalid for attribute " + attr);
            MythicLogger.handleMinorError(ex);
            return false;
        }
        return true;
    }

    public boolean addSpawnerCondition(MythicSpawner ms, String condition) {
        return ms.addCondition(condition);
    }

    public boolean removeSpawnerCondition(MythicSpawner ms, String condition) {
        return ms.removeCondition(condition);
    }

    public boolean addSpawnerTargetCondition(MythicSpawner ms, String condition) {
        return ms.addTargetCondition(condition);
    }

    public boolean removeSpawnerTargetCondition(MythicSpawner ms, String condition) {
        return ms.removeTargetCondition(condition);
    }

    public boolean removeSpawner(MythicSpawner ms) {
        this.listSpawners.remove(ms);
        this.mmSpawners.remove(ms.getLocation());
        this.mmSpawnerHashcodeLookup.remove(ms.hashCode());
        if (this.mmChunkSpawnerLookup.containsKey(ms.getChunkString())) {
            this.mmChunkSpawnerLookup.get(ms.getChunkString()).remove(ms);
        }
        File spawnerFile = new File(MythicBukkit.inst().getDataFolder() + System.getProperty("file.separator") + "Spawners", ms.getName() + ".yml");
        spawnerFile.delete();
        return true;
    }

    public Location findSpawningLocation(Location location, int radius) {
        for (int tries = 0; tries < 64; ++tries) {
            Location spawnLoc = SpawnerManager.randomizeSpawnLocation(location, radius);
            if (!this.areaIsEmpty(spawnLoc)) continue;
            return spawnLoc;
        }
        return null;
    }

    public static Location randomizeSpawnLocation(Location location, int r) {
        double z;
        double y;
        double x;
        double sX = location.getX();
        double sY = location.getY();
        double sZ = location.getZ();
        do {
            x = SpawnerManager.randomRange(sX - (double)r, sX + (double)r);
            y = SpawnerManager.randomRange(sY - (double)r, sY + (double)r);
            z = SpawnerManager.randomRange(sZ - (double)r, sZ + (double)r);
        } while (location.distance(new Location(location.getWorld(), x, y, z)) > (double)r);
        return new Location(location.getWorld(), x, y, z);
    }

    public static double randomRange(double arg0, double arg1) {
        double range;
        double d = range = arg0 < arg1 ? arg1 - arg0 : arg0 - arg1;
        if (range < 1.0) {
            return Math.floor(arg0) + 0.5;
        }
        double min2 = arg0 < arg1 ? arg0 : arg1;
        return Math.floor(min2 + Math.random() * range) + 0.5;
    }

    public boolean areaIsEmpty(Location loc) {
        return true;
    }

    public void addSpawnerToChunkLookupTable(MythicSpawner ms) {
        String cS = ms.getChunkString();
        if (this.mmChunkSpawnerLookup.containsKey(cS)) {
            this.mmChunkSpawnerLookup.get(cS).add(ms);
        } else {
            HashSet<MythicSpawner> hs = new HashSet<MythicSpawner>();
            hs.add(ms);
            this.mmChunkSpawnerLookup.put(cS, hs);
        }
    }

    public void removeSpawnerFromChunkLookupTable(MythicSpawner ms) {
        String cS = ms.getChunkString();
        if (this.mmChunkSpawnerLookup.containsKey(cS)) {
            this.mmChunkSpawnerLookup.get(cS).remove(ms);
        }
    }

    public void buildSpawnerChunkLookupTable() {
        this.mmChunkSpawnerLookup.clear();
        for (MythicSpawner ms : this.listSpawners) {
            this.addSpawnerToChunkLookupTable(ms);
        }
    }

    public String getSpawnerCopyName(String name) {
        return "";
    }

    public Optional<ItemStack> getSpawnerItem(String type) {
        ItemStack item = new ItemStack(VolatileMaterial.SPAWNER);
        return Optional.ofNullable(null);
    }

    public void filterSpawners(List<MythicSpawner> spawners, String filter) {
        if (filter == null) {
            return;
        }
        if (filter.startsWith("g:")) {
            String group = filter.substring(2);
            spawners.removeIf(spawner -> !spawner.getGroup().equals(group));
        } else if (filter.contains("*") || filter.contains("?")) {
            spawners.removeIf(spawner -> {
                String regex = filter.replace("?", ".?").replace("*", ".*?");
                return !spawner.getName().matches(regex);
            });
        }
    }
}

