/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.utils.physics;

import org.bukkit.Location;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class VectorMath {
    protected static final double DEGREES_TO_RADIANS = Math.PI / 180;

    @NotNull
    public static Vector fromYawAndPitch(float yaw, float pitch) {
        double y = Math.sin((double)pitch * (Math.PI / 180));
        double div = Math.cos((double)pitch * (Math.PI / 180));
        double x = Math.cos((double)(yaw += 90.0f) * (Math.PI / 180)) * div;
        double z = Math.sin((double)yaw * (Math.PI / 180)) * div;
        return new Vector(x, y, z);
    }

    @NotNull
    public static Vector angleBetween(@NotNull Location a, @NotNull Location b) {
        return new Vector(b.getX() - a.getX(), b.getY() - a.getY(), b.getZ() - a.getZ());
    }

    @NotNull
    public static Vector angleBetween(@NotNull Vector a, @NotNull Vector b) {
        return new Vector(b.getX() - a.getX(), b.getY() - a.getY(), b.getZ() - a.getZ());
    }
}

