/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_16_R3;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractBlock;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.volatilecode.VolatileCodeHandler;
import io.lumine.mythic.api.volatilecode.handlers.VolatileBlockHandler;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.adapters.BukkitBlock;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.reflection.Reflector;
import io.lumine.mythic.core.logging.MythicLogger;
import it.unimi.dsi.fastutil.shorts.ShortArraySet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.server.v1_16_R3.Block;
import net.minecraft.server.v1_16_R3.BlockPiston;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.EnumDirection;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketPlayOutMultiBlockChange;
import net.minecraft.server.v1_16_R3.SectionPosition;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.type.Piston;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;

public class VolatileBlockHandler_v1_16_R3
implements VolatileBlockHandler {
    private Reflector<PacketPlayOutMultiBlockChange> refBlockUpdates;

    public VolatileBlockHandler_v1_16_R3(VolatileCodeHandler handler) {
        try {
            this.refBlockUpdates = new Reflector<PacketPlayOutMultiBlockChange>(PacketPlayOutMultiBlockChange.class, "d");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void sendMultiBlockChange(Collection<AbstractPlayer> audience, Map<AbstractLocation, AbstractBlock> changeMap) {
        if (changeMap.isEmpty()) {
            return;
        }
        for (PacketPlayOutMultiBlockChange packet : this.getSectionUpdatePackets(changeMap)) {
            for (AbstractPlayer player : audience) {
                EntityPlayer nmsPlayer = ((CraftPlayer)BukkitAdapter.adapt(player)).getHandle();
                nmsPlayer.playerConnection.sendPacket((Packet)packet);
            }
        }
    }

    public Collection<PacketPlayOutMultiBlockChange> getSectionUpdatePackets(Map<AbstractLocation, AbstractBlock> changeMap) {
        LinkedHashMap blocksMap = Maps.newLinkedHashMap();
        for (Map.Entry<AbstractLocation, AbstractBlock> entry : changeMap.entrySet()) {
            IBlockData blockState;
            AbstractLocation location = entry.getKey();
            WorldServer nmsWorld = ((CraftWorld)BukkitAdapter.adapt(location).getWorld()).getHandle();
            AbstractBlock aBlockData = entry.getValue();
            BlockPosition blockPosition = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            SectionPosition section = SectionPosition.a((BlockPosition)blockPosition);
            if (!blocksMap.containsKey(section)) {
                blocksMap.put(section, Maps.newLinkedHashMap());
            }
            if (aBlockData == null) {
                blockState = nmsWorld.getType(blockPosition);
            } else {
                if (!(aBlockData instanceof BukkitBlock)) continue;
                BukkitBlock bukkitBlock = (BukkitBlock)aBlockData;
                blockState = ((CraftBlockData)bukkitBlock.getBlockData()).getState();
            }
            ((Map)blocksMap.get(section)).put(SectionPosition.b((BlockPosition)blockPosition), blockState);
        }
        ArrayList packets = Lists.newArrayList();
        for (Map.Entry entry : blocksMap.entrySet()) {
            SectionPosition section = (SectionPosition)entry.getKey();
            ShortArraySet shortArraySet = new ShortArraySet();
            shortArraySet.addAll(((Map)entry.getValue()).keySet());
            IBlockData[] blockData = ((Map)entry.getValue()).values().toArray(new IBlockData[0]);
            PacketPlayOutMultiBlockChange packet = new PacketPlayOutMultiBlockChange(section, (ShortSet)shortArraySet, null, false);
            this.refBlockUpdates.set(packet, "d", blockData);
            packets.add(packet);
        }
        return packets;
    }

    @Override
    public void applyPhysics(org.bukkit.block.Block target) {
        Location location = target.getLocation();
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        BlockPosition blockposition = new BlockPosition(location.getX(), location.getY(), location.getZ());
        IBlockData iblockdata = world.getType(blockposition);
        Block block = iblockdata.getBlock();
        world.applyPhysics(blockposition, block);
    }

    @Override
    public void togglePowerable(AbstractLocation location) {
        this.togglePowerable(location, 0L);
    }

    @Override
    public void togglePowerable(AbstractLocation location, long duration) {
        Location l = BukkitAdapter.adapt(location);
        org.bukkit.block.Block block = l.getWorld().getBlockAt(l);
        BlockData bd = block.getBlockData();
        if (bd instanceof Powerable) {
            Powerable pbd = (Powerable)bd;
            pbd.setPowered(true);
            block.setBlockData((BlockData)pbd);
            this.applyPhysics(block);
            Schedulers.sync().runLater(() -> {
                pbd.setPowered(false);
                block.setBlockData((BlockData)pbd);
                this.applyPhysics(block);
            }, duration);
        }
    }

    @Override
    public void togglePiston(AbstractLocation target) {
        Location location = BukkitAdapter.adapt(target);
        org.bukkit.block.Block block = location.getBlock();
        if (block.getType() != Material.PISTON) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Location was not piston", new Object[0]);
            return;
        }
        BlockData bd = block.getBlockData();
        Piston redstone = (Piston)bd;
        boolean extended = redstone.isExtended();
        BlockFace bf = ((Directional)bd).getFacing();
        if (extended) {
            redstone.setExtended(false);
            block.setBlockData((BlockData)redstone);
        }
        redstone.setExtended(true);
        block.setBlockData((BlockData)redstone);
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        BlockPosition blockposition = new BlockPosition(location.getX(), location.getY(), location.getZ());
        IBlockData iblockdata = world.getType(blockposition);
        boolean bold = BlockPiston.a((IBlockData)iblockdata, (World)world, (BlockPosition)blockposition, (EnumDirection)EnumDirection.DOWN, (boolean)true, (EnumDirection)EnumDirection.DOWN);
        if (!bold) {
            redstone.setExtended(false);
            block.setBlockData((BlockData)redstone);
        }
    }
}

