/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_16_R3.virtual;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntity;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntityRenderer;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.Set;
import net.minecraft.server.v1_16_R3.DataWatcherRegistry;
import net.minecraft.server.v1_16_R3.DataWatcherSerializer;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketDataSerializer;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityVelocity;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_16_R3.Vec3D;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;

public abstract class VirtualEntity<T extends PacketEntity<?>>
extends PacketEntityRenderer<T> {
    public VirtualEntity(T wrapper) {
        super(wrapper);
    }

    @Override
    public Collection<Object> getSpawnPackets(AbstractPlayer target) {
        Player player = BukkitAdapter.adapt(target);
        PacketPlayOutSpawnEntity packetSpawn = this.createSpawnPacket();
        PacketPlayOutEntityMetadata packetData = this.createDataPacket(true);
        return Lists.newArrayList((Object[])new Object[]{packetSpawn, packetData});
    }

    @Override
    public void sendPacket(Object ... packets) {
        Schedulers.ensureAsync(() -> {
            Set set = this.trackedPlayers.keySet();
            for (Object object : packets) {
                if (object == null || !(object instanceof Packet)) continue;
                Packet packet = (Packet)object;
                for (AbstractPlayer player : set) {
                    ((CraftPlayer)player.getBukkitEntity()).getHandle().playerConnection.sendPacket(packet);
                }
            }
        });
    }

    @Override
    public void sendPacket(AbstractPlayer player, Object ... packets) {
        Schedulers.ensureAsync(() -> {
            Set set = this.trackedPlayers.keySet();
            for (Object object : packets) {
                if (object == null || !(object instanceof Packet)) continue;
                Packet packet = (Packet)object;
                ((CraftPlayer)player.getBukkitEntity()).getHandle().playerConnection.sendPacket(packet);
            }
        });
    }

    @Override
    public void sendPacket(AbstractPlayer player, Collection<Object> packets) {
        Schedulers.ensureAsync(() -> {
            Set set = this.trackedPlayers.keySet();
            for (Object object : packets) {
                if (object == null || !(object instanceof Packet)) continue;
                Packet packet = (Packet)object;
                ((CraftPlayer)player.getBukkitEntity()).getHandle().playerConnection.sendPacket(packet);
            }
        });
    }

    @Override
    public void mountEntity(AbstractEntity entity) {
    }

    protected abstract PacketPlayOutSpawnEntity createSpawnPacket();

    protected PacketPlayOutSpawnEntity createSpawnPacket(EntityTypes entityType) {
        AbstractLocation location = ((PacketEntity)this.getWrapper()).getLocation().get();
        return new PacketPlayOutSpawnEntity(this.getEntityId(), this.getUniqueId(), location.getX(), location.getY(), location.getZ(), 0.0f, 0.0f, entityType, 0, Vec3D.ORIGIN);
    }

    protected abstract PacketPlayOutEntityMetadata createDataPacket(boolean var1);

    protected PacketPlayOutEntityDestroy createRemovePacket() {
        return new PacketPlayOutEntityDestroy(new int[]{this.entityId});
    }

    protected PacketPlayOutEntityVelocity createVelocityPacket(double x, double y, double z) {
        return new PacketPlayOutEntityVelocity(this.entityId, new Vec3D(x, y, z));
    }

    protected PacketPlayOutEntityTeleport createTeleportPacket(double x, double y, double z, float yaw, float pitch) {
        PacketDataSerializer pos = new PacketDataSerializer(Unpooled.buffer());
        pos.d(this.entityId);
        pos.writeDouble(x);
        pos.writeDouble(y);
        pos.writeDouble(z);
        pos.writeByte((int)((byte)(yaw / 360.0f * 255.0f)));
        pos.writeByte(0);
        pos.writeBoolean(false);
        PacketPlayOutEntityTeleport packet = new PacketPlayOutEntityTeleport();
        try {
            packet.a(pos);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return packet;
    }

    public static <T> void writeData(PacketDataSerializer byteBuf, int id, DataWatcherSerializer<T> serializer, T val) {
        int serializedId = DataWatcherRegistry.b(serializer);
        byteBuf.writeByte(id);
        PacketDataSerializer.a((int)serializedId);
        serializer.a(byteBuf, val);
    }
}

