/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_19_R1_2.ai.targeters;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.ai.WrappedPathfindingGoal;
import io.lumine.mythic.core.utils.annotations.MythicAIGoal;
import io.lumine.mythic.core.volatilecode.v1_19_R1_2.ai.PathfinderHolder;
import java.util.Optional;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.EntityMonster;
import org.bukkit.entity.Entity;

@MythicAIGoal(name="nearestOtherFactionMonsters", aliases={"otherFactionMonsters"}, description="Target a nearby monster that is in a different faction")
public class OtherFactionMonstersGoal
extends WrappedPathfindingGoal
implements PathfinderHolder {
    public OtherFactionMonstersGoal(AbstractEntity entity, String line, MythicLineConfig mlc) {
        super(entity, line, mlc);
    }

    @Override
    public boolean isValid() {
        return this.entity.isCreature();
    }

    @Override
    public PathfinderGoal create() {
        return new PathfinderGoalNearestAttackableTarget((EntityInsentient)PathfinderHolder.getNMSEntity(this.entity), EntityMonster.class, 0, true, false, targetEntity -> {
            try {
                ActiveMob mob = OtherFactionMonstersGoal.getPlugin().getMobManager().getMythicMobInstance(this.getEntity());
                AbstractEntity target = BukkitAdapter.adapt((Entity)((EntityLiving)targetEntity).getBukkitEntity());
                if (mob == null || !mob.hasFaction()) {
                    return true;
                }
                if (target.isPlayer()) {
                    return !OtherFactionMonstersGoal.getPlugin().getPlayerManager().getFactionProvider().isInFaction(target.asPlayer(), mob.getFaction());
                }
                Optional<ActiveMob> maybeTargetAM = OtherFactionMonstersGoal.getPlugin().getMobManager().getActiveMob(target.getUniqueId());
                if (!maybeTargetAM.isPresent()) {
                    return true;
                }
                ActiveMob targetAM = maybeTargetAM.get();
                if (targetAM.hasFaction()) {
                    return !mob.getFaction().equals(targetAM.getFaction());
                }
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        });
    }
}

