/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_19_R2;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractBlock;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.volatilecode.VolatileCodeHandler;
import io.lumine.mythic.api.volatilecode.handlers.VolatileBlockHandler;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.adapters.BukkitBlock;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.logging.MythicLogger;
import it.unimi.dsi.fastutil.shorts.ShortArraySet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutMultiBlockChange;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.piston.BlockPiston;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.type.Piston;
import org.bukkit.craftbukkit.v1_19_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftPlayer;

public class VolatileBlockHandlerImpl
implements VolatileBlockHandler {
    public VolatileBlockHandlerImpl(VolatileCodeHandler handler) {
    }

    @Override
    public void sendMultiBlockChange(Collection<AbstractPlayer> audience, Map<AbstractLocation, AbstractBlock> changeMap) {
        if (changeMap.isEmpty()) {
            return;
        }
        for (PacketPlayOutMultiBlockChange packet : VolatileBlockHandlerImpl.getSectionUpdatePackets(changeMap)) {
            for (AbstractPlayer player : audience) {
                EntityPlayer nmsPlayer = ((CraftPlayer)BukkitAdapter.adapt(player)).getHandle();
                nmsPlayer.b.a((Packet)packet);
            }
        }
    }

    public static Collection<PacketPlayOutMultiBlockChange> getSectionUpdatePackets(Map<AbstractLocation, AbstractBlock> changeMap) {
        LinkedHashMap blocksMap = Maps.newLinkedHashMap();
        for (Map.Entry<AbstractLocation, AbstractBlock> entry : changeMap.entrySet()) {
            IBlockData blockState;
            AbstractLocation location = entry.getKey();
            WorldServer nmsWorld = ((CraftWorld)BukkitAdapter.adapt(location).getWorld()).getHandle();
            AbstractBlock aBlockData = entry.getValue();
            BlockPosition blockPosition = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            SectionPosition section = SectionPosition.a((BlockPosition)blockPosition);
            if (!blocksMap.containsKey(section)) {
                blocksMap.put(section, Maps.newLinkedHashMap());
            }
            if (aBlockData == null) {
                blockState = nmsWorld.a_(blockPosition);
            } else {
                if (!(aBlockData instanceof BukkitBlock)) continue;
                BukkitBlock bukkitBlock = (BukkitBlock)aBlockData;
                blockState = ((CraftBlockData)bukkitBlock.getBlockData()).getState();
            }
            ((Map)blocksMap.get(section)).put(SectionPosition.b((BlockPosition)blockPosition), blockState);
        }
        ArrayList packets = Lists.newArrayList();
        for (Map.Entry entry : blocksMap.entrySet()) {
            SectionPosition section = (SectionPosition)entry.getKey();
            ShortArraySet shortArraySet = new ShortArraySet();
            shortArraySet.addAll(((Map)entry.getValue()).keySet());
            IBlockData[] blockData = ((Map)entry.getValue()).values().toArray(new IBlockData[0]);
            packets.add(new PacketPlayOutMultiBlockChange(section, (ShortSet)shortArraySet, blockData, false));
        }
        return packets;
    }

    @Override
    public void applyPhysics(org.bukkit.block.Block target) {
        Location location = target.getLocation();
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        BlockPosition blockposition = new BlockPosition(location.getX(), location.getY(), location.getZ());
        IBlockData iblockdata = world.a_(blockposition);
        Block block = iblockdata.b();
        world.b(blockposition, block);
    }

    @Override
    public void togglePowerable(AbstractLocation location) {
        this.togglePowerable(location, 0L);
    }

    @Override
    public void togglePowerable(AbstractLocation location, long duration) {
        Location l = BukkitAdapter.adapt(location);
        org.bukkit.block.Block block = l.getWorld().getBlockAt(l);
        BlockData bd = block.getBlockData();
        if (bd instanceof Powerable) {
            Powerable pbd = (Powerable)bd;
            pbd.setPowered(true);
            block.setBlockData((BlockData)pbd);
            this.applyPhysics(block);
            Schedulers.sync().runLater(() -> {
                pbd.setPowered(false);
                block.setBlockData((BlockData)pbd);
                this.applyPhysics(block);
            }, duration);
        }
    }

    @Override
    public void togglePiston(AbstractLocation target) {
        Location location = BukkitAdapter.adapt(target);
        org.bukkit.block.Block block = location.getBlock();
        if (block.getType() != Material.PISTON) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Location was not piston", new Object[0]);
            return;
        }
        BlockData bd = block.getBlockData();
        Piston redstone = (Piston)bd;
        boolean extended = redstone.isExtended();
        BlockFace bf = ((Directional)bd).getFacing();
        if (extended) {
            redstone.setExtended(false);
            block.setBlockData((BlockData)redstone);
        }
        redstone.setExtended(true);
        block.setBlockData((BlockData)redstone);
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        BlockPosition blockposition = new BlockPosition(location.getX(), location.getY(), location.getZ());
        IBlockData iblockdata = world.a_(blockposition);
        boolean bold = BlockPiston.a((IBlockData)iblockdata, (World)world, (BlockPosition)blockposition, (EnumDirection)EnumDirection.c, (boolean)true, (EnumDirection)EnumDirection.d);
        if (!bold) {
            redstone.setExtended(false);
            block.setBlockData((BlockData)redstone);
        }
    }
}

