/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro;

import eu.nononitas.plhidepro.api.player.PlHidePlayer;
import eu.nononitas.plhidepro.api.player.PlHidePlayerManager;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlHidePlayerManagerImpl
implements PlHidePlayerManager {
    private final ConcurrentHashMap<UUID, PlHidePlayer> playerHashMap = new ConcurrentHashMap();

    public void registerPlayer(@NotNull PlHidePlayer plHidePlayer) {
        this.playerHashMap.put(this.getUniqueIdFromHandle(plHidePlayer.getHandle()), plHidePlayer);
    }

    @Override
    public <P> boolean isRegistered(P p) {
        return this.isRegistered(this.getUniqueIdFromHandle(p));
    }

    @Override
    public boolean isRegistered(UUID uUID) {
        return this.playerHashMap.containsKey(uUID);
    }

    public void unregisterPlayer(@NotNull PlHidePlayer plHidePlayer) {
        this.unregisterPlayer(this.getUniqueIdFromHandle(plHidePlayer.getHandle()));
    }

    public <P> void unregisterPlayer(P p) {
        this.unregisterPlayer(this.getUniqueIdFromHandle(p));
    }

    public void unregisterPlayer(UUID uUID) {
        this.playerHashMap.remove(uUID);
    }

    @Override
    @Nullable
    public <PlHPlayer extends PlHidePlayer> PlHPlayer getPlHidePlayer(UUID uUID) {
        return (PlHPlayer)this.playerHashMap.get(uUID);
    }

    @Override
    @Nullable
    public <P, PlHPlayer extends PlHidePlayer> PlHPlayer getPlHidePlayer(@NotNull P p) {
        return (PlHPlayer)this.playerHashMap.get(this.getUniqueIdFromHandle(p));
    }

    public List<PlHidePlayer> getAll() {
        return Arrays.asList(this.playerHashMap.values().toArray(new PlHidePlayer[0]));
    }

    private <P> UUID getUniqueIdFromHandle(@NotNull P p) {
        UUID uUID = null;
        try {
            uUID = (UUID)p.getClass().getMethod("getUniqueId", new Class[0]).invoke(p, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
        }
        return uUID;
    }

    private <P> String getNameFromHandle(@NotNull P p) {
        String string = "null";
        try {
            string = (String)p.getClass().getMethod("getName", new Class[0]).invoke(p, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                string = (String)p.getClass().getMethod("getUsername", new Class[0]).invoke(p, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
        }
        return string;
    }
}

