/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.bungee.listeners;

import com.mojang.brigadier.tree.RootCommandNode;
import dev.simplix.protocolize.api.Direction;
import dev.simplix.protocolize.api.listener.AbstractPacketListener;
import dev.simplix.protocolize.api.listener.PacketReceiveEvent;
import dev.simplix.protocolize.api.listener.PacketSendEvent;
import eu.nononitas.plhidepro.bungee.PlHideProBungee;
import eu.nononitas.plhidepro.bungee.impl.PlHideBungeePlayer;
import eu.nononitas.plhidepro.modifier.SuggestionEditor;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.packet.Commands;

public class CommandSuggestionListener
extends AbstractPacketListener<Commands>
implements Listener {
    private static final Set<UUID> pendingLoginPlayerList = ConcurrentHashMap.newKeySet();
    private final PlHideProBungee plhide;

    public CommandSuggestionListener(PlHideProBungee plHideProBungee) {
        super(Commands.class, Direction.UPSTREAM, 0x7FFFFFFE);
        this.plhide = plHideProBungee;
    }

    @EventHandler
    public void onConnect(PostLoginEvent postLoginEvent) {
        if (!postLoginEvent.getPlayer().getPendingConnection().isLegacy()) {
            pendingLoginPlayerList.add(postLoginEvent.getPlayer().getUniqueId());
        }
    }

    public void packetSend(PacketSendEvent<Commands> packetSendEvent) {
        RootCommandNode rootCommandNode = ((Commands)packetSendEvent.packet()).getRoot();
        if (packetSendEvent.player() == null) {
            ProxyServer.getInstance().getScheduler().runAsync(this.plhide.getPlugin(), () -> {
                Iterator<UUID> iterator = pendingLoginPlayerList.iterator();
                while (iterator.hasNext()) {
                    ProxiedPlayer proxiedPlayer = ProxyServer.getInstance().getPlayer(iterator.next());
                    if (proxiedPlayer != null && proxiedPlayer.getPendingConnection().isConnected()) {
                        proxiedPlayer.getPendingConnection().unsafe().sendPacket((DefinedPacket)new Commands(rootCommandNode));
                    }
                    iterator.remove();
                }
            });
            packetSendEvent.cancelled(true);
            return;
        }
        ProxiedPlayer proxiedPlayer = (ProxiedPlayer)packetSendEvent.player().handle();
        pendingLoginPlayerList.remove(proxiedPlayer.getUniqueId());
        if (!this.plhide.getPlayerManager().isRegistered(proxiedPlayer)) {
            packetSendEvent.cancelled(true);
            this.plhide.getLogger().warn(String.format("Received a commands suggestion request from %s even though he is not registered. Aborting request", proxiedPlayer.getName()));
            return;
        }
        PlHideBungeePlayer plHideBungeePlayer = (PlHideBungeePlayer)this.plhide.getPlayerManager().getPlHidePlayer(proxiedPlayer);
        SuggestionEditor.editSuggestion(rootCommandNode, plHideBungeePlayer);
        ((Commands)packetSendEvent.packet()).setRoot(rootCommandNode);
    }

    public void packetReceive(PacketReceiveEvent<Commands> packetReceiveEvent) {
    }
}

