/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.bungee.listeners;

import eu.nononitas.plhidepro.PlHidePlayerManagerImpl;
import eu.nononitas.plhidepro.bungee.PlHideProBungee;
import eu.nononitas.plhidepro.bungee.impl.PlHideBungeePlayer;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;

public class JoinLeaveListener
implements Listener {
    private final PlHideProBungee plHide;

    public JoinLeaveListener(PlHideProBungee plHideProBungee) {
        this.plHide = plHideProBungee;
    }

    @EventHandler
    public void onServerSwitchEvent(ServerSwitchEvent serverSwitchEvent) {
        PlHidePlayerManagerImpl plHidePlayerManagerImpl = this.plHide.getPlayerManager();
        if (!plHidePlayerManagerImpl.isRegistered(serverSwitchEvent.getPlayer())) {
            PlHideBungeePlayer plHideBungeePlayer = new PlHideBungeePlayer(serverSwitchEvent.getPlayer(), this.plHide);
            plHidePlayerManagerImpl.registerPlayer(plHideBungeePlayer);
            this.printRegisterDebug(plHideBungeePlayer, serverSwitchEvent.getPlayer());
        } else {
            PlHideBungeePlayer plHideBungeePlayer = (PlHideBungeePlayer)plHidePlayerManagerImpl.getPlHidePlayer(serverSwitchEvent.getPlayer());
            ProxyServer.getInstance().getScheduler().runAsync(this.plHide.getPlugin(), () -> {
                plHideBungeePlayer.updateGroup();
                this.printRegisterDebug(plHideBungeePlayer, serverSwitchEvent.getPlayer());
            });
        }
    }

    @EventHandler
    public void onLeave(PlayerDisconnectEvent playerDisconnectEvent) {
        this.plHide.getPlayerManager().unregisterPlayer(playerDisconnectEvent.getPlayer());
        this.plHide.getLogger().debug("Unregistered player: " + playerDisconnectEvent.getPlayer().getName());
    }

    private void printRegisterDebug(PlHideBungeePlayer plHideBungeePlayer, ProxiedPlayer proxiedPlayer) {
        this.plHide.getLogger().debug("Registered player: " + proxiedPlayer.getName() + " \nServer " + proxiedPlayer.getServer().getInfo().getName() + " \nGroup " + plHideBungeePlayer.getGroup().getGroupNames() + " \nGroup mode commands " + (Object)((Object)plHideBungeePlayer.getGroupModeCommands()) + " \nGroup mode tabcomplete " + (Object)((Object)plHideBungeePlayer.getGroupModeTabcomplete()) + " \nInherited groups " + plHideBungeePlayer.getGroup().getInheritedGroups() + " \nUnblock pl-named-commands execution " + plHideBungeePlayer.unblockPluginNamedCommandsExecution() + " \nUnblock pl-named-commands tabcomplete " + plHideBungeePlayer.unblockPluginNamedCommandsTabcomplete());
    }
}

