/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.bungee.listeners;

import dev.simplix.protocolize.api.Direction;
import dev.simplix.protocolize.api.Protocolize;
import dev.simplix.protocolize.api.listener.AbstractPacketListener;
import dev.simplix.protocolize.api.listener.PacketReceiveEvent;
import dev.simplix.protocolize.api.listener.PacketSendEvent;
import dev.simplix.protocolize.api.player.ProtocolizePlayer;
import eu.nononitas.plhidepro.bungee.PlHideProBungee;
import eu.nononitas.plhidepro.util.ByteBufSerializer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.scheduler.ScheduledTask;
import net.md_5.bungee.protocol.packet.PluginMessage;

public class PluginMessagesListener
extends AbstractPacketListener<PluginMessage> {
    private final PlHideProBungee plhide;

    public PluginMessagesListener(PlHideProBungee plHideProBungee) {
        super(PluginMessage.class, Direction.UPSTREAM, 1);
        this.plhide = plHideProBungee;
    }

    public void packetReceive(PacketReceiveEvent<PluginMessage> packetReceiveEvent) {
    }

    public void packetSend(PacketSendEvent<PluginMessage> packetSendEvent) {
        PluginMessage pluginMessage = (PluginMessage)packetSendEvent.packet();
        ProxiedPlayer proxiedPlayer = (ProxiedPlayer)packetSendEvent.player().handle();
        String string = this.plhide.getBrandChannel(proxiedPlayer);
        if (pluginMessage.getTag().equals(string)) {
            if (!this.plhide.getConfig().getBoolean("replace-f3-server-brand")) {
                return;
            }
            if (proxiedPlayer.getServer() == null) {
                packetSendEvent.cancelled(true);
                this.resendPacketLater(proxiedPlayer, string);
                return;
            }
            packetSendEvent.packet((Object)this.getPluginMessage(proxiedPlayer, string));
        }
    }

    private void resendPacketLater(ProxiedPlayer proxiedPlayer, String string) {
        AtomicReference<ScheduledTask> atomicReference = new AtomicReference<ScheduledTask>();
        atomicReference.set(ProxyServer.getInstance().getScheduler().schedule(this.plhide.getPlugin(), () -> {
            if (!proxiedPlayer.isConnected()) {
                if (atomicReference.get() != null) {
                    ((ScheduledTask)atomicReference.get()).cancel();
                }
                return;
            }
            if (proxiedPlayer.getServer() == null) {
                return;
            }
            ProtocolizePlayer protocolizePlayer = Protocolize.playerProvider().player(proxiedPlayer.getUniqueId());
            if (protocolizePlayer != null) {
                protocolizePlayer.sendPacket((Object)this.getPluginMessage(proxiedPlayer, string));
            }
            ((ScheduledTask)atomicReference.get()).cancel();
        }, 100L, 100L, TimeUnit.MILLISECONDS));
    }

    private PluginMessage getPluginMessage(ProxiedPlayer proxiedPlayer, String string) {
        String string2 = this.plhide.getColoredConfigString("f3-server-brand").replace("%server%", proxiedPlayer.getServer().getInfo().getName()) + ChatColor.RESET;
        return new PluginMessage(string, ByteBufSerializer.getByteArray(string2), true);
    }
}

