/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.bungee.listeners;

import eu.nononitas.plhidepro.PlHidePlayerManagerImpl;
import eu.nononitas.plhidepro.api.player.PlHidePlayer;
import eu.nononitas.plhidepro.bungee.PlHideProBungee;
import eu.nononitas.plhidepro.modifier.TabCompleteEditor;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.TabCompleteEvent;
import net.md_5.bungee.api.event.TabCompleteResponseEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;

public class TabCompleteListener
implements Listener {
    private final HashMap<UUID, String> inputMessageMap = new HashMap();
    private final PlHideProBungee plhide;

    public TabCompleteListener(PlHideProBungee plHideProBungee) {
        this.plhide = plHideProBungee;
    }

    @EventHandler
    public void onTabComplete(TabCompleteEvent tabCompleteEvent) {
        ProxiedPlayer proxiedPlayer = (ProxiedPlayer)tabCompleteEvent.getSender();
        this.inputMessageMap.put(proxiedPlayer.getUniqueId(), tabCompleteEvent.getCursor());
        if (tabCompleteEvent.getSuggestions().isEmpty()) {
            return;
        }
        this.changeTabComplete(proxiedPlayer, tabCompleteEvent.getSuggestions());
    }

    @EventHandler
    public void onPlayerDisconnect(PlayerDisconnectEvent playerDisconnectEvent) {
        this.inputMessageMap.remove(playerDisconnectEvent.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onTabCompleteResponse(TabCompleteResponseEvent tabCompleteResponseEvent) {
        this.changeTabComplete((ProxiedPlayer)tabCompleteResponseEvent.getReceiver(), tabCompleteResponseEvent.getSuggestions());
    }

    private void changeTabComplete(ProxiedPlayer proxiedPlayer, List<String> list) {
        String string2 = this.inputMessageMap.get(proxiedPlayer.getUniqueId());
        if (string2.startsWith("/")) {
            PlHidePlayerManagerImpl plHidePlayerManagerImpl = this.plhide.getPlayerManager();
            if (!plHidePlayerManagerImpl.isRegistered(proxiedPlayer)) {
                list.clear();
                this.plhide.getLogger().warn(String.format("Received a tabcompletion request from %s even though he is not registered. Aborting completion", proxiedPlayer.getName()));
                return;
            }
            Object PlHPlayer = plHidePlayerManagerImpl.getPlHidePlayer(proxiedPlayer);
            TabCompleteEditor tabCompleteEditor = proxiedPlayer.getPendingConnection().getVersion() >= 393 ? new TabCompleteEditor((PlHidePlayer)PlHPlayer, string2.replaceFirst("/", ""), list) : new TabCompleteEditor((PlHidePlayer)PlHPlayer, string2, list).setLegacyCompletion();
            tabCompleteEditor.change();
        } else {
            if (proxiedPlayer.getPendingConnection().getVersion() >= 393) {
                list.clear();
                return;
            }
            list.removeIf(string -> string.startsWith("/"));
        }
    }
}

