/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.bungee.miscellaneous;

import com.google.common.io.ByteStreams;
import eu.nononitas.plhidepro.bungee.PlHideProBungee;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class ConfigHandler {
    private final File file;
    private Configuration configuration;

    public ConfigHandler(File file) {
        this.file = file;
    }

    public void createFile() {
        try {
            if (!this.file.exists()) {
                this.file.mkdirs();
                this.file.createNewFile();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void createDefaultFile() {
        this.createFile();
        try (InputStream inputStream = PlHideProBungee.getInstance().getPlugin().getResourceAsStream("config-bungee.yml");
             FileOutputStream fileOutputStream = new FileOutputStream(this.file);){
            ByteStreams.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void save() {
        try {
            ConfigurationProvider.getProvider(YamlConfiguration.class).save(this.configuration, this.file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void load() {
        try {
            this.configuration = ConfigurationProvider.getProvider(YamlConfiguration.class).load(this.file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getColorTranslatedString(String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.configuration.getString(string));
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

