/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.group;

import eu.nononitas.plhidepro.PlHidePro;
import eu.nononitas.plhidepro.PlHideProvider;
import eu.nononitas.plhidepro.PlHideProxyPlayer;
import eu.nononitas.plhidepro.group.Group;
import eu.nononitas.plhidepro.group.SimpleProxyGroup;
import eu.nononitas.plhidepro.miscellaneous.IConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ProxyGroup
extends Group {
    private final String serverName;

    public ProxyGroup(List<String> list, String string, boolean bl, PlHidePro plHidePro) {
        super(plHidePro);
        this.groupNameList = list;
        this.serverName = string;
        this.isLegacy = bl;
    }

    public static ProxyGroup getGroup(PlHideProxyPlayer plHideProxyPlayer, PlHidePro plHidePro) {
        String string = plHideProxyPlayer.getServerName();
        ArrayList<String> arrayList = new ArrayList<String>();
        IConfig iConfig = PlHideProvider.getPlHidePro().getConfig();
        IConfig iConfig2 = iConfig.getSection("groups");
        if (plHideProxyPlayer.hasPermission("*") && iConfig2.containsKey("*")) {
            arrayList.add("*");
        } else {
            int n = 0;
            for (String string3 : iConfig2.getAllKeys()) {
                IConfig iConfig3 = iConfig2.getSection(string3);
                List<String> list = iConfig3.getStringList("enabled_servers");
                if (!plHideProxyPlayer.hasPermission("plhide.group." + string3) || !list.contains("all") && !list.stream().anyMatch(string2 -> {
                    if (string2.equalsIgnoreCase(string)) {
                        return true;
                    }
                    return Pattern.matches(string2, string);
                })) continue;
                int n2 = iConfig3.getInt("priority");
                if (n2 > n) {
                    n = n2;
                    arrayList.clear();
                    arrayList.add(string3);
                    continue;
                }
                if (n2 != n) continue;
                arrayList.add(string3);
            }
            if (arrayList.isEmpty()) {
                arrayList.add("default");
            }
        }
        return new ProxyGroup(arrayList, string, plHideProxyPlayer.isLegacy(), plHidePro);
    }

    @Override
    public List<String> getTabcompleteList() {
        List<String> list = super.getTabcompleteList();
        if (this.isLegacy) {
            list.replaceAll(string -> "/" + string);
        }
        return list;
    }

    @Override
    protected List<String> getConfigList(Group.Type type) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.groupNameList) {
            arrayList.addAll(SimpleProxyGroup.getGroup(string2, this.plHide).getList(type, this.serverName));
            this.getInheritedGroups().forEach(string -> arrayList.addAll(SimpleProxyGroup.getGroup(string, this.plHide).getList(type, this.serverName)));
            this.replacePluginAndList(arrayList);
        }
        return arrayList.stream().distinct().collect(Collectors.toList());
    }

    @Override
    protected List<String> getInheritedGroups(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.groupNameList) {
            if (list.contains(string2.toLowerCase())) continue;
            list.add(string2.toLowerCase());
            arrayList.add(string2);
            IConfig iConfig = this.plHide.getConfig().getSection("groups");
            iConfig.getSection(string2).getStringList("inherited-groups").forEach(string -> {
                List<String> list3 = iConfig.getSection((String)string).getStringList("enabled_servers");
                for (String string2 : list3) {
                    if (!list3.contains("all") && !Pattern.matches(string2, this.serverName)) continue;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add((String)string);
                    arrayList.addAll(new ProxyGroup(arrayList, this.serverName, this.isLegacy, this.plHide).getInheritedGroups(list));
                    break;
                }
            });
        }
        return arrayList;
    }
}

