/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.group;

import eu.nononitas.plhidepro.PlHidePro;
import eu.nononitas.plhidepro.group.Group;
import eu.nononitas.plhidepro.miscellaneous.IConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;

public class SimpleProxyGroup {
    private static final HashMap<String, SimpleProxyGroup> cache = new HashMap();
    private final HashMap<String, List<String>> commandsMap = new HashMap();
    private final HashMap<String, List<String>> tabcompleteMap = new HashMap();

    private SimpleProxyGroup(String string, PlHidePro plHidePro) {
        IConfig iConfig = plHidePro.getConfig();
        IConfig iConfig2 = iConfig.getSection("groups", string, "servers");
        for (String string2 : iConfig2.getAllKeys()) {
            this.commandsMap.put(string2, iConfig2.getSection(string2).getStringList("commands"));
            this.tabcompleteMap.put(string2, iConfig2.getSection(string2).getStringList("tabcomplete"));
        }
    }

    public static void clearCache() {
        cache.clear();
    }

    public static SimpleProxyGroup getGroup(String string, PlHidePro plHidePro) {
        if (cache.containsKey(string)) {
            return cache.get(string);
        }
        SimpleProxyGroup simpleProxyGroup = new SimpleProxyGroup(string, plHidePro);
        cache.put(string, simpleProxyGroup);
        return simpleProxyGroup;
    }

    public List<String> getList(Group.Type type, String string) {
        HashMap<String, List<String>> hashMap = null;
        switch (type) {
            case COMMANDS: {
                hashMap = this.commandsMap;
                break;
            }
            case TABCOMPLETE: {
                hashMap = this.tabcompleteMap;
            }
        }
        ArrayList arrayList = new ArrayList();
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        hashMap.forEach((string2, list2) -> {
            if (Pattern.matches(string2, string)) {
                arrayList.addAll(list2);
                atomicBoolean.set(true);
            } else if (string2.equals("all")) {
                arrayList.addAll(list2);
            }
        });
        if (!atomicBoolean.get() && hashMap.containsKey("fallback")) {
            arrayList.addAll(hashMap.get("fallback"));
        }
        return Collections.unmodifiableList(arrayList);
    }
}

