/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.spigot.listeners;

import eu.nononitas.plhidepro.api.event.PlayerExecuteCommandEvent;
import eu.nononitas.plhidepro.api.group.IGroup;
import eu.nononitas.plhidepro.api.player.PlHidePlayer;
import eu.nononitas.plhidepro.modifier.CommandBlocker;
import eu.nononitas.plhidepro.spigot.PlHideProSpigot;
import eu.nononitas.plhidepro.spigot.miscellaneous.NMS_Version;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

public class CommandListener
implements Listener {
    private final PlHideProSpigot plhide;

    public CommandListener(PlHideProSpigot plHideProSpigot) {
        this.plhide = plHideProSpigot;
    }

    @EventHandler(ignoreCancelled=true)
    public void onCommand(PlayerCommandPreprocessEvent playerCommandPreprocessEvent) {
        Object object;
        if (this.plhide.isIsUsingProxy()) {
            return;
        }
        Player player = playerCommandPreprocessEvent.getPlayer();
        CharSequence[] charSequenceArray = playerCommandPreprocessEvent.getMessage().split(" ");
        NMS_Version nMS_Version = this.plhide.getNMS_Version();
        if (nMS_Version.isHigherThan(NMS_Version.V1_17_AND_LOWER) && (object = this.plhide.getPlugin().getConfig()).getBoolean("auto_lowercase_base_commands")) {
            charSequenceArray[0] = charSequenceArray[0].toLowerCase();
            playerCommandPreprocessEvent.setMessage(String.join((CharSequence)" ", charSequenceArray));
        }
        if (charSequenceArray[0].equalsIgnoreCase("/pl") || charSequenceArray[0].equalsIgnoreCase("/bukkit:pl") || charSequenceArray[0].equalsIgnoreCase("/plugins") || ((String)charSequenceArray[0]).equalsIgnoreCase("/bukkit:plugins")) {
            if (!player.hasPermission("plhide.bypass.pl-message")) {
                object = this.plhide.getColoredConfigString("/pl-message");
                if (!object.equals("none")) {
                    player.sendMessage((String)object);
                }
                playerCommandPreprocessEvent.setCancelled(true);
                return;
            }
            return;
        }
        if (!this.plhide.getPlayerManager().isRegistered(player)) {
            playerCommandPreprocessEvent.setCancelled(true);
            this.plhide.getPlugin().getLogger().warning(String.format("Received a command execution request from %s even though he is not registered. Aborting execution", player.getName()));
            return;
        }
        object = this.plhide.getPlayerManager().getPlHidePlayer(player);
        IGroup iGroup = object.getGroup();
        List<String> list = iGroup.getGroupNames();
        if (!list.isEmpty()) {
            String string = this.plhide.getColoredConfigString("groups." + list.get(0) + ".blocked-command-message");
            if (string == null) {
                this.plhide.getPlugin().getLogger().severe("The option blocked-command-message is missing for the group " + iGroup.getGroupNames().get(0) + ". Using default message");
                string = "Unknown command. Type \"/help\" for help.";
            }
            String string2 = playerCommandPreprocessEvent.getMessage().replaceFirst("/", "");
            CommandBlocker commandBlocker = new CommandBlocker((PlHidePlayer)object, string2);
            boolean bl = commandBlocker.isBlocked();
            string = string.replace("{player}", player.getName()).replace("{cmd}", string2);
            PlayerExecuteCommandEvent playerExecuteCommandEvent = new PlayerExecuteCommandEvent((PlHidePlayer)object, string2, bl, string);
            this.plhide.getEventManager().executeEvent(playerExecuteCommandEvent);
            if (playerExecuteCommandEvent.isBlocked()) {
                string = playerExecuteCommandEvent.getBlockedMessage();
                if (string != null && !string.equals("none")) {
                    player.sendMessage(string);
                }
                playerCommandPreprocessEvent.setCancelled(true);
                this.plhide.getLogger().debug("Command: " + playerExecuteCommandEvent.getCommand() + " was blocked for " + playerCommandPreprocessEvent.getPlayer().getName() + " | Groupmode: " + (Object)((Object)object.getGroupModeCommands()));
            }
        }
    }
}

