/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.spigot.listeners;

import eu.nononitas.plhidepro.spigot.PlHideProSpigot;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class OpListener
implements Listener {
    private final PlHideProSpigot plhide;
    private List<String> allowedOperators;
    private BukkitTask opChecker;

    public OpListener(PlHideProSpigot plHideProSpigot) {
        this.plhide = plHideProSpigot;
        this.allowedOperators = plHideProSpigot.getPlugin().getConfig().getStringList("allowed-operators");
    }

    public void startOpChecker() {
        if (this.opChecker != null) {
            return;
        }
        this.opChecker = new BukkitRunnable(){

            public void run() {
                if (OpListener.this.plhide.getPlugin().getConfig().getBoolean("op-protection")) {
                    Bukkit.getOperators().forEach(offlinePlayer -> {
                        if (!OpListener.this.allowedOperators.contains(offlinePlayer.getName())) {
                            offlinePlayer.setOp(false);
                            if (offlinePlayer.isOnline() && offlinePlayer.getPlayer() != null) {
                                Bukkit.getScheduler().runTask((Plugin)OpListener.this.plhide.getPlugin(), () -> offlinePlayer.getPlayer().kickPlayer(OpListener.this.plhide.getColoredConfigString("unauthorized-operator-kick-message")));
                            }
                        }
                    });
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.plhide.getPlugin(), 0L, 20L);
    }

    @EventHandler
    public void onLoginOpCheck(PlayerLoginEvent playerLoginEvent) {
        List list;
        Player player = playerLoginEvent.getPlayer();
        if (player.isOp() && this.plhide.getPlugin().getConfig().getBoolean("op-protection") && !(list = this.plhide.getPlugin().getConfig().getStringList("allowed-operators")).contains(player.getName())) {
            String string = this.plhide.getColoredConfigString("unauthorized-operator-kick-message");
            playerLoginEvent.setResult(PlayerLoginEvent.Result.KICK_OTHER);
            playerLoginEvent.setKickMessage(string);
            this.plhide.getPlugin().getServer().getConsoleSender().sendMessage(string);
            player.setOp(false);
        }
    }

    @EventHandler
    public void onOPServer(ServerCommandEvent serverCommandEvent) {
        if ((serverCommandEvent.getCommand().toLowerCase().startsWith("op ") || serverCommandEvent.getCommand().toLowerCase().startsWith("minecraft:op ")) && this.plhide.getPlugin().getConfig().getBoolean("op-protection") && this.isForbiddenOperator(serverCommandEvent.getCommand())) {
            serverCommandEvent.getSender().sendMessage(this.plhide.getColoredConfigString("op-message"));
            serverCommandEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onOpPlayer(PlayerCommandPreprocessEvent playerCommandPreprocessEvent) {
        if ((playerCommandPreprocessEvent.getPlayer().isOp() || playerCommandPreprocessEvent.getPlayer().hasPermission("*")) && (playerCommandPreprocessEvent.getMessage().toLowerCase().startsWith("/op ") || playerCommandPreprocessEvent.getMessage().toLowerCase().startsWith("/minecraft:op ")) && this.plhide.getPlugin().getConfig().getBoolean("op-protection") && this.isForbiddenOperator(playerCommandPreprocessEvent.getMessage())) {
            playerCommandPreprocessEvent.getPlayer().sendMessage(this.plhide.getColoredConfigString("op-message"));
            playerCommandPreprocessEvent.setCancelled(true);
        }
    }

    public void setAllowedOperators(List<String> list) {
        this.allowedOperators = list;
    }

    private boolean isForbiddenOperator(String string) {
        if (string.charAt(0) == '/') {
            string = string.replaceFirst("/", "");
        }
        for (String string2 : this.allowedOperators) {
            if (!string.equalsIgnoreCase("op " + string2) && !string.equalsIgnoreCase("minecraft:op " + string2)) continue;
            return false;
        }
        return true;
    }
}

