/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.velocity.listener;

import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.proxy.Player;
import dev.simplix.protocolize.api.Protocolize;
import eu.nononitas.plhidepro.PlHidePlayerManagerImpl;
import eu.nononitas.plhidepro.util.Updater;
import eu.nononitas.plhidepro.velocity.PlHideProVelocity;
import eu.nononitas.plhidepro.velocity.impl.PlHideVelocityPlayer;
import eu.nononitas.plhidepro.velocity.listener.BrandChannelListener;
import eu.nononitas.plhidepro.velocity.listener.TabCompleteRequestListener;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class JoinLeaveListener {
    private final PlHideProVelocity plhide;

    public JoinLeaveListener(PlHideProVelocity plHideProVelocity) {
        this.plhide = plHideProVelocity;
    }

    @Subscribe(order=PostOrder.LAST)
    public void onPlayerServerConnectedEvent(ServerConnectedEvent serverConnectedEvent) {
        PlHideVelocityPlayer plHideVelocityPlayer;
        Player player = serverConnectedEvent.getPlayer();
        PlHideProVelocity.getInstance().getPlayerCurrentServerMap().put(player.getUniqueId(), serverConnectedEvent.getServer().getServerInfo().getName());
        PlHidePlayerManagerImpl plHidePlayerManagerImpl = this.plhide.getPlayerManager();
        if (!plHidePlayerManagerImpl.isRegistered(player)) {
            plHideVelocityPlayer = new PlHideVelocityPlayer(player, this.plhide);
            plHidePlayerManagerImpl.registerPlayer(plHideVelocityPlayer);
        } else {
            plHideVelocityPlayer = (PlHideVelocityPlayer)plHidePlayerManagerImpl.getPlHidePlayer(player);
            plHideVelocityPlayer.updateGroup();
        }
        this.plhide.getLogger().debug("Registered player:" + player.getUsername() + " \nServer " + serverConnectedEvent.getServer().getServerInfo().getName() + " \nGroup " + plHideVelocityPlayer.getGroup().getGroupNames() + " \nGroup mode commands " + plHideVelocityPlayer.getGroupModeCommands() + " \nGroup mode tabcomplete " + plHideVelocityPlayer.getGroupModeTabcomplete() + " \nInherited groups " + plHideVelocityPlayer.getGroup().getInheritedGroups() + " \nUnblock pl-named-commands execution " + plHideVelocityPlayer.unblockPluginNamedCommandsExecution() + " \nUnblock pl-named-commands tabcomplete " + plHideVelocityPlayer.unblockPluginNamedCommandsTabcomplete());
        if (this.plhide.getRootConfigurationNode().getNode(new Object[]{"update-notify"}).getBoolean() && player.hasPermission("plhide.reload")) {
            this.plhide.getServer().getScheduler().buildTask((Object)PlHideProVelocity.getInstance(), () -> Updater.updatecheck(false).ifPresent(string -> player.sendMessage((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(string)))).schedule();
        }
        if (this.plhide.getRootConfigurationNode().getNode(new Object[]{"replace-f3-server-brand"}).getBoolean()) {
            Protocolize.playerProvider().player(serverConnectedEvent.getPlayer().getUniqueId()).sendPacket((Object)BrandChannelListener.createBrandPacket(player, serverConnectedEvent.getServer().getServerInfo().getName()));
        }
    }

    @Subscribe
    public void onPlayerDisconnectEvent(DisconnectEvent disconnectEvent) {
        Player player = disconnectEvent.getPlayer();
        this.plhide.getLogger().debug("Player " + disconnectEvent.getPlayer().getUsername() + " disconnected with LoginStatus " + disconnectEvent.getLoginStatus().name());
        if (disconnectEvent.getLoginStatus() != DisconnectEvent.LoginStatus.SUCCESSFUL_LOGIN && disconnectEvent.getLoginStatus() != DisconnectEvent.LoginStatus.PRE_SERVER_JOIN) {
            return;
        }
        this.plhide.getPlayerManager().unregisterPlayer(player);
        PlHideProVelocity.getInstance().getPlayerCurrentServerMap().remove(player.getUniqueId());
        TabCompleteRequestListener.inputMessageMap.remove(player.getUniqueId());
        this.plhide.getLogger().debug("Unregistered player: " + player.getUsername());
    }
}

