/*
 * Decompiled with CFR 0.152.
 */
package com.vanillage.raytraceantixray.tasks;

import com.vanillage.raytraceantixray.RayTraceAntiXray;
import java.util.TimerTask;
import java.util.concurrent.RejectedExecutionException;

public final class RayTraceTimerTask
extends TimerTask {
    private final RayTraceAntiXray plugin;

    public RayTraceTimerTask(RayTraceAntiXray plugin) {
        this.plugin = plugin;
    }

    @Override
    public void run() {
        boolean timingsEnabled = this.plugin.isTimingsEnabled();
        long start = timingsEnabled ? System.currentTimeMillis() : 0L;
        try {
            this.plugin.getExecutorService().invokeAll(this.plugin.getPlayerData().values());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (RejectedExecutionException e) {
            // empty catch block
        }
        if (timingsEnabled) {
            long stop = System.currentTimeMillis();
            this.plugin.getLogger().info(stop - start + "ms per ray trace tick.");
        }
    }
}

