/*
 * Decompiled with CFR 0.152.
 */
package com.vanillage.raytraceantixray.tasks;

import com.vanillage.raytraceantixray.RayTraceAntiXray;
import com.vanillage.raytraceantixray.data.ChunkBlocks;
import com.vanillage.raytraceantixray.data.PlayerData;
import com.vanillage.raytraceantixray.data.Result;
import io.netty.channel.Channel;
import java.util.Queue;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public final class UpdateBukkitRunnable
extends BukkitRunnable {
    private final RayTraceAntiXray plugin;

    public UpdateBukkitRunnable(RayTraceAntiXray plugin) {
        this.plugin = plugin;
    }

    public void run() {
        this.plugin.getServer().getOnlinePlayers().forEach(p -> {
            PlayerData playerData = this.plugin.getPlayerData().get(p.getUniqueId());
            World world = playerData.getLocations()[0].getWorld();
            if (!p.getWorld().equals(world)) {
                return;
            }
            Queue<Result> results = playerData.getResults();
            Result result = results.poll();
            while (result != null) {
                BlockPosition block;
                ChunkBlocks chunkBlocks = result.getChunkBlocks();
                if (chunkBlocks.getChunk() != null && playerData.getChunks().get(chunkBlocks.getKey()) == chunkBlocks && world.isChunkLoaded((block = result.getBlock()).u() >> 4, block.w() >> 4)) {
                    IBlockData blockState = result.isVisible() ? ((CraftWorld)world).getHandle().a_(block) : (world.getEnvironment() == World.Environment.NETHER ? Blocks.dV.o() : (world.getEnvironment() == World.Environment.THE_END ? Blocks.fy.o() : (block.v() < 0 ? Blocks.rD.o() : Blocks.b.o())));
                    UpdateBukkitRunnable.sendPacketImmediately(p, new PacketPlayOutBlockChange(block, blockState));
                }
                result = results.poll();
            }
        });
    }

    private static boolean sendPacketImmediately(Player player, Object packet) {
        PlayerConnection connection = ((CraftPlayer)player).getHandle().b;
        if (connection == null || connection.processedDisconnect) {
            return false;
        }
        Channel channel = connection.h.m;
        if (channel == null || !channel.isOpen()) {
            return false;
        }
        channel.writeAndFlush(packet);
        return true;
    }
}

