/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.module.internal.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin1531.jvm.internal.Intrinsics;
import kotlin1531.text.StringsKt;
import me.arasple.mc.trchat.api.config.Settings;
import me.arasple.mc.trchat.module.display.ChatSession;
import me.arasple.mc.trchat.module.display.channel.Channel;
import me.arasple.mc.trchat.module.display.function.EnderChestShow;
import me.arasple.mc.trchat.module.display.function.InventoryShow;
import me.arasple.mc.trchat.module.display.function.ItemShow;
import me.arasple.mc.trchat.taboolib.common.platform.Platform;
import me.arasple.mc.trchat.taboolib.common.platform.PlatformSide;
import me.arasple.mc.trchat.taboolib.common.platform.event.EventPriority;
import me.arasple.mc.trchat.taboolib.common.platform.event.SubscribeEvent;
import me.arasple.mc.trchat.taboolib.common.util.Strings;
import me.arasple.mc.trchat.taboolib.platform.util.BukkitLangKt;
import me.arasple.mc.trchat.util.BukkitUtilKt;
import me.arasple.mc.trchat.util.CooldownType;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.RegisteredListener;
import org.jetbrains.annotations.NotNull;

@PlatformSide(value={Platform.BUKKIT})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lme/arasple/mc/trchat/module/internal/listener/ListenerChat;", "", "()V", "checkLimits", "", "player", "Lorg/bukkit/entity/Player;", "message", "", "onChat", "", "e", "Lorg/bukkit/event/player/AsyncPlayerChatEvent;", "implementation-bukkit"})
public final class ListenerChat {
    @NotNull
    public static final ListenerChat INSTANCE = new ListenerChat();

    private ListenerChat() {
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onChat(@NotNull AsyncPlayerChatEvent e2) {
        Iterable $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        e2.setCancelled(true);
        Player player = e2.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"e.player");
        Player player2 = player;
        ChatSession session = BukkitUtilKt.getSession(player2);
        if (!BukkitUtilKt.checkMute(player2)) {
            return;
        }
        Object object = e2.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.message");
        if (!this.checkLimits(player2, (String)object)) {
            return;
        }
        object = e2.getHandlers().getRegisteredListeners();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.handlers.registeredListeners");
        object = object;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            RegisteredListener it = (RegisteredListener)element$iv$iv;
            boolean bl = false;
            if (!Settings.INSTANCE.getCONF().getStringList("Options.ChatEvent-Hooks").contains(it.getPlugin().getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RegisteredListener it = (RegisteredListener)element$iv;
            boolean bl = false;
            try {
                it.callEvent((Event)new AsyncPlayerChatEvent(e2.isAsynchronous(), e2.getPlayer(), e2.getMessage(), e2.getRecipients()));
            }
            catch (Throwable e3) {
                e3.printStackTrace();
            }
        }
        $this$forEach$iv = Channel.Companion.getChannels().values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Channel channel = (Channel)element$iv;
            boolean bl = false;
            List<String> list = channel.getBindings().getPrefix();
            if (list == null) continue;
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                String string = e2.getMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.message");
                if (!StringsKt.startsWith((String)string, (String)it, (boolean)true)) continue;
                string = e2.getMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.message");
                int n = it.length();
                boolean bl3 = false;
                String string2 = string.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                Channel.execute$default(channel, player2, string2, false, 4, null);
                return;
            }
        }
        object = session.getChannel();
        if (object != null) {
            String string = e2.getMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.message");
            Channel.execute$default((Channel)object, player2, string, false, 4, null);
        }
    }

    private final boolean checkLimits(Player player, String message) {
        boolean bl;
        Object object;
        block21: {
            boolean bl2;
            String it;
            boolean $i$f$any;
            block20: {
                boolean bl3;
                block19: {
                    long chatCooldown2;
                    String lastMessage;
                    if (player.hasPermission("trchat.bypass.*")) {
                        return true;
                    }
                    if (!player.hasPermission("trchat.bypass.chatlength") && message.length() > Settings.INSTANCE.getChatLengthLimit()) {
                        Object[] objectArray = new Object[]{message.length(), Settings.INSTANCE.getChatLengthLimit()};
                        BukkitLangKt.sendLang((CommandSender)player, "General-Too-Long", objectArray);
                        return false;
                    }
                    if (!player.hasPermission("trchat.bypass.repeat") && Strings.similarDegree(lastMessage = BukkitUtilKt.getSession(player).getLastMessage(), message) > Settings.INSTANCE.getChatSimilarity()) {
                        BukkitLangKt.sendLang((CommandSender)player, "General-Too-Similar", new Object[0]);
                        return false;
                    }
                    if (!player.hasPermission("trchat.bypass.chatcd") && (chatCooldown2 = BukkitUtilKt.getCooldownLeft(player, CooldownType.CHAT)) > 0L) {
                        Object[] objectArray = new Object[]{chatCooldown2 / (long)1000};
                        BukkitLangKt.sendLang((CommandSender)player, "Cooldowns-Chat", objectArray);
                        return false;
                    }
                    Iterable $this$any$iv = ItemShow.INSTANCE.getKeys();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            boolean bl4 = false;
                            if (!StringsKt.contains((CharSequence)message, (CharSequence)it, (boolean)true)) continue;
                            bl3 = true;
                            break block19;
                        }
                        bl3 = false;
                    }
                }
                if (bl3 && !player.hasPermission("trchat.bypass.itemcd")) {
                    long itemCooldown = BukkitUtilKt.getCooldownLeft(player, CooldownType.ITEM_SHOW);
                    if (itemCooldown > 0L) {
                        object = new Object[]{itemCooldown / (long)1000};
                        BukkitLangKt.sendLang((CommandSender)player, "Cooldowns-Item-Show", (Object[])object);
                        return false;
                    }
                    BukkitUtilKt.updateCooldown(player, CooldownType.ITEM_SHOW, ((Number)ItemShow.INSTANCE.getCooldown().get()).longValue());
                }
                Iterable $this$any$iv = InventoryShow.INSTANCE.getKeys();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (String)element$iv;
                        boolean bl5 = false;
                        if (!StringsKt.contains((CharSequence)message, (CharSequence)it, (boolean)true)) continue;
                        bl2 = true;
                        break block20;
                    }
                    bl2 = false;
                }
            }
            if (bl2 && !player.hasPermission("trchat.bypass.inventorycd")) {
                long inventoryCooldown = BukkitUtilKt.getCooldownLeft(player, CooldownType.INVENTORY_SHOW);
                if (inventoryCooldown > 0L) {
                    object = new Object[]{inventoryCooldown / (long)1000};
                    BukkitLangKt.sendLang((CommandSender)player, "Cooldowns-Inventory-Show", (Object[])object);
                    return false;
                }
                BukkitUtilKt.updateCooldown(player, CooldownType.INVENTORY_SHOW, ((Number)InventoryShow.INSTANCE.getCooldown().get()).longValue());
            }
            Iterable $this$any$iv = EnderChestShow.INSTANCE.getKeys();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (String)element$iv;
                    boolean bl6 = false;
                    if (!StringsKt.contains((CharSequence)message, (CharSequence)it, (boolean)true)) continue;
                    bl = true;
                    break block21;
                }
                bl = false;
            }
        }
        if (bl && !player.hasPermission("trchat.bypass.enderchestcd")) {
            long enderChestCooldown = BukkitUtilKt.getCooldownLeft(player, CooldownType.ENDERCHEST_SHOW);
            if (enderChestCooldown > 0L) {
                object = new Object[]{enderChestCooldown / (long)1000};
                BukkitLangKt.sendLang((CommandSender)player, "Cooldowns-EnderChest-Show", (Object[])object);
                return false;
            }
            BukkitUtilKt.updateCooldown(player, CooldownType.ENDERCHEST_SHOW, ((Number)EnderChestShow.INSTANCE.getCooldown().get()).longValue());
        }
        BukkitUtilKt.updateCooldown(player, CooldownType.CHAT, ((Number)Settings.INSTANCE.getChatCooldown().get()).longValue());
        return true;
    }
}

