/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.common;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.arasple.mc.trchat.taboolib.common.LifeCycle;
import me.arasple.mc.trchat.taboolib.common.env.RuntimeDependency;
import me.arasple.mc.trchat.taboolib.common.env.RuntimeEnv;
import me.arasple.mc.trchat.taboolib.common.inject.RuntimeInjector;
import me.arasple.mc.trchat.taboolib.common.platform.Platform;
import me.arasple.mc.trchat.taboolib.common.platform.PlatformFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RuntimeDependency(value="!com.google.code.gson:gson:2.8.7", test="!com.google.gson.JsonElement")
public class TabooLibCommon {
    private static Platform platform = Platform.APPLICATION;
    private static boolean stopped = false;
    private static boolean sysoutCatcherFound = false;
    private static boolean init = false;
    private static final Map<LifeCycle, List<Runnable>> postponeExecutor = new ConcurrentHashMap<LifeCycle, List<Runnable>>();
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");

    public static void testSetup() {
        TabooLibCommon.lifeCycle(LifeCycle.CONST);
        TabooLibCommon.lifeCycle(LifeCycle.INIT);
        TabooLibCommon.lifeCycle(LifeCycle.LOAD);
        TabooLibCommon.lifeCycle(LifeCycle.ENABLE);
    }

    public static void testCancel() {
        TabooLibCommon.lifeCycle(LifeCycle.DISABLE);
    }

    public static void postpone(LifeCycle lifeCycle, Runnable runnable) {
        postponeExecutor.computeIfAbsent(lifeCycle, list -> new ArrayList());
        postponeExecutor.get((Object)lifeCycle).add(runnable);
    }

    public static void lifeCycle(LifeCycle lifeCycle) {
        TabooLibCommon.lifeCycle(lifeCycle, null);
    }

    public static void lifeCycle(LifeCycle lifeCycle, @Nullable Platform platform2) {
        if (stopped) {
            return;
        }
        if (platform2 != null) {
            platform = platform2;
        }
        postponeExecutor.forEach((cycle, list) -> {
            if (cycle == lifeCycle) {
                list.forEach(runnable -> {
                    try {
                        runnable.run();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                });
                postponeExecutor.remove(cycle);
            }
        });
        switch (lifeCycle) {
            case CONST: {
                try {
                    RuntimeEnv.ENV.setup();
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
                if (!TabooLibCommon.isKotlinEnvironment()) break;
                init = true;
                PlatformFactory.INSTANCE.init();
                RuntimeInjector.injectAll(LifeCycle.CONST);
                break;
            }
            case INIT: {
                if (!init) break;
                RuntimeInjector.injectAll(LifeCycle.INIT);
                break;
            }
            case LOAD: {
                if (!init) {
                    if (TabooLibCommon.isKotlinEnvironment()) {
                        init = true;
                        PlatformFactory.INSTANCE.init();
                        RuntimeInjector.injectAll(LifeCycle.CONST);
                        RuntimeInjector.injectAll(LifeCycle.INIT);
                    } else {
                        stopped = true;
                        throw new RuntimeException("Runtime environment setup failed, please feedback!");
                    }
                }
                RuntimeInjector.injectAll(LifeCycle.LOAD);
                break;
            }
            case ENABLE: {
                RuntimeInjector.injectAll(LifeCycle.ENABLE);
                break;
            }
            case ACTIVE: {
                RuntimeInjector.injectAll(LifeCycle.ACTIVE);
                break;
            }
            case DISABLE: {
                RuntimeInjector.injectAll(LifeCycle.DISABLE);
                PlatformFactory.INSTANCE.cancel();
            }
        }
    }

    public static boolean isKotlinEnvironment() {
        try {
            Class.forName("kotlin1531.Lazy", false, TabooLibCommon.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    public static void print(Object message) {
        if (TabooLibCommon.isSysoutCatcherFound()) {
            if (System.console() != null) {
                System.console().printf(String.format("[%s INFO]: %s\n", dateTimeFormatter.format(LocalDateTime.now()), message), new Object[0]);
            }
        } else {
            System.out.println(message);
        }
    }

    @NotNull
    public static Platform getRunningPlatform() {
        return platform;
    }

    public static boolean isStopped() {
        return stopped;
    }

    public static void setStopped(boolean value) {
        stopped = value;
    }

    public static boolean isSysoutCatcherFound() {
        return sysoutCatcherFound;
    }

    static {
        try {
            Class.forName("io.papermc.paper.logging.SysoutCatcher");
            sysoutCatcherFound = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

