/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.common.env;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import me.arasple.mc.trchat.taboolib.common.TabooLibCommon;
import me.arasple.mc.trchat.taboolib.common.env.AbstractXmlParser;
import me.arasple.mc.trchat.taboolib.common.env.ClassAppender;
import me.arasple.mc.trchat.taboolib.common.env.Dependency;
import me.arasple.mc.trchat.taboolib.common.env.DependencyScope;
import me.arasple.mc.trchat.taboolib.common.env.DependencyVersion;
import me.arasple.mc.trchat.taboolib.common.env.JarRelocation;
import me.arasple.mc.trchat.taboolib.common.env.Repository;
import me.arasple.mc.trchat.taboolib.library.jarrelocator.JarRelocator;
import me.arasple.mc.trchat.taboolib.library.jarrelocator.Relocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DependencyDownloader
extends AbstractXmlParser {
    private static final Set<Dependency> injectedDependencies = new HashSet<Dependency>();
    private static final Set<Dependency> downloadedDependencies = new HashSet<Dependency>();
    private final Set<Repository> repositories = new HashSet<Repository>();
    private final Set<JarRelocation> relocation = new HashSet<JarRelocation>();
    private File baseDir = new File("libs");
    private DependencyScope[] dependencyScopes = new DependencyScope[]{DependencyScope.RUNTIME, DependencyScope.COMPILE};
    private boolean isDebugMode = true;
    private boolean ignoreOptional = true;
    private boolean ignoreException = false;

    public DependencyDownloader() {
    }

    public DependencyDownloader(@Nullable File baseDir) {
        this.baseDir = baseDir;
    }

    public DependencyDownloader(@Nullable File baseDir, @Nullable List<JarRelocation> relocation) {
        this.baseDir = baseDir;
        if (relocation != null) {
            for (JarRelocation rel : relocation) {
                if (rel == null) continue;
                this.relocation.add(rel);
            }
        }
    }

    private void createBaseDir() {
        this.baseDir.mkdirs();
    }

    public void injectClasspath(Set<Dependency> dependencies) {
        for (Dependency dep : dependencies) {
            if (injectedDependencies.contains(dep)) continue;
            File file = dep.getFile(this.baseDir, "jar");
            if (file.exists()) {
                TabooLibCommon.print(String.format("Loading library %s:%s:%s", dep.getGroupId(), dep.getArtifactId(), dep.getVersion()));
                if (this.relocation.isEmpty()) {
                    ClassAppender.addPath(file.toPath());
                } else {
                    File rel = new File(file.getPath() + "-" + this.relocation.hashCode() + ".jar");
                    if (!rel.exists() || rel.length() == 0L) {
                        try {
                            TabooLibCommon.print("Relocating ...");
                            List<Relocation> relocations = this.relocation.stream().map(JarRelocation::toRelocation).collect(Collectors.toList());
                            new JarRelocator(DependencyDownloader.copyFile(file, File.createTempFile(file.getName(), ".jar")), rel, relocations).run();
                        }
                        catch (IOException e2) {
                            throw new IllegalStateException(String.format("Unable to relocate %s%n", dep), e2);
                        }
                    }
                    ClassAppender.addPath(rel.toPath());
                }
                injectedDependencies.add(dep);
                continue;
            }
            TabooLibCommon.setStopped(true);
            throw new RuntimeException("Runtime not exist: " + file);
        }
    }

    public Set<Dependency> loadDependency(Collection<Repository> repositories, Dependency dependency) throws IOException {
        if (dependency.getVersion() == null) {
            Throwable e2 = null;
            for (Repository repository : repositories) {
                try {
                    repository.setVersion(dependency);
                    e2 = null;
                    break;
                }
                catch (IOException ex) {
                    if (e2 == null) {
                        e2 = new IOException(String.format("Unable to find latest version of %s", dependency));
                    }
                    e2.addSuppressed(ex);
                }
            }
            if (e2 != null) {
                DependencyVersion max = null;
                for (DependencyVersion ver : dependency.getInstalledVersions(this.baseDir)) {
                    if (max != null && ver.compareTo(max) <= 0) continue;
                    max = ver;
                }
                if (max == null) {
                    throw e2;
                }
                dependency.setVersion(max.toString());
            }
        }
        if (downloadedDependencies.contains(dependency)) {
            HashSet<Dependency> singleton = new HashSet<Dependency>();
            singleton.add(dependency);
            return singleton;
        }
        File pom = dependency.getFile(this.baseDir, "pom");
        File pom1 = new File(pom.getPath() + ".sha1");
        File file = dependency.getFile(this.baseDir, "jar");
        File jar1 = new File(file.getPath() + ".sha1");
        HashSet<Dependency> downloaded = new HashSet<Dependency>();
        downloaded.add(dependency);
        if (pom.exists() && pom1.exists() && file.exists() && jar1.exists() && DependencyDownloader.readFile(pom1).startsWith(DependencyDownloader.readFileHash(pom)) && DependencyDownloader.readFile(jar1).startsWith(DependencyDownloader.readFileHash(file))) {
            downloadedDependencies.add(dependency);
            if (pom.exists()) {
                downloaded.addAll(this.loadDependencyFromInputStream(pom.toURI().toURL().openStream()));
            }
            return downloaded;
        }
        pom.getParentFile().mkdirs();
        Throwable e3 = null;
        for (Repository repo : repositories) {
            try {
                repo.downloadToFile(dependency, pom);
                repo.downloadToFile(dependency, new File(pom.getPath() + ".sha1"));
                try {
                    repo.downloadToFile(dependency, file);
                    repo.downloadToFile(dependency, new File(file.getPath() + ".sha1"));
                }
                catch (IOException exception) {
                    try {
                        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder builder = factory.newDocumentBuilder();
                        Document xml = builder.parse(pom);
                        try {
                            if (DependencyDownloader.find("packaging", xml.getDocumentElement(), "pom").equals("jar")) {
                                throw exception;
                            }
                        }
                        catch (ParseException ex) {
                            ex.addSuppressed(exception);
                            throw new IOException("Unable to find packaging information in pom.xml", ex);
                        }
                    }
                    catch (ParserConfigurationException ex) {
                        ex.addSuppressed(exception);
                        throw new IOException("Unable to load pom.xml parser", ex);
                    }
                    catch (SAXException ex) {
                        ex.addSuppressed(exception);
                        throw new IOException("Unable to parse pom.xml", ex);
                    }
                    catch (IOException ex) {
                        if (!ex.equals(exception)) {
                            ex.addSuppressed(exception);
                        }
                        throw ex;
                    }
                }
                if (pom.exists()) {
                    downloaded.addAll(this.loadDependencyFromInputStream(pom.toURI().toURL().openStream()));
                }
                e3 = null;
                break;
            }
            catch (IOException ex) {
                if (e3 == null) {
                    e3 = new IOException(String.format("Unable to find download for %s (%s)", dependency, repo.getUrl()));
                }
                e3.addSuppressed(ex);
            }
        }
        if (e3 != null) {
            throw e3;
        }
        return downloaded;
    }

    public Set<Dependency> loadDependency(List<Repository> repositories, List<Dependency> dependencies) throws IOException {
        this.createBaseDir();
        HashSet<Dependency> downloaded = new HashSet<Dependency>();
        for (Dependency dep : dependencies) {
            downloaded.addAll(this.loadDependency(repositories, dep));
        }
        return downloaded;
    }

    public Set<Dependency> loadDependencyFromPom(Document pom, DependencyScope ... scopes) throws IOException {
        ArrayList<Repository> repos;
        ArrayList<Dependency> dependencies;
        block9: {
            int i;
            dependencies = new ArrayList<Dependency>();
            HashSet<DependencyScope> scopeSet = new HashSet<DependencyScope>(Arrays.asList(scopes));
            NodeList nodes = pom.getDocumentElement().getChildNodes();
            repos = new ArrayList<Repository>(this.repositories);
            if (repos.isEmpty()) {
                repos.add(new Repository());
            }
            try {
                for (i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    if (!node.getNodeName().equals("repositories")) continue;
                    nodes = ((Element)node).getElementsByTagName("repository");
                    for (i = 0; i < nodes.getLength(); ++i) {
                        Element e2 = (Element)nodes.item(i);
                        repos.add(new Repository(e2));
                    }
                    break;
                }
            }
            catch (ParseException ex) {
                throw new IOException("Unable to parse repositories", ex);
            }
            nodes = pom.getElementsByTagName("dependency");
            try {
                for (i = 0; i < nodes.getLength(); ++i) {
                    Dependency dep;
                    if (this.ignoreOptional && DependencyDownloader.find("optional", (Element)nodes.item(i), "false").equals("true") || !scopeSet.contains((Object)(dep = new Dependency((Element)nodes.item(i))).getScope())) continue;
                    dependencies.add(dep);
                }
            }
            catch (ParseException ex) {
                if (this.ignoreException) break block9;
                throw new IOException("Unable to parse dependencies", ex);
            }
        }
        return this.loadDependency(repos, dependencies);
    }

    public Set<Dependency> loadDependencyFromPom(Document pom) throws IOException {
        return this.loadDependencyFromPom(pom, this.dependencyScopes);
    }

    public Set<Dependency> loadDependencyFromInputStream(InputStream pom) throws IOException {
        return this.loadDependencyFromInputStream(pom, this.dependencyScopes);
    }

    public Set<Dependency> loadDependencyFromInputStream(InputStream pom, DependencyScope ... scopes) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document xml = builder.parse(pom);
            return this.loadDependencyFromPom(xml, scopes);
        }
        catch (ParserConfigurationException ex) {
            throw new IOException("Unable to load pom.xml parser", ex);
        }
        catch (SAXException ex) {
            throw new IOException("Unable to parse pom.xml", ex);
        }
    }

    public void addRepository(Repository repository) {
        this.repositories.add(repository);
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public DependencyDownloader setBaseDir(File baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    public DependencyScope[] getDependencyScopes() {
        return this.dependencyScopes;
    }

    public DependencyDownloader setDependencyScopes(DependencyScope[] dependencyScopes) {
        this.dependencyScopes = dependencyScopes;
        return this;
    }

    public boolean isDebugMode() {
        return this.isDebugMode;
    }

    public DependencyDownloader setDebugMode(boolean debugMode) {
        this.isDebugMode = debugMode;
        return this;
    }

    public Set<Dependency> getInjectedDependencies() {
        return injectedDependencies;
    }

    public Set<Repository> getRepositories() {
        return this.repositories;
    }

    public boolean isIgnoreOptional() {
        return this.ignoreOptional;
    }

    public DependencyDownloader setIgnoreOptional(boolean ignoreOptional) {
        this.ignoreOptional = ignoreOptional;
        return this;
    }

    public DependencyDownloader setIgnoreException(boolean ignoreException) {
        this.ignoreException = ignoreException;
        return this;
    }

    public Set<JarRelocation> getRelocation() {
        return this.relocation;
    }

    @NotNull
    public static String readFileHash(File file) {
        try {
            MessageDigest digest = MessageDigest.getInstance("sha-1");
            try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                int total;
                byte[] buffer = new byte[1024];
                while ((total = inputStream.read(buffer)) != -1) {
                    digest.update(buffer, 0, total);
                }
            }
            return DependencyDownloader.getHash(digest);
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            ex.printStackTrace();
            return "null (" + UUID.randomUUID() + ")";
        }
    }

    private static String getHash(MessageDigest digest) {
        StringBuilder result = new StringBuilder();
        for (byte b : digest.digest()) {
            result.append(String.format("%02x", b));
        }
        return result.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String readFile(File file) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            String string = DependencyDownloader.readFully(fileInputStream, StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return "null (" + UUID.randomUUID() + ")";
        }
    }

    public static String readFully(InputStream inputStream, Charset charset) throws IOException {
        return new String(DependencyDownloader.readFully(inputStream), charset);
    }

    public static byte[] readFully(InputStream inputStream) throws IOException {
        int len;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = inputStream.read(buf)) > 0) {
            stream.write(buf, 0, len);
        }
        return stream.toByteArray();
    }

    private static File copyFile(File file1, File file2) {
        try (FileInputStream fileIn = new FileInputStream(file1);
             FileOutputStream fileOut = new FileOutputStream(file2);
             FileChannel channelIn = fileIn.getChannel();
             FileChannel channelOut = fileOut.getChannel();){
            channelIn.transferTo(0L, channelIn.size(), channelOut);
        }
        catch (IOException t) {
            t.printStackTrace();
        }
        return file2;
    }
}

