/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.common5;

import me.arasple.mc.trchat.taboolib.common.Isolated;
import me.arasple.mc.trchat.taboolib.common.TabooLibCommon;
import me.arasple.mc.trchat.taboolib.common.platform.Platform;
import me.arasple.mc.trchat.taboolib.common.platform.ProxyPlayer;

@Isolated
public class Level {
    public static void setTotalExperience(ProxyPlayer player, int exp) {
        player.setExp(0.0f);
        player.setLevel(0);
        int amount = exp;
        while (amount > 0) {
            int expToLevel = Level.getExpAtLevel(player);
            if ((amount -= expToLevel) >= 0) {
                player.setExp(player.getExp() + (float)expToLevel);
                continue;
            }
            player.setExp(player.getExp() + (float)(amount += expToLevel));
            amount = 0;
        }
    }

    private static int getExpAtLevel(ProxyPlayer player) {
        return Level.getExpAtLevel(player.getLevel());
    }

    public static int getExpAtLevel(int level) {
        if (TabooLibCommon.getRunningPlatform() == Platform.NUKKIT) {
            if (level >= 30) {
                return 112 + (level - 30) * 9;
            }
            if (level >= 15) {
                return 37 + (level - 15) * 5;
            }
            return 7 + level * 2;
        }
        if (level <= 15) {
            return 2 * level + 7;
        }
        if (level <= 30) {
            return 5 * level - 38;
        }
        return 9 * level - 158;
    }

    public static int getExpToLevel(int level) {
        int exp = 0;
        for (int currentLevel = 0; currentLevel < level; ++currentLevel) {
            exp += Level.getExpAtLevel(currentLevel);
        }
        if (exp < 0) {
            exp = Integer.MAX_VALUE;
        }
        return exp;
    }

    public static int getTotalExperience(ProxyPlayer player) {
        int exp = Math.round((float)Level.getExpAtLevel(player) * player.getExp());
        int currentLevel = player.getLevel();
        while (currentLevel > 0) {
            exp += Level.getExpAtLevel(--currentLevel);
        }
        if (exp < 0) {
            exp = Integer.MAX_VALUE;
        }
        return exp;
    }

    public static int getExpUntilNextLevel(ProxyPlayer player) {
        int exp = Math.round((float)Level.getExpAtLevel(player) * player.getExp());
        int nextLevel = player.getLevel();
        return Level.getExpAtLevel(nextLevel) - exp;
    }
}

