/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.common5;

import java.util.concurrent.ConcurrentHashMap;
import me.arasple.mc.trchat.taboolib.common.Isolated;

@Isolated
public class LoreMap<T> {
    private final TrieNode root = new TrieNode();
    private final boolean ignorePrefix;
    private final boolean ignoreSpace;
    private final boolean ignoreColor;

    public LoreMap(boolean ignoreSpace, boolean ignoreColor, boolean ignorePrefix) {
        this.ignoreSpace = ignoreSpace;
        this.ignoreColor = ignoreColor;
        this.ignorePrefix = ignorePrefix;
    }

    public LoreMap() {
        this(true, true, false);
    }

    public void put(String lore, T value) {
        lore = lore.replaceAll("&", "\u00a7");
        if (this.ignoreSpace) {
            lore = lore.replaceAll("\\s", "");
        }
        if (this.ignoreColor) {
            lore = lore.replaceAll("\u00a7.", "");
        }
        TrieNode current = this.root;
        for (int depth = 0; depth < lore.length(); ++depth) {
            LoreChar c2 = new LoreChar(lore.charAt(depth));
            if (current.child.containsKey(c2)) {
                current = current.child.get(c2);
            } else {
                TrieNode node = new TrieNode();
                ++node.depth;
                node.pre = current;
                current.child.put(c2, node);
                current = node;
            }
            if (depth != lore.length() - 1) continue;
            current.obj = value;
        }
    }

    public T get(String lore) {
        int depth = 0;
        if (this.ignoreSpace) {
            lore = lore.replaceAll("\\s", "");
        }
        if (this.ignoreColor) {
            lore = lore.replaceAll("\u00a7.", "");
        }
        TrieNode current = this.root;
        if (this.ignorePrefix) {
            while (depth < lore.length() && !this.root.child.containsKey(new LoreChar(lore.charAt(depth)))) {
                ++depth;
            }
        }
        while (depth < lore.length()) {
            LoreChar c2 = new LoreChar(lore.charAt(depth));
            TrieNode node = current.child.get(c2);
            if (node == null) {
                return null;
            }
            if (node.obj != null) {
                return node.obj;
            }
            current = node;
            ++depth;
        }
        return null;
    }

    public MatchResult<T> getMatchResult(String lore) {
        int depth = 0;
        if (this.ignoreSpace) {
            lore = lore.replaceAll("\\s", "");
        }
        if (this.ignoreColor) {
            lore = lore.replaceAll("\u00a7.", "");
        }
        if (this.ignorePrefix) {
            while (depth < lore.length() && !this.root.child.containsKey(new LoreChar(lore.charAt(depth)))) {
                ++depth;
            }
        }
        TrieNode current = this.root;
        while (depth < lore.length()) {
            LoreChar c2 = new LoreChar(lore.charAt(depth));
            TrieNode node = current.child.get(c2);
            if (node == null) {
                return null;
            }
            if (node.obj != null) {
                return new MatchResult(depth < lore.length() - 1 ? lore.substring(depth + 1) : null, node.obj);
            }
            current = node;
            ++depth;
        }
        return null;
    }

    public void clear() {
        this.root.child.clear();
    }

    public static class LoreChar {
        private final char c;

        public LoreChar(char c2) {
            this.c = c2;
        }

        public char get() {
            return this.c;
        }

        public int hashCode() {
            return this.c;
        }

        public boolean equals(Object o) {
            return o instanceof LoreChar && ((LoreChar)o).c == this.c;
        }
    }

    public static class MatchResult<T> {
        public final String remain;
        public final T obj;

        public MatchResult(String remain, T obj2) {
            this.remain = remain;
            this.obj = obj2;
        }
    }

    public class TrieNode {
        final ConcurrentHashMap<LoreChar, TrieNode> child = new ConcurrentHashMap();
        TrieNode pre = null;
        T obj = null;
        int depth = 0;
    }
}

