/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.library.kether;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.arasple.mc.trchat.taboolib.library.kether.AbstractStringReader;
import me.arasple.mc.trchat.taboolib.library.kether.ActionProperties;
import me.arasple.mc.trchat.taboolib.library.kether.LoadError;
import me.arasple.mc.trchat.taboolib.library.kether.LocalizedException;
import me.arasple.mc.trchat.taboolib.library.kether.ParsedAction;
import me.arasple.mc.trchat.taboolib.library.kether.Quest;
import me.arasple.mc.trchat.taboolib.library.kether.QuestService;
import me.arasple.mc.trchat.taboolib.library.kether.SimpleQuest;
import me.arasple.mc.trchat.taboolib.library.kether.SimpleReader;
import me.arasple.mc.trchat.taboolib.library.kether.actions.LiteralAction;
import me.arasple.mc.trchat.taboolib.module.kether.Kether;
import me.arasple.mc.trchat.taboolib.module.kether.KetherError;

public class BlockReader
extends AbstractStringReader {
    protected final Map<String, Quest.Block> blocks;
    protected final QuestService<?> service;
    protected final List<String> namespace;
    protected String currentBlock;

    public BlockReader(char[] content, QuestService<?> service, List<String> namespace) {
        super(content);
        this.blocks = new HashMap<String, Quest.Block>();
        this.service = service;
        this.namespace = namespace;
    }

    public BlockReader(char[] arr, int index, int mark, Map<String, Quest.Block> blocks, QuestService<?> service, List<String> namespace, String currentBlock) {
        super(arr, index, mark);
        this.blocks = blocks;
        this.service = service;
        this.namespace = namespace;
        this.currentBlock = currentBlock;
    }

    public Quest parse(String id2) {
        while (this.hasNext()) {
            this.readBlock();
        }
        return new SimpleQuest(this.content, this.blocks, id2);
    }

    public void readBlock() {
        this.expect("def");
        String name2 = this.nextToken();
        this.expect("=");
        this.currentBlock = name2;
        List<ParsedAction<?>> actions = this.readActions();
        this.checkLiteral(actions);
        SimpleQuest.SimpleBlock block = new SimpleQuest.SimpleBlock(name2, actions);
        this.processActions(block, actions);
        this.blocks.put(name2, block);
    }

    public void checkLiteral(List<ParsedAction<?>> actions) {
        if (Kether.INSTANCE.isAllowToleranceParser()) {
            LiteralAction before = null;
            for (ParsedAction<?> action : actions) {
                if (before != null) {
                    throw KetherError.CUSTOM.create("Isolate literal \"" + before.getValue() + "\" is not end of block, maybe a misspelled action?");
                }
                if (!(action.getAction() instanceof LiteralAction)) continue;
                before = (LiteralAction)action.getAction();
            }
        }
    }

    public List<ParsedAction<?>> readActions() {
        boolean batch;
        this.skipBlank();
        boolean bl = batch = this.peek() == '{';
        if (batch) {
            this.skip(1);
        }
        SimpleReader reader = this.newActionReader(this.service, this.namespace);
        try {
            ArrayList list = new ArrayList();
            while (batch && reader.hasNext() || list.isEmpty()) {
                if (batch && reader.peek() == '}') {
                    reader.skip(1);
                    this.index = reader.index;
                    list.trimToSize();
                    return list;
                }
                list.add(reader.nextAction());
                reader.mark();
            }
            return list;
        }
        catch (Exception e2) {
            if (e2 instanceof LocalizedException) {
                String source = new String(this.content, reader.getMark(), Math.min(this.content.length, reader.getIndex()) - reader.getMark()).trim();
                throw LoadError.BLOCK_ERROR.create(this.currentBlock, BlockReader.lineOf(this.content, reader.getMark()), source).then((LocalizedException)e2);
            }
            e2.printStackTrace();
            throw LoadError.UNHANDLED.create(e2);
        }
    }

    protected ParsedAction<?> readAnonymousAction() {
        String name2;
        String lastBlock = this.currentBlock;
        this.currentBlock = name2 = this.nextAnonymousBlockName();
        List<ParsedAction<?>> actions = this.readActions();
        this.checkLiteral(actions);
        this.currentBlock = lastBlock;
        if (!actions.isEmpty()) {
            ParsedAction<?> head = actions.get(0);
            SimpleQuest.SimpleBlock block = new SimpleQuest.SimpleBlock(name2, actions);
            this.blocks.put(block.getLabel(), block);
            head.set(ActionProperties.BLOCK, block.getLabel());
            return head;
        }
        return ParsedAction.noop();
    }

    protected SimpleReader newActionReader(QuestService<?> service, List<String> namespace) {
        return new SimpleReader(service, this, namespace);
    }

    protected String nextAnonymousBlockName() {
        return this.currentBlock + "_anon_" + System.nanoTime();
    }

    protected void processActions(Quest.Block block, List<ParsedAction<?>> actions) {
        if (!actions.isEmpty()) {
            actions.get(0).set(ActionProperties.BLOCK, block.getLabel());
        }
    }

    protected static int lineOf(char[] chars, int index) {
        int line = 1;
        for (int i = 0; i < index; ++i) {
            if (chars[i] != '\n') continue;
            ++line;
        }
        return line;
    }

    public Map<String, Quest.Block> getBlocks() {
        return this.blocks;
    }

    public QuestService<?> getService() {
        return this.service;
    }

    public List<String> getNamespace() {
        return this.namespace;
    }

    public String getCurrentBlock() {
        return this.currentBlock;
    }
}

