/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.library.kether;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import me.arasple.mc.trchat.taboolib.library.kether.ExitStatus;
import me.arasple.mc.trchat.taboolib.library.kether.ParsedAction;
import me.arasple.mc.trchat.taboolib.library.kether.Quest;
import me.arasple.mc.trchat.taboolib.library.kether.QuestFuture;
import me.arasple.mc.trchat.taboolib.library.kether.QuestService;
import org.jetbrains.annotations.NotNull;

public interface QuestContext {
    public static final String BASE_BLOCK = "main";

    public QuestService<? extends QuestContext> getService();

    public Quest getQuest();

    public void setExitStatus(ExitStatus var1);

    public Optional<ExitStatus> getExitStatus();

    public CompletableFuture<Object> runActions();

    public Executor getExecutor();

    public void terminate();

    public Frame rootFrame();

    public static interface VarTable {
        public <T> Optional<T> get(@NotNull String var1) throws CompletionException;

        public <T> Optional<QuestFuture<T>> getFuture(@NotNull String var1);

        public void set(@NotNull String var1, Object var2);

        public void remove(@NotNull String var1);

        public void clear();

        public <T> void set(@NotNull String var1, @NotNull ParsedAction<T> var2, @NotNull CompletableFuture<T> var3);

        public Set<String> keys();

        public Collection<Map.Entry<String, Object>> values();

        public void initialize(@NotNull Frame var1);

        public void close();

        public VarTable parent();
    }

    public static interface Frame
    extends AutoCloseable {
        public String name();

        public QuestContext context();

        public Optional<ParsedAction<?>> currentAction();

        public List<Frame> children();

        default public Stream<Frame> walkFrames() {
            return this.walkFrames(Integer.MAX_VALUE);
        }

        default public Stream<Frame> walkFrames(int depth) {
            if (depth < 0) {
                return Stream.empty();
            }
            if (depth == 0) {
                return Stream.of(this);
            }
            return this.children().stream().map(it -> it.walkFrames(depth - 1)).reduce(Stream.of(this), Stream::concat);
        }

        public Optional<Frame> parent();

        public void setNext(@NotNull ParsedAction<?> var1);

        public void setNext(@NotNull Quest.Block var1);

        public Frame newFrame(@NotNull String var1);

        public Frame newFrame(@NotNull ParsedAction<?> var1);

        public VarTable variables();

        public <T extends AutoCloseable> T addClosable(T var1);

        public <T> CompletableFuture<T> run();

        @Override
        public void close();

        public boolean isDone();
    }
}

