/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.library.kether;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.arasple.mc.trchat.taboolib.library.kether.AbstractStringReader;
import me.arasple.mc.trchat.taboolib.library.kether.ActionProperties;
import me.arasple.mc.trchat.taboolib.library.kether.BlockReader;
import me.arasple.mc.trchat.taboolib.library.kether.LoadError;
import me.arasple.mc.trchat.taboolib.library.kether.ParsedAction;
import me.arasple.mc.trchat.taboolib.library.kether.QuestAction;
import me.arasple.mc.trchat.taboolib.library.kether.QuestActionParser;
import me.arasple.mc.trchat.taboolib.library.kether.QuestReader;
import me.arasple.mc.trchat.taboolib.library.kether.QuestService;
import me.arasple.mc.trchat.taboolib.library.kether.actions.LiteralAction;
import me.arasple.mc.trchat.taboolib.module.kether.Kether;
import me.arasple.mc.trchat.taboolib.module.kether.action.ActionGet;
import org.jetbrains.annotations.NotNull;

public class SimpleReader
extends AbstractStringReader
implements QuestReader {
    protected final List<String> namespace;
    protected final QuestService<?> service;
    protected final BlockReader blockParser;

    public SimpleReader(QuestService<?> service, BlockReader reader, List<String> namespace) {
        super(reader.content);
        this.service = service;
        this.blockParser = reader;
        this.index = reader.index;
        this.namespace = new ArrayList<String>(namespace);
        this.namespace.add("kether");
    }

    @Override
    public String nextToken() {
        this.skipBlank();
        switch (this.peek()) {
            case '\"': {
                int i;
                int cnt = 0;
                while (this.peek() == '\"') {
                    ++cnt;
                    this.skip(1);
                }
                int met = 0;
                for (i = this.index; i < this.content.length; ++i) {
                    if (this.content[i] == '\"') {
                        ++met;
                        continue;
                    }
                    if (met >= cnt) break;
                    met = 0;
                }
                if (met < cnt) {
                    throw LoadError.STRING_NOT_CLOSE.create(cnt);
                }
                String ret = new String(this.content, this.index, i - cnt - this.index);
                this.index = i;
                return ret;
            }
            case '\'': {
                this.skip(1);
                int i = this.index;
                while (this.peek() != '\'') {
                    this.skip(1);
                }
                String ret = new String(this.content, i, this.index - i);
                this.skip(1);
                return ret;
            }
        }
        return super.nextToken();
    }

    protected ParsedAction<?> nextAnonAction() {
        ParsedAction<?> parsedAction = this.blockParser.readAnonymousAction();
        parsedAction.set(ActionProperties.REQUIRE_FRAME, true);
        return parsedAction;
    }

    @Override
    public <T> ParsedAction<T> nextAction() {
        this.skipBlank();
        switch (this.peek()) {
            case '{': {
                this.blockParser.index = this.index;
                ParsedAction<?> action = this.nextAnonAction();
                this.index = this.blockParser.index;
                return action;
            }
            case '&': {
                this.skip(1);
                this.beforeParse();
                return this.wrap(new ActionGet(this.nextToken()));
            }
            case '*': {
                this.skip(1);
                this.beforeParse();
                return this.wrap(new LiteralAction(this.nextToken()));
            }
        }
        String element = this.nextToken();
        Optional<QuestActionParser> optional = this.service.getRegistry().getParser(element, this.namespace);
        if (optional.isPresent()) {
            this.beforeParse();
            return this.wrap(optional.get().resolve(this));
        }
        if (Kether.INSTANCE.isAllowToleranceParser()) {
            this.beforeParse();
            return this.wrap(new LiteralAction(element));
        }
        throw LoadError.UNKNOWN_ACTION.create(element);
    }

    protected void beforeParse() {
    }

    protected <T> ParsedAction<T> wrap(QuestAction<T> action) {
        return new ParsedAction<T>(action);
    }

    @Override
    public void expect(@NotNull String value) {
        super.expect(value);
    }

    public List<String> getNamespace() {
        return this.namespace;
    }

    public QuestService<?> getService() {
        return this.service;
    }

    public BlockReader getBlockParser() {
        return this.blockParser;
    }
}

