/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.module.ui;

import java.util.ArrayList;
import java.util.List;
import me.arasple.mc.trchat.taboolib.common.Isolated;
import me.arasple.mc.trchat.taboolib.platform.util.ItemModifierKt;
import org.bukkit.entity.Player;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

@Isolated
public abstract class ItemStacker {
    public static final ItemStacker MINECRAFT = new ItemStacker(){

        @Override
        public int getMaxStackSize(ItemStack itemStack) {
            return itemStack.getMaxStackSize();
        }
    };

    public abstract int getMaxStackSize(ItemStack var1);

    public void moveItemFromChest(ItemStack item2, Player player) {
        AddResult result = this.addItemAndMerge(item2, (Inventory)player.getInventory(), new ArrayList<Integer>());
        if (result.countOut > 0) {
            item2.setAmount(result.countOut);
            if (!this.addItemAndSplit(item2, (Inventory)player.getInventory(), 0, true)) {
                player.getWorld().dropItem(player.getLocation(), item2);
            }
        }
    }

    public boolean addItemAndSplit(ItemStack item2, Inventory inventory, int start) {
        return this.addItemAndSplit(item2, inventory, start, false);
    }

    public boolean addItemAndSplit(ItemStack item2, Inventory inventory, int start, boolean desc) {
        int i;
        int size;
        int n = size = inventory instanceof PlayerInventory || inventory instanceof CraftingInventory ? 36 : inventory.getSize();
        if (desc) {
            for (i = 8; i >= 0; --i) {
                if (!this.check(item2, inventory, i)) continue;
                return true;
            }
        }
        int n2 = i = desc ? start + 9 : start;
        while (i < size) {
            if (this.check(item2, inventory, i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean addItemFromChestToPlayer(ItemStack item2, Inventory inventory) {
        ItemStack itemClone;
        int i;
        for (i = 8; i >= 0; --i) {
            if (!ItemModifierKt.isAir(inventory.getItem(i))) continue;
            if (item2.getAmount() > this.getMaxStackSize(item2)) {
                itemClone = item2.clone();
                itemClone.setAmount(this.getMaxStackSize(item2));
                inventory.setItem(i, itemClone);
                item2.setAmount(item2.getAmount() - this.getMaxStackSize(item2));
                continue;
            }
            itemClone = item2.clone();
            itemClone.setAmount(item2.getAmount());
            inventory.setItem(i, itemClone);
            item2.setAmount(0);
            return true;
        }
        for (i = 35; i >= 9; --i) {
            if (!ItemModifierKt.isAir(inventory.getItem(i))) continue;
            if (item2.getAmount() > this.getMaxStackSize(item2)) {
                itemClone = item2.clone();
                itemClone.setAmount(this.getMaxStackSize(item2));
                inventory.setItem(i, itemClone);
                item2.setAmount(item2.getAmount() - this.getMaxStackSize(item2));
                continue;
            }
            itemClone = item2.clone();
            itemClone.setAmount(item2.getAmount());
            inventory.setItem(i, itemClone);
            item2.setAmount(0);
            return true;
        }
        return false;
    }

    public AddResult addItemAndMerge(ItemStack item2, Inventory inventory, List<Integer> ignore) {
        boolean changed = false;
        int count = item2.getAmount();
        int size = inventory instanceof PlayerInventory || inventory instanceof CraftingInventory ? 36 : inventory.getSize();
        for (int i = 0; i < size; ++i) {
            ItemStack inventoryItem;
            if (ignore.contains(i) || !item2.isSimilar(inventoryItem = inventory.getItem(i))) continue;
            while (count > 0 && inventoryItem.getAmount() < this.getMaxStackSize(item2)) {
                changed = true;
                inventoryItem.setAmount(inventoryItem.getAmount() + 1);
                --count;
            }
            if (count != 0) continue;
            return new AddResult(count, changed);
        }
        return new AddResult(count, changed);
    }

    private boolean check(ItemStack item2, Inventory inventory, int i) {
        if (ItemModifierKt.isAir(inventory.getItem(i))) {
            if (item2.getAmount() > this.getMaxStackSize(item2)) {
                ItemStack itemClone = item2.clone();
                itemClone.setAmount(this.getMaxStackSize(item2));
                inventory.setItem(i, itemClone);
                item2.setAmount(item2.getAmount() - this.getMaxStackSize(item2));
            } else {
                inventory.setItem(i, item2.clone());
                item2.setAmount(0);
                return true;
            }
        }
        return false;
    }

    public static class AddResult {
        private final int countOut;
        private final boolean changed;

        public AddResult(int countOut, boolean changed) {
            this.countOut = countOut;
            this.changed = changed;
        }

        public int getCountOut() {
            return this.countOut;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public String toString() {
            return "AddResult{countOut=" + this.countOut + ", changed=" + this.changed + '}';
        }
    }
}

