/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.guardianbeam;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public abstract class Laser {
    protected final int distanceSquared;
    protected final int duration;
    protected boolean durationInTicks = false;
    protected Location start;
    protected Location end;
    protected Plugin plugin;
    protected BukkitRunnable main;
    protected BukkitTask startMove;
    protected BukkitTask endMove;
    protected Set<Player> show = ConcurrentHashMap.newKeySet();
    private Set<Player> seen = new HashSet<Player>();
    private List<Runnable> executeEnd = new ArrayList<Runnable>(1);

    protected Laser(Location location, Location location2, int n, int n2) {
        if (!Packets.enabled) {
            throw new IllegalStateException("The Laser Beam API is disabled. An error has occured during initialization.");
        }
        if (location.getWorld() != location2.getWorld()) {
            throw new IllegalArgumentException("Locations do not belong to the same worlds.");
        }
        this.start = location;
        this.end = location2;
        this.duration = n;
        this.distanceSquared = n2 < 0 ? -1 : n2 * n2;
    }

    public Laser executeEnd(Runnable runnable) {
        this.executeEnd.add(runnable);
        return this;
    }

    public Laser durationInTicks() {
        this.durationInTicks = true;
        return this;
    }

    public void start(Plugin plugin) {
        if (this.main != null) {
            throw new IllegalStateException("Task already started");
        }
        this.plugin = plugin;
        this.main = new BukkitRunnable(){
            int time = 0;

            public void run() {
                try {
                    if (this.time == Laser.this.duration) {
                        this.cancel();
                        return;
                    }
                    if (!Laser.this.durationInTicks || this.time % 20 == 0) {
                        for (Player player : Laser.this.start.getWorld().getPlayers()) {
                            if (Laser.this.isCloseEnough(player)) {
                                if (!Laser.this.show.add(player)) continue;
                                Laser.this.sendStartPackets(player, !Laser.this.seen.add(player));
                                continue;
                            }
                            if (!Laser.this.show.remove(player)) continue;
                            Laser.this.sendDestroyPackets(player);
                        }
                    }
                    ++this.time;
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    reflectiveOperationException.printStackTrace();
                }
            }

            public synchronized void cancel() {
                super.cancel();
                Laser.this.main = null;
                try {
                    for (Player player : Laser.this.show) {
                        Laser.this.sendDestroyPackets(player);
                    }
                    Laser.this.show.clear();
                    Laser.this.executeEnd.forEach(Runnable::run);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    reflectiveOperationException.printStackTrace();
                }
            }
        };
        this.main.runTaskTimerAsynchronously(plugin, 0L, this.durationInTicks ? 1L : 20L);
    }

    public void stop() {
        if (this.main == null) {
            throw new IllegalStateException("Task not started");
        }
        this.main.cancel();
    }

    public boolean isStarted() {
        return this.main != null;
    }

    public abstract LaserType getLaserType();

    public abstract void moveStart(Location var1);

    public abstract void moveEnd(Location var1);

    public Location getStart() {
        return this.start;
    }

    public Location getEnd() {
        return this.end;
    }

    public void moveStart(Location location, int n, Runnable runnable) {
        this.startMove = this.moveInternal(location, n, this.startMove, this::getStart, this::moveStart, runnable);
    }

    public void moveEnd(Location location, int n, Runnable runnable) {
        this.endMove = this.moveInternal(location, n, this.endMove, this::getEnd, this::moveEnd, runnable);
    }

    private BukkitTask moveInternal(final Location location, final int n, BukkitTask bukkitTask, final Supplier<Location> supplier, final ReflectiveConsumer<Location> reflectiveConsumer, final Runnable runnable) {
        if (n <= 0) {
            throw new IllegalArgumentException("Ticks must be a positive value");
        }
        if (this.plugin == null) {
            throw new IllegalStateException("The laser must have been started a least once");
        }
        if (bukkitTask != null && !bukkitTask.isCancelled()) {
            bukkitTask.cancel();
        }
        return new BukkitRunnable(){
            double xPerTick;
            double yPerTick;
            double zPerTick;
            int elapsed;
            {
                this.xPerTick = (location.getX() - ((Location)supplier.get()).getX()) / (double)n;
                this.yPerTick = (location.getY() - ((Location)supplier.get()).getY()) / (double)n;
                this.zPerTick = (location.getZ() - ((Location)supplier.get()).getZ()) / (double)n;
                this.elapsed = 0;
            }

            public void run() {
                try {
                    reflectiveConsumer.accept(((Location)supplier.get()).add(this.xPerTick, this.yPerTick, this.zPerTick));
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    reflectiveOperationException.printStackTrace();
                    this.cancel();
                    return;
                }
                if (++this.elapsed == n) {
                    this.cancel();
                    if (runnable != null) {
                        runnable.run();
                    }
                }
            }
        }.runTaskTimer(this.plugin, 0L, 1L);
    }

    protected void moveFakeEntity(Location location, int n, Object object) {
        if (object != null) {
            Packets.moveFakeEntity(object, location);
        }
        if (this.main == null) {
            return;
        }
        Object object2 = object == null ? Packets.createPacketMoveEntity(location, n) : Packets.createPacketMoveEntity(object);
        for (Player player : this.show) {
            Packets.sendPackets(player, object2);
        }
    }

    protected abstract void sendStartPackets(Player var1, boolean var2);

    protected abstract void sendDestroyPackets(Player var1);

    protected boolean isCloseEnough(Player player) {
        if (this.distanceSquared == -1) {
            return true;
        }
        Location location = player.getLocation();
        return this.getStart().distanceSquared(location) <= (double)this.distanceSquared || this.getEnd().distanceSquared(location) <= (double)this.distanceSquared;
    }

    @FunctionalInterface
    public static interface ReflectiveConsumer<T> {
        public void accept(T var1) throws ReflectiveOperationException;
    }

    private static class Packets {
        private static AtomicInteger lastIssuedEID = new AtomicInteger(2000000000);
        private static Logger logger;
        private static int version;
        private static int versionMinor;
        private static String npack;
        private static String cpack;
        private static ProtocolMappings mappings;
        private static int crystalID;
        private static Object crystalType;
        private static Object squidType;
        private static Object guardianType;
        private static Constructor<?> crystalConstructor;
        private static Constructor<?> squidConstructor;
        private static Constructor<?> guardianConstructor;
        private static Object watcherObject1;
        private static Object watcherObject2;
        private static Object watcherObject3;
        private static Object watcherObject4;
        private static Object watcherObject5;
        private static Constructor<?> watcherConstructor;
        private static Method watcherSet;
        private static Method watcherRegister;
        private static Method watcherDirty;
        private static Method watcherPack;
        private static Constructor<?> blockPositionConstructor;
        private static Constructor<?> packetSpawnLiving;
        private static Constructor<?> packetSpawnNormal;
        private static Constructor<?> packetRemove;
        private static Constructor<?> packetTeleport;
        private static Constructor<?> packetMetadata;
        private static Class<?> packetTeam;
        private static Method createTeamPacket;
        private static Constructor<?> createTeam;
        private static Constructor<?> createScoreboard;
        private static Method setTeamPush;
        private static Object pushNever;
        private static Method getTeamPlayers;
        private static Method getHandle;
        private static Field playerConnection;
        private static Method sendPacket;
        private static Method setLocation;
        private static Method setUUID;
        private static Method setID;
        private static Object fakeSquid;
        private static Object fakeSquidWatcher;
        private static Object nmsWorld;
        public static boolean enabled;

        private Packets() {
        }

        static int generateEID() {
            return lastIssuedEID.getAndIncrement();
        }

        public static void sendPackets(Player player, Object ... objectArray) {
            Object object = playerConnection.get(getHandle.invoke((Object)player, new Object[0]));
            for (Object object2 : objectArray) {
                if (object2 == null) continue;
                sendPacket.invoke(object, object2);
            }
        }

        public static Object createFakeDataWatcher() {
            Object obj = watcherConstructor.newInstance(fakeSquid);
            if (version > 13) {
                Packets.setField(obj, "registrationLocked", false);
            }
            return obj;
        }

        public static void setDirtyWatcher(Object object) {
            if (version >= 15) {
                watcherDirty.invoke(object, watcherObject1);
            }
        }

        public static Object createSquid(Location location, UUID uUID, int n) {
            Object obj = squidConstructor.newInstance(squidType, nmsWorld);
            Packets.setEntityIDs(obj, uUID, n);
            Packets.moveFakeEntity(obj, location);
            return obj;
        }

        public static Object createGuardian(Location location, UUID uUID, int n) {
            Object obj = guardianConstructor.newInstance(guardianType, nmsWorld);
            Packets.setEntityIDs(obj, uUID, n);
            Packets.moveFakeEntity(obj, location);
            return obj;
        }

        public static Object createCrystal(Location location, UUID uUID, int n) {
            Object obj = crystalConstructor.newInstance(nmsWorld, location.getX(), location.getY(), location.getZ());
            Packets.setEntityIDs(obj, uUID, n);
            return obj;
        }

        public static Object createPacketEntitySpawnLiving(Location location, int n, UUID uUID, int n2) {
            Object obj = packetSpawnLiving.newInstance(new Object[0]);
            Packets.setField(obj, "a", n2);
            Packets.setField(obj, "b", uUID);
            Packets.setField(obj, "c", n);
            Packets.setField(obj, "d", location.getX());
            Packets.setField(obj, "e", location.getY());
            Packets.setField(obj, "f", location.getZ());
            Packets.setField(obj, "j", (byte)(location.getYaw() * 256.0f / 360.0f));
            Packets.setField(obj, "k", (byte)(location.getPitch() * 256.0f / 360.0f));
            if (version <= 14) {
                Packets.setField(obj, "m", fakeSquidWatcher);
            }
            return obj;
        }

        public static Object createPacketEntitySpawnNormal(Location location, int n, Object object, int n2) {
            Object obj = packetSpawnNormal.newInstance(new Object[0]);
            Packets.setField(obj, "a", n2);
            Packets.setField(obj, "b", UUID.randomUUID());
            Packets.setField(obj, "c", location.getX());
            Packets.setField(obj, "d", location.getY());
            Packets.setField(obj, "e", location.getZ());
            Packets.setField(obj, "i", (int)(location.getYaw() * 256.0f / 360.0f));
            Packets.setField(obj, "j", (int)(location.getPitch() * 256.0f / 360.0f));
            Packets.setField(obj, "k", version < 13 ? Integer.valueOf(n) : object);
            return obj;
        }

        public static Object createPacketEntitySpawnLiving(Object object) {
            return packetSpawnLiving.newInstance(object);
        }

        public static Object createPacketEntitySpawnNormal(Object object) {
            return packetSpawnNormal.newInstance(object);
        }

        public static void initGuardianWatcher(Object object, int n) {
            Packets.tryWatcherSet(object, watcherObject1, (byte)32);
            Packets.tryWatcherSet(object, watcherObject2, Boolean.FALSE);
            Packets.tryWatcherSet(object, watcherObject3, n);
        }

        public static void setCrystalWatcher(Object object, Location location) {
            Object obj = blockPositionConstructor.newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Packets.tryWatcherSet(object, watcherObject4, version < 13 ? com.google.common.base.Optional.of(obj) : Optional.of(obj));
            Packets.tryWatcherSet(object, watcherObject5, Boolean.FALSE);
        }

        public static Object[] createPacketsRemoveEntities(int ... nArray) {
            Object[] objectArray;
            if (version == 17 && versionMinor == 0) {
                objectArray = new Object[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    objectArray[i] = packetRemove.newInstance(nArray[i]);
                }
            } else {
                objectArray = new Object[]{packetRemove.newInstance(new Object[]{nArray})};
            }
            return objectArray;
        }

        public static Object createPacketMoveEntity(Location location, int n) {
            Object obj = packetTeleport.newInstance(new Object[0]);
            Packets.setField(obj, "a", n);
            Packets.setField(obj, "b", location.getX());
            Packets.setField(obj, "c", location.getY());
            Packets.setField(obj, "d", location.getZ());
            Packets.setField(obj, "e", (byte)(location.getYaw() * 256.0f / 360.0f));
            Packets.setField(obj, "f", (byte)(location.getPitch() * 256.0f / 360.0f));
            Packets.setField(obj, "g", true);
            return obj;
        }

        public static void setEntityIDs(Object object, UUID uUID, int n) {
            setUUID.invoke(object, uUID);
            setID.invoke(object, n);
        }

        public static void moveFakeEntity(Object object, Location location) {
            setLocation.invoke(object, location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getPitch()), Float.valueOf(location.getYaw()));
        }

        public static Object createPacketMoveEntity(Object object) {
            return packetTeleport.newInstance(object);
        }

        public static Object createPacketTeamCreate(String string, UUID ... uUIDArray) {
            Object object;
            if (version < 17) {
                object = packetTeam.newInstance();
                Packets.setField(object, "a", string);
                Packets.setField(object, "i", 0);
                Packets.setField(object, "f", "never");
                Collection collection = (Collection)Packets.getField(packetTeam, "h", object);
                for (UUID uUID : uUIDArray) {
                    collection.add(uUID.toString());
                }
            } else {
                Object obj = createTeam.newInstance(createScoreboard.newInstance(new Object[0]), string);
                setTeamPush.invoke(obj, pushNever);
                Collection collection = (Collection)getTeamPlayers.invoke(obj, new Object[0]);
                for (UUID uUID : uUIDArray) {
                    collection.add(uUID.toString());
                }
                object = createTeamPacket.invoke(null, obj, true);
            }
            return object;
        }

        private static Object createPacketMetadata(int n, Object object) {
            if (version < 19 || version == 19 && versionMinor < 3) {
                return packetMetadata.newInstance(n, object, false);
            }
            return packetMetadata.newInstance(n, watcherPack.invoke(object, new Object[0]));
        }

        private static void tryWatcherSet(Object object, Object object2, Object object3) {
            block2: {
                try {
                    watcherSet.invoke(object, object2, object3);
                }
                catch (InvocationTargetException invocationTargetException) {
                    watcherRegister.invoke(object, object2, object3);
                    if (version < 15) break block2;
                    watcherDirty.invoke(object, object2);
                }
            }
        }

        private static Method getMethod(Class<?> clazz, String string) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals(string)) continue;
                return method;
            }
            throw new NoSuchMethodException(string + " in " + clazz.getName());
        }

        private static void setField(Object object, String string, Object object2) {
            Field field = object.getClass().getDeclaredField(string);
            field.setAccessible(true);
            field.set(object, object2);
        }

        private static Object getField(Class<?> clazz, String string, Object object) {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            return field.get(object);
        }

        private static Class<?> getNMSClass(String string, String string2) {
            return Class.forName((version < 17 ? npack : "net.minecraft." + string) + "." + string2);
        }

        static {
            npack = "net.minecraft.server." + Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
            cpack = Bukkit.getServer().getClass().getPackage().getName() + ".";
            crystalID = 51;
            enabled = false;
            try {
                Object[] objectArray;
                Class[] classArray;
                Class[] classArray2;
                Constructor<?> constructor;
                Class[] classArray3;
                logger = new Logger("GuardianBeam", null){

                    @Override
                    public void log(LogRecord logRecord) {
                        logRecord.setMessage("[GuardianBeam] " + logRecord.getMessage());
                        super.log(logRecord);
                    }
                };
                logger.setParent(Bukkit.getServer().getLogger());
                logger.setLevel(Level.ALL);
                String[] stringArray = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3].substring(1).split("_");
                version = Integer.parseInt(stringArray[1]);
                versionMinor = version >= 17 ? ((stringArray = Bukkit.getBukkitVersion().split("-R")[0].split("\\.")).length <= 2 ? 0 : Integer.parseInt(stringArray[2])) : Integer.parseInt(stringArray[2].substring(1));
                logger.info("Found server version 1." + version + "." + versionMinor);
                mappings = ProtocolMappings.getMappings(version);
                if (mappings == null) {
                    mappings = ProtocolMappings.values()[ProtocolMappings.values().length - 1];
                    logger.warning("Loaded not matching version of the mappings for your server version (1." + version + "." + versionMinor + ")");
                }
                logger.info("Loaded mappings " + mappings.name());
                Class<?> clazz = Packets.getNMSClass("world.entity", "EntityTypes");
                Class<?> clazz2 = Packets.getNMSClass("world.entity", "Entity");
                Class<?> clazz3 = Packets.getNMSClass("world.entity.boss.enderdragon", "EntityEnderCrystal");
                Class<?> clazz4 = Packets.getNMSClass("world.entity.animal", "EntitySquid");
                Class<?> clazz5 = Packets.getNMSClass("world.entity.monster", "EntityGuardian");
                watcherObject1 = Packets.getField(clazz2, mappings.getWatcherFlags(), null);
                watcherObject2 = Packets.getField(clazz5, mappings.getWatcherSpikes(), null);
                watcherObject3 = Packets.getField(clazz5, mappings.getWatcherTargetEntity(), null);
                watcherObject4 = Packets.getField(clazz3, mappings.getWatcherTargetLocation(), null);
                watcherObject5 = Packets.getField(clazz3, mappings.getWatcherBasePlate(), null);
                if (version >= 13) {
                    crystalType = clazz.getDeclaredField(mappings.getCrystalTypeName()).get(null);
                    if (version >= 17) {
                        squidType = clazz.getDeclaredField(mappings.getSquidTypeName()).get(null);
                        guardianType = clazz.getDeclaredField(mappings.getGuardianTypeName()).get(null);
                    }
                }
                Class<?> clazz6 = Packets.getNMSClass("network.syncher", "DataWatcher");
                watcherConstructor = clazz6.getDeclaredConstructor(clazz2);
                if (version >= 18) {
                    watcherSet = clazz6.getDeclaredMethod("b", watcherObject1.getClass(), Object.class);
                    watcherRegister = clazz6.getDeclaredMethod("a", watcherObject1.getClass(), Object.class);
                } else {
                    watcherSet = Packets.getMethod(clazz6, "set");
                    watcherRegister = Packets.getMethod(clazz6, "register");
                }
                if (version >= 15) {
                    watcherDirty = Packets.getMethod(clazz6, "markDirty");
                }
                if (version > 19 || version == 19 && versionMinor >= 3) {
                    watcherPack = clazz6.getDeclaredMethod("b", new Class[0]);
                }
                Class<?> clazz7 = Packets.getNMSClass("network.protocol.game", "PacketPlayOutSpawnEntity");
                if (version < 17) {
                    classArray3 = new Class[]{};
                } else {
                    Class[] classArray4 = new Class[1];
                    classArray3 = classArray4;
                    classArray4[0] = Packets.getNMSClass("world.entity", "Entity");
                }
                packetSpawnNormal = clazz7.getDeclaredConstructor(classArray3);
                if (version >= 19) {
                    constructor = packetSpawnNormal;
                } else {
                    Class[] classArray5;
                    Class<?> clazz8 = Packets.getNMSClass("network.protocol.game", "PacketPlayOutSpawnEntityLiving");
                    if (version < 17) {
                        classArray5 = new Class[]{};
                    } else {
                        Class[] classArray6 = new Class[1];
                        classArray5 = classArray6;
                        classArray6[0] = Packets.getNMSClass("world.entity", "EntityLiving");
                    }
                    constructor = clazz8.getDeclaredConstructor(classArray5);
                }
                packetSpawnLiving = constructor;
                packetRemove = Packets.getNMSClass("network.protocol.game", "PacketPlayOutEntityDestroy").getDeclaredConstructor(version == 17 && versionMinor == 0 ? Integer.TYPE : int[].class);
                Class<?> clazz9 = Packets.getNMSClass("network.protocol.game", "PacketPlayOutEntityMetadata");
                if (version < 19 || version == 19 && versionMinor < 3) {
                    Class[] classArray7 = new Class[3];
                    classArray7[0] = Integer.TYPE;
                    classArray7[1] = clazz6;
                    classArray2 = classArray7;
                    classArray7[2] = Boolean.TYPE;
                } else {
                    Class[] classArray8 = new Class[2];
                    classArray8[0] = Integer.TYPE;
                    classArray2 = classArray8;
                    classArray8[1] = List.class;
                }
                packetMetadata = clazz9.getDeclaredConstructor(classArray2);
                Class<?> clazz10 = Packets.getNMSClass("network.protocol.game", "PacketPlayOutEntityTeleport");
                if (version < 17) {
                    classArray = new Class[]{};
                } else {
                    Class[] classArray9 = new Class[1];
                    classArray = classArray9;
                    classArray9[0] = clazz2;
                }
                packetTeleport = clazz10.getDeclaredConstructor(classArray);
                packetTeam = Packets.getNMSClass("network.protocol.game", "PacketPlayOutScoreboardTeam");
                blockPositionConstructor = Packets.getNMSClass("core", "BlockPosition").getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                nmsWorld = Class.forName(cpack + "CraftWorld").getDeclaredMethod("getHandle", new Class[0]).invoke(Bukkit.getWorlds().get(0), new Object[0]);
                squidConstructor = clazz4.getDeclaredConstructors()[0];
                if (version >= 17) {
                    guardianConstructor = clazz5.getDeclaredConstructors()[0];
                    crystalConstructor = clazz3.getDeclaredConstructor(nmsWorld.getClass().getSuperclass(), Double.TYPE, Double.TYPE, Double.TYPE);
                }
                if (version < 14) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = nmsWorld;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = clazz.getDeclaredField(mappings.getSquidTypeName()).get(null);
                    objectArray = objectArray3;
                    objectArray3[1] = nmsWorld;
                }
                Object[] objectArray4 = objectArray;
                fakeSquid = squidConstructor.newInstance(objectArray4);
                fakeSquidWatcher = Packets.createFakeDataWatcher();
                Packets.tryWatcherSet(fakeSquidWatcher, watcherObject1, (byte)32);
                getHandle = Class.forName(cpack + "entity.CraftPlayer").getDeclaredMethod("getHandle", new Class[0]);
                playerConnection = Packets.getNMSClass("server.level", "EntityPlayer").getDeclaredField(version < 17 ? "playerConnection" : "b");
                sendPacket = Packets.getNMSClass("server.network", "PlayerConnection").getMethod(version < 18 ? "sendPacket" : "a", Packets.getNMSClass("network.protocol", "Packet"));
                if (version >= 17) {
                    setLocation = clazz2.getDeclaredMethod(version < 18 ? "setLocation" : "a", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
                    setUUID = clazz2.getDeclaredMethod("a_", UUID.class);
                    setID = clazz2.getDeclaredMethod("e", Integer.TYPE);
                    createTeamPacket = packetTeam.getMethod("a", Packets.getNMSClass("world.scores", "ScoreboardTeam"), Boolean.TYPE);
                    Class<?> clazz11 = Packets.getNMSClass("world.scores", "Scoreboard");
                    Class<?> clazz12 = Packets.getNMSClass("world.scores", "ScoreboardTeam");
                    Class<?> clazz13 = Packets.getNMSClass("world.scores", "ScoreboardTeamBase$EnumTeamPush");
                    createTeam = clazz12.getDeclaredConstructor(clazz11, String.class);
                    createScoreboard = clazz11.getDeclaredConstructor(new Class[0]);
                    setTeamPush = clazz12.getDeclaredMethod(mappings.getTeamSetCollision(), clazz13);
                    pushNever = clazz13.getDeclaredField("b").get(null);
                    getTeamPlayers = clazz12.getDeclaredMethod(mappings.getTeamGetPlayers(), new Class[0]);
                }
                enabled = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                String string = "Laser Beam reflection failed to initialize. The util is disabled. Please ensure your version (" + Bukkit.getServer().getClass().getPackage().getName() + ") is supported.";
                if (logger == null) {
                    System.err.println(string);
                }
                logger.severe(string);
            }
        }

        private static enum ProtocolMappings {
            V1_9(9, "Z", "bA", "bB", "b", "c", 94, 68),
            V1_10(10, V1_9),
            V1_11(11, V1_10),
            V1_12(12, V1_11),
            V1_13(13, "ac", "bF", "bG", "b", "c", 70, 28),
            V1_14(14, "W", "b", "bD", "c", "d", 73, 30),
            V1_15(15, "T", "b", "bA", "c", "d", 74, 31),
            V1_16(16, null, "b", "d", "c", "d", -1, 31){

                @Override
                public int getSquidID() {
                    return versionMinor < 2 ? 74 : 81;
                }

                @Override
                public String getWatcherFlags() {
                    return versionMinor < 2 ? "T" : "S";
                }
            }
            ,
            V1_17(17, "Z", "b", "e", "c", "d", 86, 35, "K", "aJ", "u", "setCollisionRule", "getPlayerNameSet"),
            V1_18(18, null, "b", "e", "c", "d", 86, 35, "K", "aJ", "u", "a", "g"){

                @Override
                public String getWatcherFlags() {
                    return versionMinor < 2 ? "aa" : "Z";
                }
            }
            ,
            V1_19(19, null, "b", "e", "c", "d", 89, 38, null, null, "w", "a", "g"){

                @Override
                public String getWatcherFlags() {
                    return versionMinor < 4 ? "Z" : "an";
                }

                @Override
                public int getGuardianID() {
                    return versionMinor < 3 ? 38 : 39;
                }

                @Override
                public String getSquidTypeName() {
                    if (versionMinor < 3) {
                        return "aM";
                    }
                    if (versionMinor == 3) {
                        return "aN";
                    }
                    return "aT";
                }

                @Override
                public String getGuardianTypeName() {
                    if (versionMinor < 3) {
                        return "N";
                    }
                    if (versionMinor == 3) {
                        return "O";
                    }
                    return "V";
                }
            };

            private final int major;
            private final String watcherFlags;
            private final String watcherSpikes;
            private final String watcherTargetEntity;
            private final String watcherTargetLocation;
            private final String watcherBasePlate;
            private final int squidID;
            private final int guardianID;
            private final String guardianTypeName;
            private final String squidTypeName;
            private final String crystalTypeName;
            private final String teamSetCollision;
            private final String teamGetPlayers;

            private ProtocolMappings(int n2, ProtocolMappings protocolMappings) {
                this(n2, protocolMappings.watcherFlags, protocolMappings.watcherSpikes, protocolMappings.watcherTargetEntity, protocolMappings.watcherTargetLocation, protocolMappings.watcherBasePlate, protocolMappings.squidID, protocolMappings.guardianID, protocolMappings.guardianTypeName, protocolMappings.squidTypeName, protocolMappings.crystalTypeName, protocolMappings.teamSetCollision, protocolMappings.teamGetPlayers);
            }

            private ProtocolMappings(int n2, String string2, String string3, String string4, String string5, String string6, int n3, int n4) {
                this(n2, string2, string3, string4, string5, string6, n3, n4, null, "SQUID", "END_CRYSTAL", null, null);
            }

            private ProtocolMappings(int n2, String string2, String string3, String string4, String string5, String string6, int n3, int n4, String string7, String string8, String string9, String string10, String string11) {
                this.major = n2;
                this.watcherFlags = string2;
                this.watcherSpikes = string3;
                this.watcherTargetEntity = string4;
                this.watcherTargetLocation = string5;
                this.watcherBasePlate = string6;
                this.squidID = n3;
                this.guardianID = n4;
                this.guardianTypeName = string7;
                this.squidTypeName = string8;
                this.crystalTypeName = string9;
                this.teamSetCollision = string10;
                this.teamGetPlayers = string11;
            }

            public int getMajor() {
                return this.major;
            }

            public String getWatcherFlags() {
                return this.watcherFlags;
            }

            public String getWatcherSpikes() {
                return this.watcherSpikes;
            }

            public String getWatcherTargetEntity() {
                return this.watcherTargetEntity;
            }

            public String getWatcherTargetLocation() {
                return this.watcherTargetLocation;
            }

            public String getWatcherBasePlate() {
                return this.watcherBasePlate;
            }

            public int getSquidID() {
                return this.squidID;
            }

            public int getGuardianID() {
                return this.guardianID;
            }

            public String getGuardianTypeName() {
                return this.guardianTypeName;
            }

            public String getSquidTypeName() {
                return this.squidTypeName;
            }

            public String getCrystalTypeName() {
                return this.crystalTypeName;
            }

            public String getTeamSetCollision() {
                return this.teamSetCollision;
            }

            public String getTeamGetPlayers() {
                return this.teamGetPlayers;
            }

            public static ProtocolMappings getMappings(int n) {
                for (ProtocolMappings protocolMappings : ProtocolMappings.values()) {
                    if (n != protocolMappings.getMajor()) continue;
                    return protocolMappings;
                }
                return null;
            }
        }
    }

    public static enum LaserType {
        GUARDIAN,
        ENDER_CRYSTAL;


        public Laser create(Location location, Location location2, int n, int n2) {
            switch (this) {
                case ENDER_CRYSTAL: {
                    return new CrystalLaser(location, location2, n, n2);
                }
                case GUARDIAN: {
                    return new GuardianLaser(location, location2, n, n2);
                }
            }
            throw new IllegalStateException();
        }
    }

    public static class CrystalLaser
    extends Laser {
        private Object createCrystalPacket;
        private Object metadataPacketCrystal;
        private Object[] destroyPackets;
        private Object fakeCrystalDataWatcher;
        private final Object crystal;
        private final int crystalID = Packets.generateEID();

        public CrystalLaser(Location location, Location location2, int n, int n2) {
            super(location, location2, n, n2);
            this.fakeCrystalDataWatcher = Packets.createFakeDataWatcher();
            Packets.setCrystalWatcher(this.fakeCrystalDataWatcher, location2);
            this.crystal = Packets.version < 17 ? null : Packets.createCrystal(location, UUID.randomUUID(), this.crystalID);
            this.metadataPacketCrystal = Packets.createPacketMetadata(this.crystalID, this.fakeCrystalDataWatcher);
            this.destroyPackets = Packets.createPacketsRemoveEntities(this.crystalID);
        }

        private Object getCrystalSpawnPacket() {
            if (this.createCrystalPacket == null) {
                this.createCrystalPacket = Packets.version < 17 ? Packets.createPacketEntitySpawnNormal(this.start, Packets.crystalID, Packets.crystalType, this.crystalID) : Packets.createPacketEntitySpawnNormal(this.crystal);
            }
            return this.createCrystalPacket;
        }

        @Override
        public LaserType getLaserType() {
            return LaserType.ENDER_CRYSTAL;
        }

        @Override
        protected void sendStartPackets(Player player, boolean bl) {
            Packets.sendPackets(player, this.getCrystalSpawnPacket());
            Packets.sendPackets(player, this.metadataPacketCrystal);
        }

        @Override
        protected void sendDestroyPackets(Player player) {
            Packets.sendPackets(player, this.destroyPackets);
        }

        @Override
        public void moveStart(Location location) {
            this.start = location;
            this.createCrystalPacket = null;
            this.moveFakeEntity(this.start, this.crystalID, this.crystal);
        }

        @Override
        public void moveEnd(Location location) {
            this.end = location;
            if (this.main != null) {
                Packets.setCrystalWatcher(this.fakeCrystalDataWatcher, location);
                this.metadataPacketCrystal = Packets.createPacketMetadata(this.crystalID, this.fakeCrystalDataWatcher);
                for (Player player : this.show) {
                    Packets.sendPackets(player, this.metadataPacketCrystal);
                }
            }
        }
    }

    public static class GuardianLaser
    extends Laser {
        private static AtomicInteger teamID = new AtomicInteger(ThreadLocalRandom.current().nextInt(0, Integer.MAX_VALUE));
        private Object createGuardianPacket;
        private Object createSquidPacket;
        private Object teamCreatePacket;
        private Object[] destroyPackets;
        private Object metadataPacketGuardian;
        private Object metadataPacketSquid;
        private Object fakeGuardianDataWatcher;
        private final UUID squidUUID = UUID.randomUUID();
        private final UUID guardianUUID = UUID.randomUUID();
        private final int squidID = Packets.generateEID();
        private final int guardianID = Packets.generateEID();
        private Object squid;
        private Object guardian;
        private int targetID;
        private UUID targetUUID;
        protected LivingEntity endEntity;
        private Location correctStart;
        private Location correctEnd;

        public GuardianLaser(Location location, Location location2, int n, int n2) {
            super(location, location2, n, n2);
            this.initSquid();
            this.targetID = this.squidID;
            this.targetUUID = this.squidUUID;
            this.initLaser();
        }

        public GuardianLaser(Location location, LivingEntity livingEntity, int n, int n2) {
            super(location, livingEntity.getLocation(), n, n2);
            this.targetID = livingEntity.getEntityId();
            this.targetUUID = livingEntity.getUniqueId();
            this.initLaser();
        }

        private void initLaser() {
            this.fakeGuardianDataWatcher = Packets.createFakeDataWatcher();
            Packets.initGuardianWatcher(this.fakeGuardianDataWatcher, this.targetID);
            if (Packets.version >= 17) {
                this.guardian = Packets.createGuardian(this.getCorrectStart(), this.guardianUUID, this.guardianID);
            }
            this.metadataPacketGuardian = Packets.createPacketMetadata(this.guardianID, this.fakeGuardianDataWatcher);
            this.teamCreatePacket = Packets.createPacketTeamCreate("noclip" + teamID.getAndIncrement(), this.squidUUID, this.guardianUUID);
            this.destroyPackets = Packets.createPacketsRemoveEntities(this.squidID, this.guardianID);
        }

        private void initSquid() {
            if (Packets.version >= 17) {
                this.squid = Packets.createSquid(this.getCorrectEnd(), this.squidUUID, this.squidID);
            }
            this.metadataPacketSquid = Packets.createPacketMetadata(this.squidID, Packets.fakeSquidWatcher);
            Packets.setDirtyWatcher(Packets.fakeSquidWatcher);
        }

        private Object getGuardianSpawnPacket() {
            if (this.createGuardianPacket == null) {
                this.createGuardianPacket = Packets.version < 17 ? Packets.createPacketEntitySpawnLiving(this.getCorrectStart(), Packets.mappings.getGuardianID(), this.guardianUUID, this.guardianID) : Packets.createPacketEntitySpawnLiving(this.guardian);
            }
            return this.createGuardianPacket;
        }

        private Object getSquidSpawnPacket() {
            if (this.createSquidPacket == null) {
                this.createSquidPacket = Packets.version < 17 ? Packets.createPacketEntitySpawnLiving(this.getCorrectEnd(), Packets.mappings.getSquidID(), this.squidUUID, this.squidID) : Packets.createPacketEntitySpawnLiving(this.squid);
            }
            return this.createSquidPacket;
        }

        @Override
        public LaserType getLaserType() {
            return LaserType.GUARDIAN;
        }

        public void attachEndEntity(LivingEntity livingEntity) {
            if (livingEntity.getWorld() != this.start.getWorld()) {
                throw new IllegalArgumentException("Attached entity is not in the same world as the laser.");
            }
            this.endEntity = livingEntity;
            this.setTargetEntity(livingEntity.getUniqueId(), livingEntity.getEntityId());
        }

        public Entity getEndEntity() {
            return this.endEntity;
        }

        private void setTargetEntity(UUID uUID, int n) {
            this.targetUUID = uUID;
            this.targetID = n;
            this.fakeGuardianDataWatcher = Packets.createFakeDataWatcher();
            Packets.initGuardianWatcher(this.fakeGuardianDataWatcher, this.targetID);
            this.metadataPacketGuardian = Packets.createPacketMetadata(this.guardianID, this.fakeGuardianDataWatcher);
            for (Player player : this.show) {
                Packets.sendPackets(player, this.metadataPacketGuardian);
            }
        }

        @Override
        public Location getEnd() {
            return this.endEntity == null ? this.end : this.endEntity.getLocation();
        }

        protected Location getCorrectStart() {
            if (this.correctStart == null) {
                this.correctStart = this.start.clone();
                this.correctStart.subtract(0.0, 0.5, 0.0);
            }
            return this.correctStart;
        }

        protected Location getCorrectEnd() {
            if (this.correctEnd == null) {
                this.correctEnd = this.end.clone();
                this.correctEnd.subtract(0.0, 0.5, 0.0);
                Vector vector = this.correctEnd.toVector().subtract(this.getCorrectStart().toVector()).normalize();
                if (Double.isNaN(vector.getX())) {
                    vector.setX(0);
                }
                if (Double.isNaN(vector.getY())) {
                    vector.setY(0);
                }
                if (Double.isNaN(vector.getZ())) {
                    vector.setZ(0);
                }
                this.correctEnd.subtract(vector);
            }
            return this.correctEnd;
        }

        @Override
        protected boolean isCloseEnough(Player player) {
            return player == this.endEntity || super.isCloseEnough(player);
        }

        @Override
        protected void sendStartPackets(Player player, boolean bl) {
            if (this.squid == null) {
                Packets.sendPackets(player, this.getGuardianSpawnPacket(), this.metadataPacketGuardian);
            } else {
                Packets.sendPackets(player, this.getGuardianSpawnPacket(), this.getSquidSpawnPacket(), this.metadataPacketGuardian, this.metadataPacketSquid);
            }
            if (!bl) {
                Packets.sendPackets(player, this.teamCreatePacket);
            }
        }

        @Override
        protected void sendDestroyPackets(Player player) {
            Packets.sendPackets(player, this.destroyPackets);
        }

        @Override
        public void moveStart(Location location) {
            this.start = location;
            this.correctStart = null;
            this.createGuardianPacket = null;
            this.moveFakeEntity(this.getCorrectStart(), this.guardianID, this.guardian);
            if (this.squid != null) {
                this.correctEnd = null;
                this.createSquidPacket = null;
                this.moveFakeEntity(this.getCorrectEnd(), this.squidID, this.squid);
            }
        }

        @Override
        public void moveEnd(Location location) {
            this.end = location;
            this.createSquidPacket = null;
            this.correctEnd = null;
            if (this.squid == null) {
                this.initSquid();
                for (Player player : this.show) {
                    Packets.sendPackets(player, this.getSquidSpawnPacket(), this.metadataPacketSquid);
                }
            } else {
                this.moveFakeEntity(this.getCorrectEnd(), this.squidID, this.squid);
            }
            if (this.targetUUID != this.squidUUID) {
                this.endEntity = null;
                this.setTargetEntity(this.squidUUID, this.squidID);
            }
        }

        public void callColorChange() {
            for (Player player : this.show) {
                Packets.sendPackets(player, this.metadataPacketGuardian);
            }
        }
    }
}

