/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.animations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.davidml16.acubelets.animations.FakeBlock;
import me.davidml16.acubelets.utils.Cuboid;
import me.davidml16.acubelets.utils.XSeries.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class AnimationBlocks
extends BukkitRunnable {
    private Set<BlockState> blockStates;
    private Location[] locations;
    private Map<Integer, FakeBlock[]> fakeBlocks;
    private Location boxLocation;
    private int step;

    public AnimationBlocks(Location location) {
        this.boxLocation = location;
        this.step = 1;
        this.blockStates = new HashSet<BlockState>();
        Cuboid cuboid = new Cuboid(location.clone().add(2.0, -1.0, 2.0), location.clone().add(-2.0, 3.0, -2.0));
        for (Block block : cuboid) {
            this.addBlockState(block.getState());
        }
        this.fakeBlocks = new HashMap<Integer, FakeBlock[]>();
        this.locations = new Location[]{this.boxLocation.clone().add(0.0, -1.0, 0.0), this.boxLocation.clone().add(1.0, -1.0, 0.0), this.boxLocation.clone().add(-1.0, -1.0, 0.0), this.boxLocation.clone().add(0.0, -1.0, 1.0), this.boxLocation.clone().add(0.0, -1.0, -1.0), this.boxLocation.clone().add(1.0, -1.0, 1.0), this.boxLocation.clone().add(1.0, -1.0, -1.0), this.boxLocation.clone().add(-1.0, -1.0, 1.0), this.boxLocation.clone().add(-1.0, -1.0, -1.0), this.boxLocation.clone().add(2.0, -1.0, 0.0), this.boxLocation.clone().add(-2.0, -1.0, 0.0), this.boxLocation.clone().add(0.0, -1.0, 2.0), this.boxLocation.clone().add(0.0, -1.0, -2.0), this.boxLocation.clone().add(2.0, -1.0, 1.0), this.boxLocation.clone().add(2.0, -1.0, -1.0), this.boxLocation.clone().add(-2.0, -1.0, 1.0), this.boxLocation.clone().add(-2.0, -1.0, -1.0), this.boxLocation.clone().add(1.0, -1.0, 2.0), this.boxLocation.clone().add(-1.0, -1.0, 2.0), this.boxLocation.clone().add(1.0, -1.0, -2.0), this.boxLocation.clone().add(-1.0, -1.0, -2.0), this.boxLocation.clone().add(2.0, -1.0, 2.0), this.boxLocation.clone().add(2.0, -1.0, -2.0), this.boxLocation.clone().add(-2.0, -1.0, 2.0), this.boxLocation.clone().add(-2.0, -1.0, -2.0), this.boxLocation.clone().add(2.0, 0.0, 2.0), this.boxLocation.clone().add(2.0, 0.0, -2.0), this.boxLocation.clone().add(-2.0, 0.0, 2.0), this.boxLocation.clone().add(-2.0, 0.0, -2.0), this.boxLocation.clone().add(2.0, 1.0, 2.0), this.boxLocation.clone().add(2.0, 1.0, -2.0), this.boxLocation.clone().add(-2.0, 1.0, 2.0), this.boxLocation.clone().add(-2.0, 1.0, -2.0)};
    }

    public void run() {
        int n = this.step / 6;
        FakeBlock[] fakeBlockArray = this.getStepFakeBlocks(n);
        for (Player player : Bukkit.getOnlinePlayers()) {
            for (FakeBlock fakeBlock : fakeBlockArray) {
                this.sendBlock(player, fakeBlock);
            }
        }
        ++this.step;
    }

    public void addBlockState(BlockState blockState) {
        this.blockStates.add(blockState);
    }

    public Location getLocation(int n) {
        if (this.locations.length < n) {
            return null;
        }
        return this.locations[n];
    }

    public Map<Integer, FakeBlock[]> getFakeBlocks() {
        return this.fakeBlocks;
    }

    public void setFakeBlocks(Map<Integer, FakeBlock[]> map) {
        this.fakeBlocks = map;
    }

    public FakeBlock[] getStepFakeBlocks(int n) {
        ArrayList<FakeBlock> arrayList = new ArrayList<FakeBlock>();
        if (n > this.fakeBlocks.keySet().size()) {
            n = this.fakeBlocks.keySet().size() + 1;
        }
        for (int i = 1; i <= n; ++i) {
            if (!this.fakeBlocks.containsKey(i)) continue;
            arrayList.addAll(Arrays.asList(this.fakeBlocks.get(i)));
        }
        FakeBlock[] fakeBlockArray = new FakeBlock[arrayList.size()];
        arrayList.toArray(fakeBlockArray);
        return fakeBlockArray;
    }

    public void setStepFakeBlocks(int n, FakeBlock[] fakeBlockArray) {
        this.fakeBlocks.put(n, fakeBlockArray);
    }

    public void restore() {
        for (BlockState blockState : this.blockStates) {
            blockState.update(true);
        }
        this.blockStates = null;
        this.locations = null;
        this.fakeBlocks = null;
        this.boxLocation = null;
    }

    public void sendBlock(Player player, FakeBlock fakeBlock) {
        if (fakeBlock.getLocation() == null) {
            return;
        }
        if (XMaterial.supports(13)) {
            BlockData blockData = Bukkit.createBlockData((Material)fakeBlock.getXMaterial().parseMaterial());
            if (fakeBlock.hasBlockFace()) {
                ((Directional)blockData).setFacing(fakeBlock.getBlockFace());
            }
            player.sendBlockChange(fakeBlock.getLocation(), blockData);
        } else {
            byte by;
            Material material;
            if (fakeBlock.getAltXMaterial() == null && fakeBlock.getAltMaterial() == null) {
                material = fakeBlock.getXMaterial().parseMaterial();
                by = fakeBlock.getXMaterial().getData();
            } else if (fakeBlock.getAltXMaterial() != null && fakeBlock.getAltMaterial() == null) {
                material = fakeBlock.getAltXMaterial().parseMaterial();
                by = fakeBlock.getAltXMaterial().getData();
            } else {
                material = fakeBlock.getAltMaterial();
                by = fakeBlock.getAltXMaterial().getData();
            }
            if (!fakeBlock.hasBlockFace()) {
                player.sendBlockChange(fakeBlock.getLocation(), material, by);
            } else {
                int n = 0;
                BlockFace blockFace = fakeBlock.getBlockFace();
                if (blockFace == BlockFace.WEST) {
                    n = 1;
                } else if (blockFace == BlockFace.EAST) {
                    n = 0;
                } else if (blockFace == BlockFace.NORTH) {
                    n = 3;
                } else if (blockFace == BlockFace.SOUTH) {
                    n = 2;
                }
                player.sendBlockChange(fakeBlock.getLocation(), material, (byte)n);
            }
        }
    }
}

