/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.animations;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.animations.Animation;
import me.davidml16.acubelets.animations.AnimationSettings;
import me.davidml16.acubelets.animations.animation.animation2.Animation2_Task;
import me.davidml16.acubelets.utils.ConfigUpdater;
import me.davidml16.acubelets.utils.XSeries.XItemStack;
import me.davidml16.acubelets.utils.XSeries.XMaterial;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class AnimationHandler {
    private final Main main;
    private final Map<String, AnimationSettings> animations;
    private List<Animation> tasks;
    private List<Entity> entities;
    private File file;
    private YamlConfiguration config;
    public static String DEFAULT_ANIMATION = "animation2";
    public static int ANIMATION_COUNT = 21;
    private static List<ItemStack> animationItems = Arrays.asList(XMaterial.BARRIER.parseItem(), XMaterial.FIREWORK_STAR.parseItem(), XMaterial.CRAFTING_TABLE.parseItem(), XMaterial.FIREWORK_ROCKET.parseItem(), XMaterial.NETHERRACK.parseItem(), XMaterial.SANDSTONE.parseItem(), XMaterial.LIME_WOOL.parseItem(), XMaterial.PUMPKIN.parseItem(), XMaterial.RED_WOOL.parseItem(), XMaterial.LADDER.parseItem(), XMaterial.FIRE_CHARGE.parseItem(), XMaterial.ENDER_EYE.parseItem(), XMaterial.CAULDRON.parseItem(), XMaterial.PRISMARINE_SHARD.parseItem(), XMaterial.POPPY.parseItem(), XMaterial.BLAZE_POWDER.parseItem(), XMaterial.PINK_WOOL.parseItem(), XMaterial.SNOWBALL.parseItem(), XMaterial.DIAMOND.parseItem(), XMaterial.ANVIL.parseItem(), XMaterial.ENDER_PEARL.parseItem());

    public AnimationHandler(Main main) {
        this.main = main;
        this.animations = new HashMap<String, AnimationSettings>();
        this.tasks = new ArrayList<Animation>();
        this.entities = new ArrayList<Entity>();
    }

    public void loadAnimations() {
        File file = new File(this.main.getDataFolder(), "animations.yml");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        try {
            ConfigUpdater.update((Plugin)this.main, "animations.yml", new File(this.main.getDataFolder(), "animations.yml"), Collections.emptyList());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        this.file = file;
        this.config = yamlConfiguration;
        this.animations.clear();
        for (int i = 0; i < ANIMATION_COUNT; ++i) {
            AnimationSettings animationSettings = new AnimationSettings("animation" + i);
            String string = "animation_" + i;
            animationSettings.setAnimationNumber(i);
            animationSettings.setEnabled(yamlConfiguration.getBoolean("animations." + string + ".Enabled", true));
            animationSettings.setDisplayName(yamlConfiguration.getString("animations." + string + ".DisplayName", "Unknown"));
            animationSettings.setOutlineParticles(yamlConfiguration.getBoolean("animations." + string + ".OutlineParticles", true));
            animationSettings.setFloorParticles(yamlConfiguration.getBoolean("animations." + string + ".FloorParticles", true));
            animationSettings.setAroundParticles(yamlConfiguration.getBoolean("animations." + animationSettings + ".AroundParticles", true));
            animationSettings.setNeedPermission(yamlConfiguration.getBoolean("animations." + animationSettings + ".NeedPermission", true));
            if (yamlConfiguration.contains("animations." + string + ".Icon") && yamlConfiguration.getConfigurationSection("animations." + string + ".Icon") != null) {
                ItemStack itemStack = XItemStack.deserializeIcon((FileConfiguration)yamlConfiguration, "animations." + string + ".Icon", false);
                if (itemStack != null) {
                    animationSettings.setDisplayItem(itemStack);
                }
            } else {
                animationSettings.setDisplayItem(animationItems.get(i));
            }
            this.animations.put("animation" + i, animationSettings);
        }
        DEFAULT_ANIMATION = yamlConfiguration.getString("default_animation", "animation2");
        this.saveAnimations();
    }

    public void saveAnimations() {
        this.config.set("default_animation", (Object)DEFAULT_ANIMATION);
        for (AnimationSettings animationSettings : this.animations.values()) {
            String string = "animation_" + animationSettings.getAnimationNumber();
            this.config.set("animations." + string, null);
            this.config.set("animations." + string + ".Enabled", (Object)animationSettings.isEnabled());
            this.config.set("animations." + string + ".DisplayName", (Object)animationSettings.getDisplayName());
            this.config.set("animations." + string + ".OutlineParticles", (Object)animationSettings.isOutlineParticles());
            this.config.set("animations." + string + ".FloorParticles", (Object)animationSettings.isFloorParticles());
            this.config.set("animations." + string + ".AroundParticles", (Object)animationSettings.isAroundParticles());
            this.config.set("animations." + string + ".NeedPermission", (Object)animationSettings.isNeedPermission());
            XItemStack.serializeIcon(animationSettings.getDisplayItem(), (FileConfiguration)this.config, "animations." + string + ".Icon", false);
        }
        try {
            this.config.save(this.file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            ConfigUpdater.update((Plugin)this.main, "animations.yml", new File(this.main.getDataFolder(), "animations.yml"), Collections.emptyList());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public AnimationSettings getAnimationSetting(String string) {
        return this.animations.containsKey(string) ? this.animations.get(string) : null;
    }

    public Animation getAnimation(String string) {
        AnimationSettings animationSettings = this.getAnimationSetting(string);
        Animation animation = null;
        if (animationSettings != null) {
            int n = animationSettings.getAnimationNumber();
            try {
                Class<?> clazz = Class.forName("me.davidml16.acubelets.animations.animation.animation" + n + ".Animation" + n + "_Task");
                Constructor<?> constructor = clazz.getConstructor(Main.class, AnimationSettings.class);
                animation = (Animation)constructor.newInstance(new Object[]{this.main, animationSettings});
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
        }
        return animation != null ? animation : new Animation2_Task(this.main, this.getAnimationSetting("animation2"));
    }

    public List<AnimationSettings> getAnimationsAvailable(Player player) {
        ArrayList<AnimationSettings> arrayList = new ArrayList<AnimationSettings>();
        for (AnimationSettings animationSettings : this.getAnimations().values()) {
            if (animationSettings.getAnimationNumber() == 0 || animationSettings.isNeedPermission() && !this.haveAnimationPermission(player, animationSettings)) continue;
            arrayList.add(animationSettings);
        }
        return arrayList;
    }

    public List<AnimationSettings> getAnimationSettings() {
        ArrayList<AnimationSettings> arrayList = new ArrayList<AnimationSettings>();
        for (AnimationSettings animationSettings : this.animations.values()) {
            if (!animationSettings.getId().equalsIgnoreCase(DEFAULT_ANIMATION) && !animationSettings.isEnabled()) continue;
            arrayList.add(animationSettings);
        }
        return arrayList;
    }

    public AnimationSettings getRandomAnimation(Player player) {
        List<AnimationSettings> list = this.getAnimationsAvailable(player);
        return list.get(ThreadLocalRandom.current().nextInt(list.size()) % list.size());
    }

    public AnimationSettings getRandomAnimation() {
        ArrayList<AnimationSettings> arrayList = new ArrayList<AnimationSettings>(this.getAnimations().values());
        return (AnimationSettings)arrayList.get(ThreadLocalRandom.current().nextInt(arrayList.size()) % arrayList.size());
    }

    public boolean haveAnimationPermission(Player player, AnimationSettings animationSettings) {
        return animationSettings.getId().equalsIgnoreCase(DEFAULT_ANIMATION) || player.hasPermission("acubelets.animations.*") || player.hasPermission("acubelets.animations.animation" + animationSettings.getAnimationNumber());
    }

    public List<Animation> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<Animation> list) {
        this.tasks = list;
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public void setEntities(List<Entity> list) {
        this.entities = list;
    }

    public Map<String, AnimationSettings> getAnimations() {
        return this.animations;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(YamlConfiguration yamlConfiguration) {
        this.config = yamlConfiguration;
    }
}

